/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.io.rb;
import ro.sync.util.BasicEqualer;
import ro.sync.util.BasicURLUtil;
import ro.sync.util.d;
import ro.sync.util.security.f;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class FileSystemUtil {
    private static final Logger e = Logger.getLogger((String)FileSystemUtil.class.getName());
    private static int g = 130000;
    private static final String h = "[^A-Za-z0-9.]";
    public static final String f = "OxygenXMLTemp";
    public static final Comparator<File> c = new d();
    private static final String[] d = new String[]{" KB", " MB", " GB"};
    private static final DecimalFormat b = new DecimalFormat("###.##");

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        block5: {
            File file3 = file2.getParentFile();
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Could not create folder: " + file3);
            }
            FileSystemUtil.copyInputStreamToOutputStream(new FileInputStream(file), new FileOutputStream(file2), true);
            try {
                file2.setLastModified(file.lastModified());
                if (!bl) {
                    if (!file.canWrite()) {
                        file2.setReadOnly();
                    }
                    file2.setExecutable(file.canExecute());
                    file2.setReadable(file.canRead());
                    file2.setWritable(file.canWrite());
                }
            }
            catch (SecurityException securityException) {
                if (!e.isDebugEnabled()) break block5;
                e.debug((Object)securityException, (Throwable)securityException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, g);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, g);
        try {
            int n2;
            byte[] byArray = new byte[16384];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            finally {
                if (bl) {
                    bufferedOutputStream.close();
                } else {
                    bufferedOutputStream.flush();
                }
            }
        }
    }

    public static void copyDir(File file, File file2, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        FileSystemUtil.copyDir(file, file2, bl, bl2, null);
    }

    public static void copyDir(File file, File file2, boolean bl, boolean bl2, FileFilter fileFilter) throws FileNotFoundException, IOException {
        File[] fileArray;
        if (file == null) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (!file2.exists()) {
            if (!file2.mkdirs()) {
                throw new IOException("The destination folder \"" + file2.getAbsolutePath() + "\" cannot be created.");
            }
            if (!bl2 && !file.canWrite()) {
                file2.setReadOnly();
            }
        } else if (!file2.canWrite()) {
            throw new IOException("The destination folder \"" + file2.getAbsolutePath() + "\" is not accessible.");
        }
        File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    if (!bl) continue;
                    FileSystemUtil.copyDir(fileArray[i2], new File(file2, fileArray[i2].getName()), true, bl2, fileFilter);
                    continue;
                }
                FileSystemUtil.copyFile(fileArray[i2], new File(file2, fileArray[i2].getName()), bl2);
            }
        }
    }

    public static void deleteRecursivelly(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    FileSystemUtil.deleteRecursivelly(fileArray[i2]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canCreateAndRename(File file) {
        boolean bl = false;
        if (file != null && file.exists() && file.isDirectory()) {
            String string = System.currentTimeMillis() + "0";
            File file2 = new File(file, string);
            try {
                boolean bl2 = file2.createNewFile();
                if (bl2 && file2.exists()) {
                    String string2 = System.currentTimeMillis() + "1";
                    File file3 = new File(file, string2);
                    boolean bl3 = file2.renameTo(file3);
                    if (bl3) {
                        bl = true;
                    }
                    file3.delete();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                file2.delete();
            }
        }
        return bl;
    }

    public static void listRecursively(File[] fileArray, boolean bl, FileFilter fileFilter, List<File> list) {
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file = fileArray[i2];
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] fileArray2;
                if (bl) {
                    list.add(file);
                }
                if ((fileArray2 = file.listFiles(fileFilter)) == null) continue;
                FileSystemUtil.listRecursively(fileArray2, bl, fileFilter, list);
                continue;
            }
            list.add(file);
        }
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return FileSystemUtil.createTempFile(string, string2, null);
    }

    public static File createTempFile(final String string, final String string2, final File file) throws IOException {
        try {
            return ro.sync.util.security.f.j(515L, new PrivilegedExceptionAction<File>(){

                public File b() throws Exception {
                    return rb.c(string, string2, file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            throw new IOException(privilegedActionException.getMessage(), privilegedActionException.getException());
        }
    }

    public static File getOxygenTempDirectory() {
        return rb.b();
    }

    public static File createTempDir(String string, String string2) throws IOException {
        File file = FileSystemUtil.newTempDir(string, string2);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create temporary folder: " + file);
        }
        return file;
    }

    public static File newTempDir(String string, String string2) {
        String string3 = string = string == null ? "" : string;
        if (string2 == null) {
            string2 = String.valueOf(System.currentTimeMillis());
        }
        string2 = string.concat(String.valueOf(string2));
        File file = FileSystemUtil.getOxygenTempDirectory();
        File file2 = new File(file, string2);
        return file2;
    }

    public static List<File> unzip(File file, File file2, FileFilter fileFilter) throws IOException {
        File file3;
        File file4;
        ZipEntry zipEntry;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (!zipEntry.isDirectory()) continue;
            file4 = new File(file2, zipEntry.getName());
            if (fileFilter != null && !fileFilter.accept(file4)) continue;
            file4.mkdirs();
            file3 = FileSystemUtil.b(file2, file4);
            if (file3 == null) continue;
            linkedHashSet.add(file3);
        }
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            file4 = new File(file2, zipEntry.getName());
            if (fileFilter != null && !fileFilter.accept(file4)) continue;
            file4.getParentFile().mkdirs();
            FileSystemUtil.copyInputStreamToOutputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file4)), true);
            file3 = FileSystemUtil.b(file2, file4);
            if (file3 == null) continue;
            linkedHashSet.add(file3);
        }
        zipFile.close();
        return new ArrayList<File>(linkedHashSet);
    }

    private static File b(File file, File file2) {
        File file3;
        File file4 = null;
        for (file3 = file2; file3 != null && !file.equals(file3.getParentFile()); file3 = file3.getParentFile()) {
        }
        if (file3 != null && file.equals(file3.getParentFile())) {
            file4 = file3;
        }
        return file4;
    }

    public static void zip(File file, File file2, FileFilter fileFilter, boolean bl, boolean bl2) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        long l2 = FileSystemUtil.c(file2, zipOutputStream, fileFilter, bl2 ? file2.getName() : "", bl);
        zipOutputStream.close();
        file.setLastModified(l2);
    }

    public static boolean isAncestor(File file, File file2) {
        boolean bl = false;
        if (file != null) {
            while (file2 != null) {
                if (file2.equals(file)) {
                    bl = true;
                    break;
                }
                file2 = file2.getParentFile();
            }
        }
        return bl;
    }

    private static long c(File file, ZipOutputStream zipOutputStream, FileFilter fileFilter, String string, boolean bl) throws IOException {
        Object object;
        long l2 = file.lastModified();
        byte[] byArray = new byte[1024];
        if (string.length() > 0) {
            object = file.getName();
            object = string + "/";
            zipOutputStream.putNextEntry(new ZipEntry((String)object));
        }
        object = file.listFiles(fileFilter);
        for (int i2 = 0; i2 < ((File[])object).length; ++i2) {
            int n2;
            Object object2;
            if (object[i2].isDirectory()) {
                if (!bl) continue;
                object2 = null;
                object2 = string.length() == 0 ? object[i2].getName() : string + "/" + object[i2].getName();
                l2 = Math.max(l2, FileSystemUtil.c(object[i2], zipOutputStream, fileFilter, (String)object2, bl));
                continue;
            }
            object2 = new FileInputStream(object[i2].getAbsolutePath());
            String string2 = object[i2].getName();
            if (string.length() > 0) {
                string2 = string + "/" + string2;
            }
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            while ((n2 = ((FileInputStream)object2).read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            zipOutputStream.closeEntry();
            ((FileInputStream)object2).close();
            l2 = Math.max(l2, object[i2].lastModified());
        }
        return l2;
    }

    public static String proposeValidFileName(String string) {
        if (string != null) {
            string = BasicURLUtil.filterPasswords(string);
        }
        return string != null ? string.replaceAll(h, "_") : string;
    }

    public static File findFileByExtension(File file, String string) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    File file2 = FileSystemUtil.findFileByExtension(fileArray[i2], string);
                    if (file2 == null) continue;
                    return file2;
                }
            }
        } else if (BasicEqualer.verifyEquals(FileSystemUtil.getExtension(file.getName()), string)) {
            return file;
        }
        return null;
    }

    public static String getExtension(String string) {
        int n2;
        int n3;
        int n4;
        String string2;
        int n5;
        String string3 = "";
        if (string != null && (n5 = (string2 = string.substring((n4 = (n3 = string.lastIndexOf(File.separatorChar)) > (n2 = string.lastIndexOf(47)) ? n3 : n2) + 1)).lastIndexOf(46)) >= 0) {
            string3 = string2.substring(n5 + 1);
        }
        return string3;
    }

    public static String replaceExtension(String string, String string2) {
        String string3 = FileSystemUtil.getExtension(string);
        if (!string2.equals(string3)) {
            if (string3.length() > 0) {
                return string.substring(0, string.length() - string3.length()) + string2;
            }
            string = string.endsWith(".") ? string + string2 : string + "." + string2;
        }
        return string;
    }

    public static String getName(String string) {
        String string2 = "";
        if (string != null) {
            int n2;
            int n3 = string.lastIndexOf(File.separatorChar);
            int n4 = n3 > (n2 = string.lastIndexOf(47)) ? n3 : n2;
            string2 = string.substring(n4 + 1);
        }
        return string2;
    }

    public static File findFile(File file, String string) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i2 = 0; i2 < fileArray.length; ++i2) {
                    File file2 = FileSystemUtil.findFile(fileArray[i2], string);
                    if (file2 == null) continue;
                    return file2;
                }
            }
        } else if (BasicEqualer.verifyEquals(file.getName(), string)) {
            return file;
        }
        return null;
    }

    public static String getRelativePath(String string, String string2) {
        return FileSystemUtil.getRelativePath(string, string2, File.separatorChar);
    }

    public static String getRelativePath(String string, String string2, char c2) {
        if (string == null || "".equals(string)) {
            return string2;
        }
        if (string.equals(string2)) {
            return "";
        }
        if (!string.endsWith(String.valueOf(c2))) {
            string = string + c2;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(c2);
        int n5 = string2.indexOf(c2);
        while (n4 != -1 && n4 == n5 && string.substring(n2, n4).equals(string2.substring(n3, n5))) {
            n2 = n4;
            n3 = n5;
            n4 = string.indexOf(c2, n4 + 1);
            n5 = string2.indexOf(c2, n5 + 1);
        }
        if (n3 == 0) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n4 != -1) {
            stringBuilder.append(".." + c2);
            n4 = string.indexOf(c2, n4 + 1);
        }
        stringBuilder.append(string2.substring(n3 + 1));
        return stringBuilder.toString();
    }

    public static String getFileSize(long l2) {
        double d2 = Long.valueOf(l2).doubleValue();
        String string = "";
        if (d2 == 0.0) {
            string = "0" + d[0];
        } else if (d2 > 0.0) {
            int n2 = -1;
            while (d2 > 1024.0) {
                d2 /= 1024.0;
                ++n2;
            }
            if (n2 == -1) {
                d2 = 1.0;
                ++n2;
            }
            string = (n2 > 0 ? b.format(d2) : Long.valueOf(Math.round(d2))) + d[n2];
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        boolean bl = false;
        if (!file.exists() || file.canWrite()) {
            RandomAccessFile randomAccessFile = null;
            boolean bl2 = false;
            boolean bl3 = file.exists();
            long l2 = file.lastModified();
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(randomAccessFile.length());
                randomAccessFile.write(32);
                bl2 = true;
                randomAccessFile.setLength(randomAccessFile.length() - 1L);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bl2) {
                    file.setLastModified(l2);
                }
                if (!bl3) {
                    file.delete();
                }
            }
        }
        return bl;
    }

    public static File getCommonAncestor(File file, File file2) {
        File file3 = null;
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (file != null) {
            if (FileSystemUtil.isAncestor(file, file2)) {
                file3 = file;
                break;
            }
            file = file.getParentFile();
        }
        return file3;
    }
}

