/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.xmlrefactory.command;

import java.io.File;
import java.net.MalformedURLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.xmlrefactory.command.XROperationScript;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XROperationScriptImpl
implements XROperationScript {
    private static final Logger logger = Logger.getLogger((String)XROperationScriptImpl.class.getName());
    @XmlAttribute(name="href", required=true)
    private String location;
    @XmlAttribute(name="type", required=true)
    private XROperationScript.XROperationScriptType type;

    public XROperationScriptImpl() {
    }

    public XROperationScriptImpl(String string, XROperationScript.XROperationScriptType xROperationScriptType) {
        this.location = string;
        this.type = xROperationScriptType;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public XROperationScript.XROperationScriptType getType() {
        return this.type;
    }

    public void makeAbsoluteLocation(File file) {
        if (URLUtil.isRelativePath(this.location)) {
            try {
                String string = URLUtil.correct(file).toString();
                this.location = URLUtil.makeAbsolute(string, this.location);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("Problems when tr to make absolute location: " + this.location));
            }
        }
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.location == null ? 0 : this.location.hashCode());
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof XROperationScriptImpl && this.type == ((XROperationScriptImpl)object).type && Equaler.verifyEquals(this.location, ((XROperationScriptImpl)object).location);
    }
}

