/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.scenario.BaseScenarioImpl;
import ro.sync.exml.editor.xmleditor.transform.TransformationParameter;
import ro.sync.exml.editor.xmleditor.transform.advanced.AdvancedTransformerOptionsBase;
import ro.sync.exml.editor.xmleditor.transform.advanced.SaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonEEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XQuerySaxonPEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonEEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonHEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.advanced.XSLTSaxonPEAdvancedOptions;
import ro.sync.exml.editor.xmleditor.transform.c.e;
import ro.sync.exml.options.Options;
import ro.sync.exml.q.b;
import ro.sync.options.bb;
import ro.sync.options.gb;
import ro.sync.options.j;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.util.u;
import ro.sync.xml.transformer.z;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Scenario
extends BaseScenarioImpl {
    public static final String DEFAULT_SCENARIO_NAME = "xml-stylesheet processing instruction";
    public static final String APACHE_FOP = "Apache FOP";
    public static final String BUILTIN_OLD = "Built-in (Apache FOP)";
    public static final String METHOD_PDF = "pdf";
    public static final String METHOD_PS = "ps";
    public static final String METHOD_TXT = "txt";
    public static final String XSL_CONTEXT_XSL_TRANSFORMER = "XML";
    public static final String XML_CONTEXT_XSL_TRANSFORMER = "XSL";
    public static final String XQUERY_CONTEXT_XQUERY_TRANSFORMER = "XQUERY";
    public static final String SQL_CONTEXT_SQL_TRANSFORMER = "SQL";
    public static final String XPROC_CONTEXT_XPROC_TRANSFORMER = "XPROC";
    public static final String XML_CONTEXT_DITA_OT_TRANSFORMER = "DITAMAP";
    public static final String XML_CONTEXT_ANT_TRANSFORMER = "ANT";
    public static final String XML_CONTEXT_XQUERY_TRANSFORMER = "XML_XQUERY";
    public static final String[] ALL_SCENARIO_TYPES = new String[]{"XSL", "XML_XQUERY", "DITAMAP", "ANT", "XML", "XPROC", "XQUERY", "SQL"};
    gb<String, AdvancedTransformerOptionsBase> advancedOptionsMap;
    @PersistentObjectField(hasEditorVariables=false, isIDTypeVariables=true)
    private String name;
    @PersistentObjectField(hasEditorVariables=true)
    private String baseURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String footerURL = "";
    @PersistentObjectField(hasEditorVariables=false)
    private String fOPMethod;
    @PersistentObjectField(hasEditorVariables=false)
    private String fOProcessorName;
    @PersistentObjectField(hasEditorVariables=true)
    private String headerURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String inputXSLURL = "";
    @PersistentObjectField(hasEditorVariables=true)
    private String inputXMLURL = "";
    private boolean defaultScenario;
    private boolean isFOPPerforming;
    @PersistentObjectField(hasEditorVariables=false)
    private String type = "XSL";
    private boolean saveAs = true;
    private boolean openInBrowser;
    private File outputFile;
    @PersistentObjectField(hasEditorVariables=true)
    private String outputResource;
    private boolean openOtherLocationInBrowser = false;
    @PersistentObjectField(hasEditorVariables=true)
    private String locationToOpenInBrowserURL = "";
    private boolean openInEditor;
    private boolean showInHTMLPane;
    private boolean showInXMLPane = true;
    private boolean showInSVGPane;
    private boolean showInResultSetPane = false;
    private boolean useXSLTInput = true;
    private bb<TransformationParameter> xsltParams = new bb();
    @PersistentObjectField(hasEditorVariables=true)
    private String[] cascadingStylesheets = new String[0];
    @PersistentObjectField(hasEditorVariables=false)
    private String xslTransformer = "Saxon6.5.5";
    @PersistentObjectField(hasEditorVariables=true)
    private String[] extensionURLs = new String[0];

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.id = null;
    }

    public Scenario() {
    }

    public Scenario(String string) {
        this.setName(string);
    }

    @Override
    public Object clone() {
        Scenario scenario = (Scenario)super.clone();
        if (scenario != null) {
            if (this.xsltParams != null) {
                scenario.xsltParams = (bb)this.xsltParams.clone();
            }
            if (this.cascadingStylesheets != null) {
                scenario.cascadingStylesheets = (String[])this.cascadingStylesheets.clone();
            }
            if (this.extensionURLs != null) {
                scenario.extensionURLs = (String[])this.extensionURLs.clone();
            }
            if (this.advancedOptionsMap != null) {
                scenario.advancedOptionsMap = (gb)this.advancedOptionsMap.clone();
            }
        }
        return scenario;
    }

    private boolean verifyEquals(String string, String string2) {
        if (string == null || string2 == null) {
            return Equaler.verifyEquals(string, string2);
        }
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(string2);
            return Equaler.verifyEquals(URLUtil.clearUserInfo(uRL).toString(), URLUtil.clearUserInfo(uRL2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            return Equaler.verifyEquals(string, string2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Scenario)) {
            return false;
        }
        Scenario scenario = (Scenario)object;
        if (scenario.getStorage() != this.getStorage()) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.getId(), this.getId())) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.type, this.type)) {
            return false;
        }
        if (!this.verifyEquals(scenario.baseURL, this.baseURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.inputXSLURL, this.inputXSLURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.inputXMLURL, this.inputXMLURL)) {
            return false;
        }
        if (scenario.defaultScenario != this.defaultScenario) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.fOPMethod, this.fOPMethod)) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.fOProcessorName, this.fOProcessorName)) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.outputResource, this.outputResource)) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.xsltParams, this.xsltParams)) {
            return false;
        }
        if (!Equaler.verifyArrayEquals(scenario.cascadingStylesheets, this.cascadingStylesheets)) {
            return false;
        }
        if (!Equaler.verifyArrayEquals(scenario.extensionURLs, this.extensionURLs)) {
            return false;
        }
        if (!this.verifyEquals(scenario.headerURL, this.headerURL)) {
            return false;
        }
        if (!this.verifyEquals(scenario.footerURL, this.footerURL)) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.getXslTransformer(), this.getXslTransformer())) {
            return false;
        }
        if (scenario.isFOPPerforming != this.isFOPPerforming) {
            return false;
        }
        if (scenario.showInHTMLPane != this.showInHTMLPane) {
            return false;
        }
        if (scenario.showInXMLPane != this.showInXMLPane) {
            return false;
        }
        if (scenario.showInSVGPane != this.showInSVGPane) {
            return false;
        }
        if (scenario.showInResultSetPane != this.showInResultSetPane) {
            return false;
        }
        if (scenario.useXSLTInput != this.useXSLTInput) {
            return false;
        }
        if (scenario.saveAs != this.saveAs) {
            return false;
        }
        if (scenario.openInBrowser != this.openInBrowser) {
            return false;
        }
        if (scenario.openOtherLocationInBrowser != this.openOtherLocationInBrowser) {
            return false;
        }
        if (!Equaler.verifyEquals(scenario.locationToOpenInBrowserURL, this.locationToOpenInBrowserURL)) {
            return false;
        }
        if (scenario.openInEditor != this.openInEditor) {
            return false;
        }
        return this.verifyEqualsAdvancedOptions(scenario);
    }

    public int hashCode() {
        int n2 = Boolean.valueOf(this.defaultScenario).hashCode();
        if (this.type != null) {
            n2 += this.type.hashCode();
        }
        if (this.inputXMLURL != null) {
            n2 += this.inputXMLURL.hashCode();
        }
        if (this.inputXSLURL != null) {
            n2 += this.inputXSLURL.hashCode();
        }
        if (this.getXslTransformer() != null) {
            n2 += this.getXslTransformer().hashCode();
        }
        return n2;
    }

    private boolean verifyEqualsAdvancedOptions(Scenario scenario) {
        boolean bl = true;
        if (scenario.advancedOptionsMap == null && this.advancedOptionsMap != null || scenario.advancedOptionsMap != null && this.advancedOptionsMap == null) {
            bl = false;
        }
        if (bl && scenario.advancedOptionsMap != null && this.advancedOptionsMap != null) {
            if (scenario.advancedOptionsMap.size() != this.advancedOptionsMap.size()) {
                bl = false;
            } else {
                for (String string : scenario.advancedOptionsMap.keySet()) {
                    if (Equaler.verifyEquals(scenario.advancedOptionsMap.get(string), this.advancedOptionsMap.get(string))) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getFooterURL() {
        return this.footerURL;
    }

    public String getFOPMethod() {
        return this.fOPMethod;
    }

    public String getFOProcessorName() {
        return this.fOProcessorName;
    }

    public String getHeaderURL() {
        return this.headerURL;
    }

    public String getInputXSLURL() {
        return this.inputXSLURL;
    }

    public String getInputXMLURL() {
        return this.inputXMLURL;
    }

    public boolean isDefaultScenario() {
        return this.defaultScenario;
    }

    public boolean getIsFOPPerforming() {
        return this.isFOPPerforming;
    }

    public String getSaveAsResource() {
        return this.outputResource;
    }

    public boolean getShowInHTMLPane() {
        return this.showInHTMLPane;
    }

    public boolean getShowInXMLPane() {
        return this.showInXMLPane;
    }

    public boolean getShowInSVGPane() {
        return this.showInSVGPane;
    }

    public boolean getShowInResultSetPane() {
        return this.showInResultSetPane;
    }

    public boolean getUseXSLTInput() {
        return this.useXSLTInput;
    }

    public bb getXsltParams() {
        return this.xsltParams;
    }

    public String[] getCascadingStylesheets() {
        return this.cascadingStylesheets;
    }

    public String getXslTransformer() {
        this.xslTransformer = z.b(this.xslTransformer);
        return this.xslTransformer;
    }

    public boolean isSaveAs() {
        return this.saveAs;
    }

    public boolean isOpenInBrowser() {
        return this.openInBrowser;
    }

    public boolean isOpenInEditor() {
        return this.openInEditor;
    }

    public boolean isOpenOtherLocationInBrowser() {
        return this.openOtherLocationInBrowser;
    }

    public String getLocationToOpenInBrowserURL() {
        return this.locationToOpenInBrowserURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    @Override
    public void setType(String string) {
        this.type = string;
        if (string == null) {
            this.type = XML_CONTEXT_XSL_TRANSFORMER;
        }
    }

    public void setFooterURL(String string) {
        this.footerURL = string;
    }

    public void setFOPMethod(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        this.fOPMethod = string;
    }

    public void setFOProcessorName(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("The FOProcessorName may be null, but not the empty string.");
        }
        this.fOProcessorName = string;
    }

    public void setHeaderURL(String string) {
        this.headerURL = string;
    }

    public void setInputXSLURL(String string) {
        this.inputXSLURL = string;
    }

    public void setInputXMLURL(String string) {
        this.inputXMLURL = string;
    }

    public void setDefaultScenario(boolean bl) {
        this.defaultScenario = bl;
    }

    public void setIsFOPPerforming(boolean bl) {
        this.isFOPPerforming = bl;
    }

    public void setSaveAs(boolean bl) {
        this.saveAs = bl;
    }

    public void setOpenInBrowser(boolean bl) {
        this.openInBrowser = bl;
    }

    public void setOpenInEditor(boolean bl) {
        this.openInEditor = bl;
    }

    public void setOpenOtherLocationInBrowser(boolean bl) {
        this.openOtherLocationInBrowser = bl;
    }

    public void setLocationToOpenInBrowserURL(String string) {
        this.locationToOpenInBrowserURL = string;
    }

    public void setSaveAsResource(String string) {
        if (string != null && string.trim().length() == 0) {
            throw new IllegalArgumentException("The outputFile may be null, but not the empty string.");
        }
        this.outputResource = string;
        this.outputFile = null;
        if (this.outputResource != null) {
            this.outputFile = new File(this.outputResource);
        }
    }

    public void setShowInHTMLPane(boolean bl) {
        this.showInHTMLPane = bl;
    }

    public void setShowInXMLPane(boolean bl) {
        this.showInXMLPane = bl;
    }

    public void setShowInSVGPane(boolean bl) {
        this.showInSVGPane = bl;
    }

    public void setShowInResultSetPane(boolean bl) {
        this.showInResultSetPane = bl;
    }

    public void setUseXSLTInput(boolean bl) {
        this.useXSLTInput = bl;
    }

    public void setXsltParams(bb bb2) {
        if (bb2 != null) {
            this.xsltParams = (bb)bb2.clone();
            Collections.sort(this.xsltParams, e.PARAM_NAME_COMPARATOR);
        } else {
            this.xsltParams.clear();
        }
    }

    public void setCascadingStylesheets(String[] stringArray) {
        this.cascadingStylesheets = stringArray;
    }

    public void setXslTransformer(String string) {
        this.xslTransformer = string;
    }

    public String toString() {
        return this.getName();
    }

    public String[] getExtensions() {
        return this.extensionURLs;
    }

    public static URL[] getExtensionsAsURLs(URL uRL, String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                String string;
                URL uRL2 = new URL(uRL, EditorVariables.expandEditorVariables(stringArray[i2], uRL != null ? uRL.toString() : null));
                File file = URLUtil.getCanonicalFileFromFileUrl(uRL2);
                if (file != null && file.isDirectory() && (string = uRL2.toString()).charAt(string.length() - 1) != '/') {
                    string = string + '/';
                    uRL2 = new URL(string);
                }
                arrayList.add(uRL2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                b.c("Could not create URL for extension:" + stringArray[i2]);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    public void setExtensions(String[] stringArray) {
        this.extensionURLs = stringArray;
    }

    @Override
    public void checkValid() throws j {
        if (this.name == null) {
            throw new j("Invalid scenario name.");
        }
        if (this.type == null) {
            throw new j("Invalid scenario type.");
        }
        if (this.xsltParams == null) {
            throw new j("Invalid XSLT parameters list for scenario.");
        }
        if (this.xslTransformer == null) {
            throw new j("Invalid transformer in scenario.");
        }
        if (!(SQL_CONTEXT_SQL_TRANSFORMER.equals(this.type) || XML_CONTEXT_DITA_OT_TRANSFORMER.equals(this.type) || XML_CONTEXT_ANT_TRANSFORMER.equals(this.type) || XPROC_CONTEXT_XPROC_TRANSFORMER.equals(this.type))) {
            if (this.baseURL == null) {
                throw new j("Invalid base URL.");
            }
            if (this.headerURL == null) {
                throw new j("Invalid header URL for scenario.");
            }
            if (this.footerURL == null) {
                throw new j("Invalid footer URL for scenario.");
            }
            if (this.cascadingStylesheets == null) {
                throw new j("Invalid cascading XSLT's.");
            }
            if (this.extensionURLs == null) {
                this.setExtensions(new String[0]);
            }
            if (this.outputResource == null && this.outputFile != null) {
                this.outputResource = this.outputFile.getPath();
            }
        }
        if (BUILTIN_OLD.equals(this.fOProcessorName)) {
            this.fOProcessorName = APACHE_FOP;
        }
    }

    @Override
    public void prepareURLsForSerialization(boolean bl) {
        if (!bl) {
            URL uRL;
            if (this.inputXSLURL != null) {
                this.inputXSLURL = URLUtil.replaceBackSlash(this.inputXSLURL);
                try {
                    uRL = new URL(this.inputXSLURL);
                    this.inputXSLURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.inputXMLURL != null) {
                this.inputXMLURL = URLUtil.replaceBackSlash(this.inputXMLURL);
                try {
                    uRL = new URL(this.inputXMLURL);
                    this.inputXMLURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.baseURL != null) {
                this.baseURL = URLUtil.replaceBackSlash(this.baseURL);
                try {
                    uRL = new URL(this.baseURL);
                    this.baseURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.headerURL != null) {
                this.headerURL = URLUtil.replaceBackSlash(this.headerURL);
                try {
                    uRL = new URL(this.headerURL);
                    this.headerURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.footerURL != null) {
                this.footerURL = URLUtil.replaceBackSlash(this.footerURL);
                try {
                    uRL = new URL(this.footerURL);
                    this.footerURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.locationToOpenInBrowserURL != null) {
                this.locationToOpenInBrowserURL = URLUtil.replaceBackSlash(this.locationToOpenInBrowserURL);
                try {
                    uRL = new URL(this.locationToOpenInBrowserURL);
                    this.locationToOpenInBrowserURL = u.e(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            URL uRL;
            if (this.inputXSLURL != null) {
                this.inputXSLURL = URLUtil.replaceBackSlash(this.inputXSLURL);
                try {
                    uRL = new URL(this.inputXSLURL);
                    this.inputXSLURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.inputXMLURL != null) {
                this.inputXMLURL = URLUtil.replaceBackSlash(this.inputXMLURL);
                try {
                    uRL = new URL(this.inputXMLURL);
                    this.inputXMLURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.baseURL != null) {
                this.baseURL = URLUtil.replaceBackSlash(this.baseURL);
                try {
                    uRL = new URL(this.baseURL);
                    this.baseURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.headerURL != null) {
                this.headerURL = URLUtil.replaceBackSlash(this.headerURL);
                try {
                    uRL = new URL(this.headerURL);
                    this.headerURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.footerURL != null) {
                this.footerURL = URLUtil.replaceBackSlash(this.footerURL);
                try {
                    uRL = new URL(this.footerURL);
                    this.footerURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.locationToOpenInBrowserURL != null) {
                this.locationToOpenInBrowserURL = URLUtil.replaceBackSlash(this.locationToOpenInBrowserURL);
                try {
                    uRL = new URL(this.locationToOpenInBrowserURL);
                    this.locationToOpenInBrowserURL = URLUtil.clearUserInfo(uRL).toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void decryptURLs() {
        if (this.inputXSLURL != null) {
            try {
                this.inputXSLURL = u.h(new URL(this.inputXSLURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.inputXMLURL != null) {
            try {
                this.inputXMLURL = u.h(new URL(this.inputXMLURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.baseURL != null) {
            try {
                this.baseURL = u.h(new URL(this.baseURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.headerURL != null) {
            try {
                this.headerURL = u.h(new URL(this.headerURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.footerURL != null) {
            try {
                this.footerURL = u.h(new URL(this.footerURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.locationToOpenInBrowserURL != null) {
            try {
                this.locationToOpenInBrowserURL = u.h(new URL(this.locationToOpenInBrowserURL)).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static AdvancedTransformerOptionsBase getDefaultAdvancedOptions(String string) {
        SaxonHEAdvancedOptions saxonHEAdvancedOptions = null;
        if ("Saxon-HE".equals(string)) {
            XSLTSaxonHEAdvancedOptions xSLTSaxonHEAdvancedOptions = new XSLTSaxonHEAdvancedOptions();
            String string2 = Options.getInstance().getStringProperty("saxon.optimization.level");
            xSLTSaxonHEAdvancedOptions.setOptimizationLevel(string2);
            xSLTSaxonHEAdvancedOptions.setDtdSourceValidation(Options.getInstance().getIntegerProperty("saxon8.dtd.based.validation"));
            String string3 = Options.getInstance().getStringProperty("saxon8.recover.policy");
            xSLTSaxonHEAdvancedOptions.setErrorRecoverPolicy(string3);
            xSLTSaxonHEAdvancedOptions.setLineNumbering(Options.getInstance().getBooleanProperty("saxon8.line.numbering"));
            xSLTSaxonHEAdvancedOptions.setShowVersionWarnings(Options.getInstance().getBooleanProperty("saxon8.no.version.warning"));
            xSLTSaxonHEAdvancedOptions.setTraceIntoXPathExpression(Options.getInstance().getBooleanProperty("saxon.trace.into.xpath.expressions"));
            xSLTSaxonHEAdvancedOptions.setExpandAttributeDefaults(Options.getInstance().getBooleanProperty("saxon.latest.expand.attribute.defaults"));
            String string4 = Options.getInstance().getStringProperty("xslt.strip.ws");
            if ("saxon.strip.ws.all".equals(string4)) {
                xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.ignorable".equals(string4)) {
                xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            } else {
                xSLTSaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            }
            xSLTSaxonHEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("saxon.latest.config.file"));
            xSLTSaxonHEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("saxon.latest.use.config.file"));
            saxonHEAdvancedOptions = xSLTSaxonHEAdvancedOptions;
        } else if ("Saxon-PE".equals(string)) {
            XSLTSaxonPEAdvancedOptions xSLTSaxonPEAdvancedOptions = new XSLTSaxonPEAdvancedOptions();
            String string5 = Options.getInstance().getStringProperty("saxon.optimization.level");
            xSLTSaxonPEAdvancedOptions.setOptimizationLevel(string5);
            xSLTSaxonPEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("saxon8.allow.calls.on.extension.functions"));
            xSLTSaxonPEAdvancedOptions.setRegisterSaxonCEExtensions(Options.getInstance().getBooleanProperty("saxon.latest.register.saxon.ce.extensions"));
            xSLTSaxonPEAdvancedOptions.setDtdSourceValidation(Options.getInstance().getIntegerProperty("saxon8.dtd.based.validation"));
            String string6 = Options.getInstance().getStringProperty("saxon8.recover.policy");
            xSLTSaxonPEAdvancedOptions.setErrorRecoverPolicy(string6);
            xSLTSaxonPEAdvancedOptions.setLineNumbering(Options.getInstance().getBooleanProperty("saxon8.line.numbering"));
            xSLTSaxonPEAdvancedOptions.setShowVersionWarnings(Options.getInstance().getBooleanProperty("saxon8.no.version.warning"));
            xSLTSaxonPEAdvancedOptions.setTraceIntoXPathExpression(Options.getInstance().getBooleanProperty("saxon.trace.into.xpath.expressions"));
            xSLTSaxonPEAdvancedOptions.setExpandAttributeDefaults(Options.getInstance().getBooleanProperty("saxon.latest.expand.attribute.defaults"));
            String string7 = Options.getInstance().getStringProperty("xslt.strip.ws");
            if ("saxon.strip.ws.all".equals(string7)) {
                xSLTSaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.none".equals(string7)) {
                xSLTSaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            } else {
                xSLTSaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            }
            xSLTSaxonPEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("saxon.latest.config.file"));
            xSLTSaxonPEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("saxon.latest.use.config.file"));
            saxonHEAdvancedOptions = xSLTSaxonPEAdvancedOptions;
        } else if ("Saxon-EE".equals(string)) {
            XSLTSaxonEEAdvancedOptions xSLTSaxonEEAdvancedOptions = new XSLTSaxonEEAdvancedOptions();
            String string8 = Options.getInstance().getStringProperty("default.xml.schema.version");
            xSLTSaxonEEAdvancedOptions.setSchemaVersion(string8);
            String string9 = Options.getInstance().getStringProperty("saxon.optimization.level");
            xSLTSaxonEEAdvancedOptions.setOptimizationLevel(string9);
            xSLTSaxonEEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("saxon8.allow.calls.on.extension.functions"));
            xSLTSaxonEEAdvancedOptions.setDtdSourceValidation(Options.getInstance().getIntegerProperty("saxon8.dtd.based.validation"));
            String string10 = Options.getInstance().getStringProperty("saxon8.recover.policy");
            xSLTSaxonEEAdvancedOptions.setErrorRecoverPolicy(string10);
            xSLTSaxonEEAdvancedOptions.setLineNumbering(Options.getInstance().getBooleanProperty("saxon8.line.numbering"));
            xSLTSaxonEEAdvancedOptions.setShowVersionWarnings(Options.getInstance().getBooleanProperty("saxon8.no.version.warning"));
            xSLTSaxonEEAdvancedOptions.setTraceIntoXPathExpression(Options.getInstance().getBooleanProperty("saxon.trace.into.xpath.expressions"));
            xSLTSaxonEEAdvancedOptions.setExpandAttributeDefaults(Options.getInstance().getBooleanProperty("saxon.latest.expand.attribute.defaults"));
            String string11 = Options.getInstance().getStringProperty("xslt.strip.ws");
            if ("saxon.strip.ws.all".equals(string11)) {
                xSLTSaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.none".equals(string11)) {
                xSLTSaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            } else {
                xSLTSaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            }
            xSLTSaxonEEAdvancedOptions.setTreatResultValidationErrorsAsWarnings(Options.getInstance().getBooleanProperty("saxon8.validation.warnings.in.result"));
            xSLTSaxonEEAdvancedOptions.setAddCommentsForValidationErrors(Options.getInstance().getBooleanProperty("saxon8.validation.comments.in.result"));
            xSLTSaxonEEAdvancedOptions.setGenerateByteCode(Options.getInstance().getBooleanProperty("saxon8.generate.byte.code"));
            String string12 = Options.getInstance().getStringProperty("saxon8.schema.based.validation");
            xSLTSaxonEEAdvancedOptions.setSourceValidation(string12);
            xSLTSaxonEEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("saxon.latest.config.file"));
            xSLTSaxonEEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("saxon.latest.use.config.file"));
            saxonHEAdvancedOptions = xSLTSaxonEEAdvancedOptions;
        } else if ("Saxon-HE XQuery".equals(string)) {
            XQuerySaxonHEAdvancedOptions xQuerySaxonHEAdvancedOptions = new XQuerySaxonHEAdvancedOptions();
            String string13 = Options.getInstance().getStringProperty("xquery.optimization.level");
            xQuerySaxonHEAdvancedOptions.setOptimizationLevel(string13);
            xQuerySaxonHEAdvancedOptions.setEnabledLinkedTreeModel(Options.getInstance().getBooleanProperty("xquery.linked.tree.model"));
            xQuerySaxonHEAdvancedOptions.setEnabledXQuery30Support(Options.getInstance().getBooleanProperty("enable.xquery.3.0.support"));
            String string14 = Options.getInstance().getStringProperty("xquery.recover.policy");
            xQuerySaxonHEAdvancedOptions.setErrorRecoverPolicy(string14);
            String string15 = Options.getInstance().getStringProperty("xquery.strip.ws");
            if ("saxon.strip.ws.all".equals(string15)) {
                xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.none".equals(string15)) {
                xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            } else {
                xQuerySaxonHEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            }
            xQuerySaxonHEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("xquery.saxon.config.file"));
            xQuerySaxonHEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("xquery.saxon.use.config.file"));
            saxonHEAdvancedOptions = xQuerySaxonHEAdvancedOptions;
        } else if ("Saxon-PE XQuery".equals(string)) {
            XQuerySaxonPEAdvancedOptions xQuerySaxonPEAdvancedOptions = new XQuerySaxonPEAdvancedOptions();
            String string16 = Options.getInstance().getStringProperty("xquery.optimization.level");
            xQuerySaxonPEAdvancedOptions.setOptimizationLevel(string16);
            xQuerySaxonPEAdvancedOptions.setEnabledLinkedTreeModel(Options.getInstance().getBooleanProperty("xquery.linked.tree.model"));
            xQuerySaxonPEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("xquery.allow.calls.on.extension.functions"));
            String string17 = Options.getInstance().getStringProperty("xquery.recover.policy");
            xQuerySaxonPEAdvancedOptions.setErrorRecoverPolicy(string17);
            String string18 = Options.getInstance().getStringProperty("xquery.strip.ws");
            if ("saxon.strip.ws.all".equals(string18)) {
                xQuerySaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.none".equals(string18)) {
                xQuerySaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            } else {
                xQuerySaxonPEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            }
            xQuerySaxonPEAdvancedOptions.setEnabledXQuery30Support(Options.getInstance().getBooleanProperty("enable.xquery.3.0.support"));
            xQuerySaxonPEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("xquery.saxon.config.file"));
            xQuerySaxonPEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("xquery.saxon.use.config.file"));
            saxonHEAdvancedOptions = xQuerySaxonPEAdvancedOptions;
        } else if ("Saxon-EE XQuery".equals(string)) {
            XQuerySaxonEEAdvancedOptions xQuerySaxonEEAdvancedOptions = new XQuerySaxonEEAdvancedOptions();
            String string19 = Options.getInstance().getStringProperty("xquery.optimization.level");
            xQuerySaxonEEAdvancedOptions.setOptimizationLevel(string19);
            xQuerySaxonEEAdvancedOptions.setEnabledLinkedTreeModel(Options.getInstance().getBooleanProperty("xquery.linked.tree.model"));
            xQuerySaxonEEAdvancedOptions.setAllowCallsOnExtensionFunctions(Options.getInstance().getBooleanProperty("xquery.allow.calls.on.extension.functions"));
            String string20 = Options.getInstance().getStringProperty("xquery.recover.policy");
            xQuerySaxonEEAdvancedOptions.setErrorRecoverPolicy(string20);
            String string21 = Options.getInstance().getStringProperty("xquery.strip.ws");
            if ("saxon.strip.ws.all".equals(string21)) {
                xQuerySaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.all");
            } else if ("saxon.strip.ws.none".equals(string21)) {
                xQuerySaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.none");
            } else {
                xQuerySaxonEEAdvancedOptions.setStripWS("saxon.strip.ws.ignorable");
            }
            xQuerySaxonEEAdvancedOptions.setTreatResultValidationErrorsAsWarnings(Options.getInstance().getBooleanProperty("xquery.validation.warnings.in.result"));
            xQuerySaxonEEAdvancedOptions.setAddCommentsForValidationErrors(Options.getInstance().getBooleanProperty("xquery.validation.comments.in.result"));
            xQuerySaxonEEAdvancedOptions.setEnabledXQuery30Support(Options.getInstance().getBooleanProperty("enable.xquery.3.0.support"));
            xQuerySaxonEEAdvancedOptions.setEnableBackup(Options.getInstance().getBooleanProperty("enable.xquery.backup"));
            xQuerySaxonEEAdvancedOptions.setEnableXQueryUpdate(Options.getInstance().getBooleanProperty("saxon.enable.xquery.update"));
            xQuerySaxonEEAdvancedOptions.setGenerateByteCode(Options.getInstance().getBooleanProperty("xquery.generate.byte.code"));
            String string22 = Options.getInstance().getStringProperty("xquery.schema.based.validation");
            xQuerySaxonEEAdvancedOptions.setSourceValidation(string22);
            xQuerySaxonEEAdvancedOptions.setConfigSystemID(Options.getInstance().getStringProperty("xquery.saxon.config.file"));
            xQuerySaxonEEAdvancedOptions.setUseConfigFile(Options.getInstance().getBooleanProperty("xquery.saxon.use.config.file"));
            saxonHEAdvancedOptions = xQuerySaxonEEAdvancedOptions;
        }
        return saxonHEAdvancedOptions;
    }

    public AdvancedTransformerOptionsBase getAdvancedOptions(String string) {
        HashMap hashMap = null;
        hashMap = this.advancedOptionsMap == null ? new HashMap() : this.advancedOptionsMap;
        AdvancedTransformerOptionsBase advancedTransformerOptionsBase = (AdvancedTransformerOptionsBase)hashMap.get(string);
        if (advancedTransformerOptionsBase == null) {
            advancedTransformerOptionsBase = Scenario.getDefaultAdvancedOptions(string);
        }
        return advancedTransformerOptionsBase;
    }

    public void setAdvancedOptions(String string, AdvancedTransformerOptionsBase advancedTransformerOptionsBase) {
        if (this.advancedOptionsMap == null) {
            this.advancedOptionsMap = new gb();
        }
        this.advancedOptionsMap.put(string, advancedTransformerOptionsBase);
    }

    public static String getCreateNewScenarioHelpPageID(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (XML_CONTEXT_XQUERY_TRANSFORMER.equals(string) || XQUERY_CONTEXT_XQUERY_TRANSFORMER.equals(string)) {
                return "transforming-xml-documents-using-xquery";
            }
            if (XML_CONTEXT_DITA_OT_TRANSFORMER.equals(string)) {
                return "dita-ot-transformation";
            }
            if (XML_CONTEXT_ANT_TRANSFORMER.equals(string)) {
                return "ant-transformation";
            }
            if (XPROC_CONTEXT_XPROC_TRANSFORMER.equals(string)) {
                return "xproc-transformation-scenario";
            }
        }
        return "defining-new-transformation-scenario";
    }

    public static List<String> getFOMethods(String string) {
        List<String> list = Scenario.getCommonFOMethods();
        if (string != null) {
            if (string.contains(APACHE_FOP)) {
                list = Scenario.getApacheFOPMethods();
            } else if (string.contains("XEP")) {
                list = Scenario.getXEPMethods();
            } else if (string.contains("Antenna House")) {
                list = Scenario.getAHMethods();
            }
        }
        return list;
    }

    private static List<String> getCommonFOMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(METHOD_PDF);
        arrayList.add(METHOD_PS);
        return arrayList;
    }

    private static List<String> getApacheFOPMethods() {
        List<String> list = Scenario.getCommonFOMethods();
        list.add(METHOD_TXT);
        list.add("rtf");
        list.add("pcl");
        list.add("afp");
        list.add("tiff");
        list.add("png");
        list.add("at");
        return list;
    }

    private static List<String> getXEPMethods() {
        List<String> list = Scenario.getCommonFOMethods();
        list.add("xps");
        list.add("xep");
        list.add("afp");
        list.add("html");
        return list;
    }

    private static List<String> getAHMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("@PDF");
        arrayList.add("@SVG");
        arrayList.add("@PS");
        arrayList.add("@XPS");
        arrayList.add("@INX");
        arrayList.add("@MIF");
        arrayList.add("@TEXT");
        arrayList.add("@AreaTree");
        return arrayList;
    }
}

