/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.notifications.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.notifications.content.NotificationType;
import ro.sync.exml.editor.notifications.content.Platform;
import ro.sync.exml.editor.notifications.content.Product;
import ro.sync.exml.editor.notifications.content.b;
import ro.sync.exml.editor.notifications.content.e;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public abstract class NotificationBase
implements b {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="publishingDate")
    @XmlJavaTypeAdapter(value=e.class)
    private Date publishingDate;
    @XmlAttribute(name="platforms")
    private String[] availablePlatforms;
    @XmlAttribute(name="products")
    private String[] availableProducts;
    @XmlAttribute(name="critical")
    private boolean critical;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="url")
    private String link;
    @XmlAttribute(name="type")
    private NotificationType type;

    @Override
    public String getNotificationTitle() {
        return this.title;
    }

    @Override
    public String getNotificationDescription() {
        return this.description;
    }

    @Override
    public String getNotificationURL() {
        return this.link;
    }

    @Override
    public String getNotificationID() {
        return this.id;
    }

    @Override
    public NotificationType getNotificationType() {
        return this.type != null ? this.type : NotificationType.GENERIC;
    }

    @Override
    public Date getPublishingDate() {
        return this.publishingDate;
    }

    public Platform[] getPlatforms() {
        ArrayList<Platform> arrayList = new ArrayList<Platform>();
        if (this.availablePlatforms != null) {
            for (String string : this.availablePlatforms) {
                arrayList.add(Platform.getPlatform(string));
            }
        }
        return arrayList.toArray(new Platform[arrayList.size()]);
    }

    public Product[] getProducts() {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        if (this.availableProducts != null) {
            for (String string : this.availableProducts) {
                arrayList.add(Product.getProduct(string));
            }
        }
        return arrayList.toArray(new Product[arrayList.size()]);
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Title: ").append(this.title).append(" ID: ").append(this.id).append("\n");
        stringBuilder.append("publishingDate: ").append(this.publishingDate).append("\n");
        stringBuilder.append("platforms: ").append(Arrays.toString(this.availablePlatforms)).append(" products: ").append(Arrays.toString(this.availableProducts));
        stringBuilder.append(" critical: ").append(this.critical);
        stringBuilder.append("Description: ").append(this.description).append("\n");
        stringBuilder.append("Type: ").append((Object)this.type).append(" URL: ").append(this.link);
        return stringBuilder.toString();
    }

    @Override
    public Date getNotifyStartingFromDate() {
        return null;
    }
}

