/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.finders;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.finders.WorkingSetEntryPO;
import ro.sync.options.PersistentObject;
import ro.sync.options.bb;
import ro.sync.options.j;
import ro.sync.util.Equaler;
import ro.sync.util.URLUtil;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class WorkingSetPO
implements PersistentObject {
    private static Logger logger = Logger.getLogger((String)WorkingSetPO.class.getName());
    private bb<WorkingSetEntryPO> workingSetEntries = new bb();
    private String wSetName;

    public WorkingSetPO() {
    }

    public WorkingSetPO(String string) {
        this(string, (List<WorkingSetEntryPO>)null);
    }

    public WorkingSetPO(String string, List<WorkingSetEntryPO> list) {
        this.wSetName = string;
        this.workingSetEntries = new bb();
        if (list != null) {
            this.workingSetEntries.addAll(list);
            Collections.sort(this.workingSetEntries, new _b());
        }
    }

    public WorkingSetPO(String string, WorkingSetEntryPO ... workingSetEntryPOArray) {
        this.wSetName = string;
        this.workingSetEntries = new bb();
        if (workingSetEntryPOArray != null) {
            for (int i2 = 0; i2 < workingSetEntryPOArray.length; ++i2) {
                this.workingSetEntries.add(workingSetEntryPOArray[i2]);
            }
            Collections.sort(this.workingSetEntries, new _b());
        }
    }

    @Override
    public void checkValid() throws j {
        if (this.wSetName == null) {
            throw new j("Working set must have a valid, non-null name");
        }
        if (this.workingSetEntries == null) {
            throw new j("Working set " + this.wSetName + " must have a valid list of entries");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public List<WorkingSetEntryPO> getEntries() {
        return this.workingSetEntries;
    }

    public List<String> getExpandedEntries(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.workingSetEntries != null) {
            for (WorkingSetEntryPO workingSetEntryPO : this.workingSetEntries) {
                if (Equaler.verifyEquals(workingSetEntryPO.getEntryType(), "Advanced_entry_type")) {
                    try {
                        arrayList.add(URLUtil.correct(new File(EditorVariables.expandEditorVariablesAsFilePath(workingSetEntryPO.getValue(), string))).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                    continue;
                }
                arrayList.add(workingSetEntryPO.getValue());
            }
        }
        return arrayList;
    }

    public WorkingSetEntryPO[] addEntries(WorkingSetEntryPO ... workingSetEntryPOArray) {
        ArrayList<WorkingSetEntryPO> arrayList = new ArrayList<WorkingSetEntryPO>();
        for (int i2 = 0; i2 < workingSetEntryPOArray.length; ++i2) {
            if (this.workingSetEntries.contains(workingSetEntryPOArray[i2])) continue;
            this.workingSetEntries.add(workingSetEntryPOArray[i2]);
            arrayList.add(workingSetEntryPOArray[i2]);
        }
        Collections.sort(this.workingSetEntries, new _b());
        return arrayList.toArray(new WorkingSetEntryPO[0]);
    }

    @Override
    public Object clone() {
        WorkingSetPO workingSetPO = null;
        try {
            workingSetPO = (WorkingSetPO)super.clone();
            if (this.workingSetEntries != null) {
                workingSetPO.workingSetEntries = (bb)this.workingSetEntries.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return workingSetPO;
    }

    public String getName() {
        return this.wSetName;
    }

    public boolean equals(Object object) {
        WorkingSetPO workingSetPO;
        if (object instanceof WorkingSetPO && this.wSetName.equals((workingSetPO = (WorkingSetPO)object).getName())) {
            return Equaler.verifyListEquals(this.workingSetEntries, workingSetPO.getEntries());
        }
        return false;
    }

    public void setName(String string) {
        this.wSetName = string;
    }

    private final class _b
    implements Comparator<WorkingSetEntryPO> {
        private _b() {
        }

        public int b(WorkingSetEntryPO workingSetEntryPO, WorkingSetEntryPO workingSetEntryPO2) {
            int n2 = 0;
            if (!workingSetEntryPO.getEntryType().equals(workingSetEntryPO2.getEntryType())) {
                if ("Advanced_entry_type".equals(workingSetEntryPO.getEntryType())) {
                    n2 = -1;
                } else if ("Advanced_entry_type".equals(workingSetEntryPO2.getEntryType())) {
                    n2 = 1;
                } else if ("Folder_entry_type".equals(workingSetEntryPO.getEntryType())) {
                    n2 = -1;
                } else if ("Folder_entry_type".equals(workingSetEntryPO2.getEntryType())) {
                    n2 = 1;
                }
            }
            return n2;
        }
    }
}

