/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.testing;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.mockito.Mockito;
import org.xml.sax.SAXException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.WebappActionsManager;
import ro.sync.ecss.extensions.api.webapp.WebappAuthorDocumentFactory;
import ro.sync.ecss.webapp.k.b;
import ro.sync.io.FileSystemUtil;
import ro.sync.io.d;
import ro.sync.net.protocol.OxygenURLStreamHandlerFactory;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class MockAuthorDocumentFactory {
    public static final String USER = "oxygen_user";
    private static boolean d = false;
    private static Thread c;
    private static File b;

    public static void initForTest() {
        if (!d) {
            b = new File(".");
            d = true;
            c = Thread.currentThread();
            try {
                File file = new File(b, "frameworks");
                if (!file.exists()) {
                    b = new File(b, "test/fake_editor_home/");
                }
                System.setProperty("com.oxygenxml.editor.home.url", URLUtil.correct(b).toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            try {
                URL.setURLStreamHandlerFactory(new OxygenURLStreamHandlerFactory());
            }
            catch (Error error) {
                error.printStackTrace();
            }
            WebappAuthorDocumentFactory.init();
        }
        MockAuthorDocumentFactory.b();
    }

    private static void b() {
        Thread thread = Thread.currentThread();
        if (thread == c) {
            try {
                ro.sync.ecss.webapp.k.b.b(b, USER);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static AuthorDocumentModel create(File file) throws Exception {
        String string = ro.sync.io.d.bb(new FileReader(file)).toString();
        return MockAuthorDocumentFactory.create(string, "");
    }

    public static AuthorDocumentModel create(File file, Map<String, Object> map) throws Exception {
        String string = ro.sync.io.d.bb(new FileReader(file)).toString();
        return MockAuthorDocumentFactory.create(string, "", map);
    }

    public static AuthorDocumentModel create(String string, String string2, Map<String, Object> map) throws Exception {
        AuthorDocumentModel authorDocumentModel = MockAuthorDocumentFactory.createNoMocks(string, string2, map);
        AuthorDocumentModel authorDocumentModel2 = (AuthorDocumentModel)Mockito.spy((Object)authorDocumentModel);
        Mockito.when(authorDocumentModel2.getNodeIndexer()).thenReturn(Mockito.spy(authorDocumentModel.getNodeIndexer()));
        WebappActionsManager webappActionsManager = authorDocumentModel.getActionsManager();
        Mockito.when((Object)authorDocumentModel2.getActionsManager()).thenReturn(Mockito.spy((Object)webappActionsManager));
        return authorDocumentModel2;
    }

    public static AuthorDocumentModel create(String string, String string2) throws Exception {
        return MockAuthorDocumentFactory.create(string, string2, Collections.<String, Object>emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        return MockAuthorDocumentFactory.createNoMocks(string, string2, Collections.<String, Object>emptyMap());
    }

    public static AuthorDocumentModel createNoMocks(String string, String string2, Map<String, Object> map) throws IOException, ParserConfigurationException, SAXException {
        String string3 = "file:///dummy.xml";
        if (string2 != null && string2.length() != 0) {
            string = MockAuthorDocumentFactory.getCSSPi(string2) + string;
        }
        StringReader stringReader = new StringReader(string);
        AuthorDocumentModel authorDocumentModel = WebappAuthorDocumentFactory.createAuthorDocumentInfo(string3, stringReader, map);
        return authorDocumentModel;
    }

    public static int getCSSProcessingInstructionLength(String string) throws IOException {
        String string2 = MockAuthorDocumentFactory.getCSSPi(string);
        return string2.length() - 2;
    }

    public static String getCSSPi(String string) throws IOException {
        File file = FileSystemUtil.createTempFile("webapp-css", ".css");
        file.deleteOnExit();
        Files.write((CharSequence)string, (File)file, (Charset)Charsets.UTF_8);
        String string2 = "<?xml-stylesheet type=\"text/css\" href=\"" + URLUtil.correct(file) + "\"?>";
        return string2;
    }

    static {
        MockAuthorDocumentFactory.initForTest();
    }
}

