/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.webapp.plugin.WebappServletPluginExtension;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginManager;

@SkipObfuscate
public class WebappPluginsServletDispatcher
extends HttpServlet {
    private static final String ADMIN_ROLE_NAME = "admin";
    private static final Logger logger = Logger.getLogger((String)WebappPluginsServletDispatcher.class.getName());
    private Map<String, WebappServletPluginExtension> webappPluginServlets;

    public void init() throws ServletException {
        PluginManager pluginManager = PluginManager.getInstance();
        List<PluginDescriptor> list = pluginManager.getPluginDescriptors();
        this.webappPluginServlets = new HashMap<String, WebappServletPluginExtension>();
        for (PluginDescriptor pluginDescriptor : list) {
            List<PluginDescriptor.PluginExtensionDescription> list2 = pluginDescriptor.getExtensions("WebappServlet");
            for (PluginDescriptor.PluginExtensionDescription pluginExtensionDescription : list2) {
                WebappServletPluginExtension webappServletPluginExtension = (WebappServletPluginExtension)pluginExtensionDescription.j;
                String string = this.adjustPath(webappServletPluginExtension.getPath());
                if (string == null || string.isEmpty()) continue;
                WebappServletPluginExtension webappServletPluginExtension2 = this.webappPluginServlets.get(string);
                if (webappServletPluginExtension2 != null) {
                    logger.warn((Object)("More thant one plugin servlet are mapped to the path : '" + string + "' \n" + "   Overriding the first one."));
                }
                logger.debug((Object)("registering webapp plugin servlet with path :" + string));
                this.webappPluginServlets.put(string, webappServletPluginExtension);
                try {
                    webappServletPluginExtension.init(this.getServletConfig());
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ServletException)) continue;
                    throw (ServletException)throwable;
                }
            }
        }
        logger.debug((Object)("Registered " + this.webappPluginServlets.size() + " webapp plugin servlets."));
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.adjustPath(httpServletRequest.getPathInfo());
        WebappServletPluginExtension webappServletPluginExtension = this.webappPluginServlets.get(string);
        if (webappServletPluginExtension != null) {
            if (webappServletPluginExtension.requiresAuthorization()) {
                if (!httpServletRequest.isUserInRole(ADMIN_ROLE_NAME)) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
            webappServletPluginExtension.doPost(httpServletRequest, httpServletResponse);
        } else {
            logger.warn((Object)("No plugin defined for path :" + string));
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.adjustPath(httpServletRequest.getPathInfo());
        WebappServletPluginExtension webappServletPluginExtension = this.webappPluginServlets.get(string);
        if (webappServletPluginExtension != null) {
            if (webappServletPluginExtension.requiresAuthorization()) {
                if (!httpServletRequest.isUserInRole(ADMIN_ROLE_NAME)) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
            webappServletPluginExtension.doGet(httpServletRequest, httpServletResponse);
        } else {
            logger.warn((Object)("No plugin defined for path :" + string));
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.adjustPath(httpServletRequest.getPathInfo());
        WebappServletPluginExtension webappServletPluginExtension = this.webappPluginServlets.get(string);
        if (webappServletPluginExtension != null) {
            if (webappServletPluginExtension.requiresAuthorization()) {
                if (!httpServletRequest.isUserInRole(ADMIN_ROLE_NAME)) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
            webappServletPluginExtension.doPut(httpServletRequest, httpServletResponse);
        } else {
            logger.warn((Object)("No plugin defined for path :" + string));
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.adjustPath(httpServletRequest.getPathInfo());
        WebappServletPluginExtension webappServletPluginExtension = this.webappPluginServlets.get(string);
        if (webappServletPluginExtension != null) {
            if (webappServletPluginExtension.requiresAuthorization()) {
                if (!httpServletRequest.isUserInRole(ADMIN_ROLE_NAME)) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
            webappServletPluginExtension.doDelete(httpServletRequest, httpServletResponse);
        } else {
            logger.warn((Object)("No plugin defined for path :" + string));
        }
    }

    private String adjustPath(String string) {
        if (string != null) {
            string = string.startsWith("/") ? string.substring(1) : string;
            string = string.split("/")[0].trim();
        }
        return string;
    }
}

