/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginManager;

@SkipObfuscate
public class WebappPluginStaticResources
extends HttpServlet {
    private static final int BAD_REQUEST_400 = 400;
    private static final Logger logger = Logger.getLogger((String)WebappPluginStaticResources.class.getName());
    private Map<String, File> staticResourcesFolders;

    public void init() throws ServletException {
        super.init();
        this.staticResourcesFolders = new HashMap<String, File>();
        PluginManager pluginManager = PluginManager.getInstance();
        List<PluginDescriptor> list = pluginManager.getPluginDescriptors();
        for (PluginDescriptor pluginDescriptor : list) {
            File file = pluginDescriptor.getBaseDir();
            List<PluginDescriptor.PluginExtensionDescription> list2 = pluginDescriptor.getExtensions("WebappStaticResourcesFolder");
            for (PluginDescriptor.PluginExtensionDescription pluginExtensionDescription : list2) {
                String string = this.trimSlasheshFromPath(pluginExtensionDescription.f);
                this.staticResourcesFolders.put(string, new File(file, this.trimSlasheshFromPath(pluginExtensionDescription.e)));
            }
        }
        logger.debug((Object)("Registered " + this.staticResourcesFolders.size() + " static resource folders providing plugins."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        String string2 = this.adjustPath(string);
        File file = this.staticResourcesFolders.get(string2);
        String string3 = this.getResourcePath(string);
        if (file != null) {
            if (string3 != null && !string3.trim().isEmpty()) {
                File file2 = new File(file, string3);
                if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                    this.setContentHeaders(httpServletResponse, file2);
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file2);
                            IOUtils.copy((InputStream)fileInputStream, (OutputStream)httpServletResponse.getOutputStream());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            httpServletResponse.sendError(404, fileNotFoundException.getMessage());
                        }
                        catch (IOException iOException) {
                            httpServletResponse.sendError(500, iOException.getMessage());
                        }
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                } else {
                    logger.error((Object)"Trying to access resource outside the resource folder.");
                    httpServletResponse.sendError(400);
                }
            } else {
                logger.warn((Object)("no resource path has been specified for the plugin " + string2));
                httpServletResponse.sendError(400);
            }
        } else {
            httpServletResponse.setStatus(400);
            logger.warn((Object)("No plugin defined for path :" + string2));
        }
    }

    private void setContentHeaders(HttpServletResponse httpServletResponse, File file) {
        if (file.getName().endsWith(".css")) {
            httpServletResponse.addHeader("Content-Type", "text/css");
        } else if (file.getName().endsWith(".js")) {
            httpServletResponse.addHeader("Content-Type", "application/javascript");
        } else if (file.getName().endsWith(".svg")) {
            httpServletResponse.addHeader("Content-Type", "image/svg+xml");
        } else if (file.getName().endsWith(".png")) {
            httpServletResponse.addHeader("Content-Type", "image/png");
        } else if (file.getName().endsWith(".jpe") || file.getName().endsWith(".jpeg") || file.getName().endsWith(".jpg")) {
            httpServletResponse.addHeader("Content-Type", "image/jpeg");
        } else if (file.getName().endsWith(".gif")) {
            httpServletResponse.addHeader("Content-Type", "image/gif");
        } else if (file.getName().endsWith(".tif")) {
            httpServletResponse.addHeader("Content-Type", "image/tiff");
        } else if (file.getName().endsWith(".bmp")) {
            httpServletResponse.addHeader("Content-Type", "image/bmp");
        } else if (file.getName().endsWith(".html")) {
            httpServletResponse.addHeader("Content-Type", "text/html");
        }
    }

    private String trimSlasheshFromPath(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String adjustPath(String string) {
        if (string != null) {
            string = string.startsWith("/") ? string.substring(1) : string;
            string = string.split("/")[0].trim();
        }
        return string;
    }

    private String getResourcePath(String string) {
        int n2;
        String string2 = null;
        if (string != null && (n2 = (string = string.startsWith("/") ? string.substring(1) : string).indexOf("/")) != -1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }
}

