/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.SAPropertyPanel;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;
import ro.sync.util.Resource;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SATablePropertiesCustomizerDialog
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger((String)SATablePropertiesCustomizerDialog.class.getName());
    private JTabbedPane tabbedPane;
    private AuthorResourceBundle authorResourceBundle;
    private ColorThemeUtilities colorThemeUtilities;

    public SATablePropertiesCustomizerDialog(Frame frame, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities) {
        super(frame, authorResourceBundle.getMessage("Table_properties"), true);
        this.authorResourceBundle = authorResourceBundle;
        this.colorThemeUtilities = colorThemeUtilities;
    }

    public EditedTablePropertiesInfo getTablePropertiesInformation(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        Object object;
        EditedTablePropertiesInfo editedTablePropertiesInfo2 = null;
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabbedPane = new JTabbedPane();
        List<TabInfo> list = editedTablePropertiesInfo.getCategories();
        EditedTablePropertiesInfo.TAB_TYPE tAB_TYPE = editedTablePropertiesInfo.getSelectedTab();
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list.get(i2);
            SAPropertiesPanel sAPropertiesPanel = new SAPropertiesPanel(((TabInfo)object).getProperties(), ((TabInfo)object).getContextInfo());
            this.tabbedPane.addTab(this.authorResourceBundle.getMessage(((TabInfo)object).getTabKey()), sAPropertiesPanel);
            if (((TabInfo)object).getTabKey().equals("Table") && tAB_TYPE == EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB) {
                n2 = i2;
                continue;
            }
            if ((((TabInfo)object).getTabKey().equals("Row") || ((TabInfo)object).getTabKey().equals("Rows")) && tAB_TYPE == EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB) {
                n2 = i2;
                continue;
            }
            if ((((TabInfo)object).getTabKey().equals("Column") || ((TabInfo)object).getTabKey().equals("Columns")) && tAB_TYPE == EditedTablePropertiesInfo.TAB_TYPE.COLUMN_TAB) {
                n2 = i2;
                continue;
            }
            if (!((TabInfo)object).getTabKey().equals("Cell") && !((TabInfo)object).getTabKey().equals("Cells") || tAB_TYPE != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) continue;
            n2 = i2;
        }
        if (list.size() > 0) {
            this.tabbedPane.setSelectedIndex(n2);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().add((Component)this.tabbedPane, gridBagConstraints);
        this.setResizable(true);
        this.pack();
        this.setMinimumSize(new Dimension(this.getSize().width, this.getSize().height));
        this.setVisible(true);
        if (this.getResult() == 1) {
            object = new ArrayList();
            for (int i3 = 0; i3 < this.tabbedPane.getComponentCount(); ++i3) {
                SAPropertiesPanel sAPropertiesPanel = (SAPropertiesPanel)this.tabbedPane.getComponentAt(i3);
                TabInfo tabInfo = list.get(i3);
                if (sAPropertiesPanel.getModifiedProperties().isEmpty()) continue;
                object.add(new TabInfo(tabInfo.getTabKey(), sAPropertiesPanel.getModifiedProperties(), tabInfo.getNodes()));
            }
            if (!object.isEmpty()) {
                editedTablePropertiesInfo2 = new EditedTablePropertiesInfo((List<TabInfo>)object);
            }
        }
        return editedTablePropertiesInfo2;
    }

    class SAPropertiesPanel
    extends JPanel
    implements PropertySelectionController {
        private final List<SAPropertyPanel> propertyPanels = new ArrayList<SAPropertyPanel>();
        private final Map<String, JLabel> previews = new HashMap<String, JLabel>();

        public SAPropertiesPanel(List<TableProperty> list, String string) {
            ArrayList<TableProperty> arrayList;
            Object object;
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            LinkedHashMap<String, ArrayList<TableProperty>> linkedHashMap = new LinkedHashMap<String, ArrayList<TableProperty>>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                object = list.get(i2);
                String string2 = ((TableProperty)object).getParentGroup();
                arrayList = (ArrayList<TableProperty>)linkedHashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<TableProperty>();
                }
                arrayList.add((TableProperty)object);
                linkedHashMap.put(string2, arrayList);
                this.previews.put(string2, new JLabel());
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 4, 2, 4);
            object = linkedHashMap.keySet();
            boolean bl = true;
            arrayList = object.iterator();
            while (arrayList.hasNext()) {
                String string3 = (String)arrayList.next();
                List list2 = (List)linkedHashMap.get(string3);
                this.addGroup(gridBagConstraints, bl, string3, list2);
                if (!bl) continue;
                bl = false;
            }
            if (string != null) {
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets.top += 7;
                gridBagConstraints.insets.left += 10;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 2;
                this.add((Component)new JLabel(string), gridBagConstraints);
            }
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)new JLabel(""), gridBagConstraints);
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                this.setOpaque(false);
            }
        }

        private void addGroup(GridBagConstraints gridBagConstraints, boolean bl, String string, List<TableProperty> list) {
            Object object;
            Serializable serializable;
            JPanel jPanel = new JPanel(new GridBagLayout());
            int n2 = 1;
            if (list.size() == 1 && list.get(0).getGuiType() == GuiElements.COMBOBOX) {
                serializable = BorderFactory.createTitledBorder("");
                TitledBorder titledBorder = BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage(string));
                object = serializable.getBorderInsets(jPanel);
                jPanel.setBorder(BorderFactory.createEmptyBorder(((Insets)object).top, titledBorder.getBorderInsets((Component)jPanel).left, ((Insets)object).bottom, ((Insets)object).right));
            } else {
                jPanel.setBorder(BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage(string)));
            }
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                jPanel.setOpaque(false);
            }
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).anchor = 17;
            ((GridBagConstraints)serializable).insets.top += 2;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).getGuiType() == GuiElements.COMBOBOX) {
                    n2 = 2;
                } else if (1 > n2) {
                    n2 = 1;
                }
                object = new SAPropertyPanel(jPanel, (GridBagConstraints)serializable, list.get(i2), SATablePropertiesCustomizerDialog.this.authorResourceBundle, this, 0, i2 == 0);
                this.propertyPanels.add((SAPropertyPanel)object);
            }
            ((GridBagConstraints)serializable).fill = 1;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 1.0;
            gridBagConstraints.gridx = 0;
            ((GridBagConstraints)serializable).gridwidth = n2;
            jPanel.add((Component)new JLabel(""), serializable);
            gridBagConstraints.insets.top = bl ? 5 : 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)jPanel, gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SATablePropertiesCustomizerDialog.this.authorResourceBundle.getMessage("Preview")), BorderFactory.createEmptyBorder(0, 0, 6, 0)));
            if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities == null || !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isDarkTheme()) {
                jPanel2.setOpaque(false);
            }
            object = new GridBagConstraints();
            ((GridBagConstraints)object).gridx = 0;
            ((GridBagConstraints)object).gridy = 0;
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).anchor = 10;
            this.previews.get(string).setFocusable(false);
            this.previews.get(string).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)this.previews.get(string), object);
            jPanel2.setPreferredSize(new Dimension(150, jPanel2.getPreferredSize().height));
            jPanel2.setMinimumSize(new Dimension(150, jPanel2.getMinimumSize().height));
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)jPanel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }

        @Override
        public void selectionChanged(TableProperty tableProperty, String string) throws AuthorOperationException {
            Object object;
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = tableProperty.getParentGroup();
            if ("colsep".equalsIgnoreCase(tableProperty.getAttributeName()) || "rowsep".equalsIgnoreCase(tableProperty.getAttributeName())) {
                object2 = "<not set>";
                object = "<not set>";
                boolean bl = true;
                if ("colsep".equalsIgnoreCase(tableProperty.getAttributeName())) {
                    object2 = string;
                } else {
                    object = string;
                    bl = false;
                }
                for (int i2 = 0; i2 < this.propertyPanels.size(); ++i2) {
                    SAPropertyPanel sAPropertyPanel = this.propertyPanels.get(i2);
                    if (bl && "rowsep".equalsIgnoreCase(sAPropertyPanel.getTableProperty().getAttributeName())) {
                        object = sAPropertyPanel.getCurrentlySelectedValue();
                        continue;
                    }
                    if (bl || !"colsep".equalsIgnoreCase(sAPropertyPanel.getTableProperty().getAttributeName())) continue;
                    object2 = sAPropertyPanel.getCurrentlySelectedValue();
                }
                if ("1".equals(object2) && "1".equals(object)) {
                    stringBuilder.append("/images/table-properties/ColRowSep.png");
                } else if ("1".equals(object2)) {
                    stringBuilder.append("/images/table-properties/ColSep.png");
                } else if ("1".equals(object)) {
                    stringBuilder.append("/images/table-properties/RowSep.png");
                } else {
                    stringBuilder.append("/images/table-properties/EmptyIcon.png");
                }
            } else {
                object2 = null;
                object2 = tableProperty.getIcons().get(string);
                if (object2 != null) {
                    stringBuilder.append((String)object2);
                } else {
                    stringBuilder.append("/images/table-properties/EmptyIcon.png");
                }
            }
            object2 = this.previews.get(string2);
            if (object2 != null) {
                object = null;
                URL uRL = Resource.getResource(stringBuilder.toString());
                try {
                    object = (BufferedImage)SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getImageInverter().loadImage(uRL);
                }
                catch (IOException iOException) {
                    throw new AuthorOperationException(iOException.getMessage());
                }
                if (SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isHighContrastTheme() && !SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getColorTheme().isHighContrastWhiteTheme()) {
                    try {
                        object = (BufferedImage)SATablePropertiesCustomizerDialog.this.colorThemeUtilities.getImageInverter().invertImage(object);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)iOException, (Throwable)iOException);
                    }
                }
                ImageIcon imageIcon = new ImageIcon((Image)object);
                ((JLabel)object2).setIcon(imageIcon);
                ((Component)object2).repaint();
            }
        }

        public List<TableProperty> getModifiedProperties() {
            ArrayList<TableProperty> arrayList = new ArrayList<TableProperty>();
            for (int i2 = 0; i2 < this.propertyPanels.size(); ++i2) {
                TableProperty tableProperty = this.propertyPanels.get(i2).getModifiedProperty();
                if (tableProperty == null) continue;
                arrayList.add(tableProperty);
            }
            return arrayList;
        }
    }
}

