/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECPropertyComposite {
    private ComboViewer propertyValuesCombo = null;
    List<Button> radioButtons = null;
    private TableProperty tableProperty;
    private String currentlySelectedValue;
    private PropertySelectionController controller;

    public ECPropertyComposite(Composite composite, TableProperty tableProperty, AuthorResourceBundle authorResourceBundle, PropertySelectionController propertySelectionController, boolean bl) {
        this.tableProperty = tableProperty;
        this.controller = propertySelectionController;
        this.currentlySelectedValue = tableProperty.getCurrentValue();
        String string = tableProperty.getAttributeName();
        String string2 = tableProperty.getAttributeRenderString();
        List<String> list = tableProperty.getValues();
        String string3 = string2 != null ? authorResourceBundle.getMessage(string2) : string;
        GuiElements guiElements = tableProperty.getGuiType();
        if (GuiElements.COMBOBOX == guiElements) {
            string3 = string3 + ":";
            Label label = new Label(composite, 16384);
            label.setText(string3);
            this.propertyValuesCombo = new ComboViewer(composite);
            this.propertyValuesCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object object, Object object2) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object object) {
                    return (Object[])object;
                }
            });
            this.propertyValuesCombo.setLabelProvider((IBaseLabelProvider)new FontLabelProvider());
            this.propertyValuesCombo.setInput((Object)list.toArray(new String[0]));
            GridData gridData = new GridData(4, 0, true, false);
            gridData.grabExcessHorizontalSpace = true;
            this.propertyValuesCombo.getCombo().setLayoutData((Object)gridData);
            this.propertyValuesCombo.getCombo().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ECPropertyComposite.this.comboSelectionChanged();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    ECPropertyComposite.this.comboSelectionChanged();
                }
            });
            if (tableProperty.getCurrentValue() != null) {
                int n2 = list.indexOf(tableProperty.getCurrentValue());
                this.propertyValuesCombo.getCombo().select(n2);
                this.comboSelectionChanged();
            }
            this.propertyValuesCombo.getCombo().setEnabled(this.tableProperty.isActive());
        } else if (GuiElements.RADIO_BUTTONS == guiElements) {
            this.radioButtons = new ArrayList<Button>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                final Button button = new Button(composite, 16400);
                String string4 = list.get(i2);
                button.setText(string4);
                if ("<not set>".equals(string4) || "<preserve>".equals(string4)) {
                    FontData fontData = button.getFont().getFontData()[0];
                    fontData.setStyle(2);
                    final Font font = new Font((Device)composite.getDisplay(), fontData);
                    button.setFont(font);
                    button.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            font.dispose();
                        }
                    });
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        ECPropertyComposite.this.radioSelectionChanged(button);
                    }

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        ECPropertyComposite.this.radioSelectionChanged(button);
                    }
                });
                if (this.tableProperty.getCurrentValue() != null && string4.equals(this.tableProperty.getCurrentValue())) {
                    button.setSelection(true);
                    this.radioSelectionChanged(button);
                } else {
                    button.setSelection(false);
                }
                button.setEnabled(this.tableProperty.isActive());
                this.radioButtons.add(button);
            }
        }
    }

    public TableProperty getModifiedProperty() {
        TableProperty tableProperty = null;
        String string = this.tableProperty.getCurrentValue();
        if (this.tableProperty.getGuiType() == GuiElements.COMBOBOX) {
            int n2 = this.propertyValuesCombo.getCombo().getSelectionIndex();
            string = this.propertyValuesCombo.getCombo().getItem(n2);
        } else if (this.tableProperty.getGuiType() == GuiElements.RADIO_BUTTONS) {
            for (int i2 = 0; i2 < this.radioButtons.size(); ++i2) {
                Button button = this.radioButtons.get(i2);
                boolean bl = button.getSelection();
                if (!bl) continue;
                string = button.getText();
                break;
            }
        }
        if (this.tableProperty.getCurrentValue() == null || this.tableProperty.getCurrentValue() != null && !this.tableProperty.getCurrentValue().equals(string)) {
            tableProperty = new TableProperty(this.tableProperty.getAttributeName(), this.tableProperty.getAttributeRenderString(), this.tableProperty.getValues(), string, this.tableProperty.isAttribute());
            tableProperty.setOldValue(this.tableProperty.getCurrentValue());
        }
        return tableProperty;
    }

    public TableProperty getTableProperty() {
        return this.tableProperty;
    }

    public String getCurrentlySelectedValue() {
        return this.currentlySelectedValue;
    }

    private void comboSelectionChanged() {
        this.currentlySelectedValue = this.propertyValuesCombo.getCombo().getItem(this.propertyValuesCombo.getCombo().getSelectionIndex());
        if (this.currentlySelectedValue != null) {
            try {
                this.controller.selectionChanged(this.tableProperty, this.currentlySelectedValue);
            }
            catch (AuthorOperationException authorOperationException) {
                // empty catch block
            }
        }
    }

    private void radioSelectionChanged(Button button) {
        this.currentlySelectedValue = button.getText();
        try {
            this.controller.selectionChanged(this.tableProperty, this.currentlySelectedValue);
        }
        catch (AuthorOperationException authorOperationException) {
            // empty catch block
        }
    }

    private class FontLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font italicFont = null;
        private Font normalFont = null;

        private FontLabelProvider() {
            FontData fontData = ECPropertyComposite.this.propertyValuesCombo.getControl().getFont().getFontData()[0];
            fontData.setStyle(2);
            this.italicFont = new Font((Device)Display.getDefault(), fontData);
            fontData.setStyle(0);
            this.normalFont = new Font((Device)Display.getDefault(), fontData);
        }

        public Font getFont(Object object) {
            if ("<preserve>".equals(this.getText(object)) || "<not set>".equals(this.getText(object))) {
                return this.italicFont;
            }
            return this.normalFont;
        }

        public void dispose() {
            this.italicFont.dispose();
            this.normalFont.dispose();
            super.dispose();
        }
    }
}

