/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLConstants;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements XHTMLConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"tr"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"td", "th"};
    public static final String[] TABLE_ELEMENT_NAMES = new String[]{"table", "informaltable"};

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement) throws AuthorOperationException {
    }

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement authorElement) {
        HTMLTableCellInfoProvider hTMLTableCellInfoProvider = new HTMLTableCellInfoProvider();
        hTMLTableCellInfoProvider.init(authorElement);
        return hTMLTableCellInfoProvider;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        if (n4 > 1) {
            authorAccess.getDocumentController().setAttribute("colspan", new AttrValue(String.valueOf(n4)), authorElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("colspan", authorElement);
        }
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
        if (n2 > 1) {
            authorAccess.getDocumentController().setAttribute("rowspan", new AttrValue(String.valueOf(n2)), authorElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("rowspan", authorElement);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"rowspan", "colspan"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"rowspan"};
    }
}

