/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements CALSConstants,
InsertTableCellsContentConstants {
    private ArgumentDescriptor[] arguments;
    protected String cellContent;

    public InsertColumnOperation() {
        super(new CALSDocumentTypeHelper());
        ArgumentDescriptor[] argumentDescriptorArray = super.getArguments();
        if (argumentDescriptorArray != null) {
            this.arguments = new ArgumentDescriptor[argumentDescriptorArray.length + 1];
            for (int i2 = 0; i2 < argumentDescriptorArray.length; ++i2) {
                this.arguments[i2] = argumentDescriptorArray[i2];
            }
            this.arguments[argumentDescriptorArray.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            this.arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        Object object = argumentsMap.getArgumentValue("cellFragment");
        if (object instanceof String) {
            this.cellContent = (String)object;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperation(authorAccess, argumentsMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, TableColumnSpecificationInformation tableColumnSpecificationInformation, String string, int n3) throws AuthorOperationException {
        void var18_31;
        Set<CALSColSpec> set = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getColSpecs();
        int n4 = -1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        for (CALSColSpec cALSColSpec : set) {
            if (cALSColSpec.getColumnName() != null) {
                ++n5;
            }
            if (!cALSColSpec.isColNumberSpecified()) continue;
            ++n6;
        }
        boolean bl2 = set.size() == 0 || n6 > 0;
        boolean bl3 = set.size() == 0 || n5 > 0;
        for (CALSColSpec hashSet2 : set) {
            n4 = hashSet2.getIndexInDocument();
            if (hashSet2.getColumnNumber() < n2 + 1) continue;
            bl = true;
            break;
        }
        int n7 = -1;
        if (n4 != -1) {
            List<AuthorNode> list = authorElement.getContentNodes();
            for (AuthorNode authorNode : list) {
                AttrValue attrValue;
                if (!this.isElement(authorNode, "colspec") || (attrValue = ((AuthorElement)authorNode).getAttribute("colnum")) == null) continue;
                try {
                    int n8 = Integer.parseInt(attrValue.getValue());
                    if (n8 < n2 + 1) continue;
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (n8 + n3)), (AuthorElement)authorNode);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int n9 = 0;
            for (AuthorNode authorNode : list) {
                if (this.isElement(authorNode, "colspec") && n9 == n4) {
                    n7 = bl ? authorNode.getStartOffset() : authorNode.getEndOffset() + 1;
                    break;
                }
                ++n9;
            }
        } else if (n2 == 0) {
            n7 = authorElement.getStartOffset() + 1;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (CALSColSpec cALSColSpec : set) {
            hashSet.add(cALSColSpec.getColumnName());
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        while (var18_31 < n3) {
            void var19_40;
            if (n7 != -1) {
                WidthRepresentation widthRepresentation;
                stringBuilder.append("<").append("colspec");
                if (string != null) {
                    stringBuilder.append(" xmlns=\"").append(string).append("\"");
                }
                Object var19_36 = null;
                if (bl3) {
                    void var19_38;
                    if (tableColumnSpecificationInformation instanceof CALSTableColumnSpecificationInformation) {
                        String string2 = ((CALSTableColumnSpecificationInformation)tableColumnSpecificationInformation).getColumnName();
                    }
                    if (var19_38 == null) {
                        String string3 = this.getUniqueColSpecName(hashSet, n2 + var18_31 + 1);
                        hashSet.add(string3);
                    }
                    stringBuilder.append(" ").append("colname");
                    stringBuilder.append("=\"").append((String)var19_40).append("\"");
                }
                if (bl2) {
                    stringBuilder.append(" ").append("colnum");
                    stringBuilder.append("=\"").append(n2 + var18_31 + 1).append("\"");
                }
                String string4 = this.getDefaultColWidthValue();
                if (tableColumnSpecificationInformation != null && (widthRepresentation = tableColumnSpecificationInformation.getWidthRepresentation()) != null) {
                    string4 = widthRepresentation.getWidthRepresentation();
                }
                if (string4 != null) {
                    stringBuilder.append(" ").append("colwidth");
                    stringBuilder.append("=\"").append(string4).append("\"");
                }
            } else {
                throw new AuthorOperationException("Could not compute the index of the column to be inserted.");
            }
            stringBuilder.append("/>");
            hashSet.add((String)var19_40);
            ++var18_31;
        }
        authorAccess.getDocumentController().insertXMLFragment(stringBuilder.toString(), n7);
    }

    protected String getDefaultColWidthValue() {
        return "1*";
    }

    private String getUniqueColSpecName(Set<String> set, int n2) {
        String string = "newCol" + n2;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            for (String string2 : set) {
                if (!string.equals(string2)) continue;
                bl = false;
                string = "newCol" + ++n2;
                continue block0;
            }
        }
        return string;
    }

    @Override
    protected String getCellElementName(AuthorElement authorElement, int n2) {
        return "entry";
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

