/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.TableSortOperation;
import ro.sync.ecss.extensions.commons.sort.TableSortUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class CALSAndHTMLTableSortOperation
extends TableSortOperation {
    @Override
    public AuthorElement getSortParent(int n2, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode;
        AuthorNode authorNode2;
        if (authorAccess.getEditorAccess().hasSelection() && (authorNode2 = authorAccess.getEditorAccess().getFullySelectedNode()) != null && authorNode2.getType() == 0) {
            Object object;
            authorNode = (AuthorElement)authorNode2;
            if (this.isTableBody((AuthorElement)authorNode)) {
                return authorNode;
            }
            if (this.isTableHead((AuthorElement)authorNode) || this.isTableFoot((AuthorElement)authorNode)) {
                object = authorNode.getParent();
                if (object.getType() == 0) {
                    return this.getBodyElement((AuthorNode)object);
                }
            } else if (this.isTable((AuthorElement)authorNode) || this.isTableGroup((AuthorElement)authorNode)) {
                object = authorNode.getContentNodes();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    AuthorNode authorNode3 = (AuthorNode)object.get(i2);
                    if (authorNode3.getType() != 0) continue;
                    AuthorElement authorElement = (AuthorElement)authorNode3;
                    if (this.isTableBody(authorElement)) {
                        return authorElement;
                    }
                    if (!this.isTableGroup(authorElement)) continue;
                    return this.getBodyElement(authorElement);
                }
            }
        }
        try {
            for (authorNode2 = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode2 != null && authorNode2.getType() != 2; authorNode2 = authorNode2.getParent()) {
                if (authorNode2.getType() == 0 && this.isTableBody((AuthorElement)authorNode2)) {
                    return (AuthorElement)authorNode2;
                }
                if (authorNode2.getType() != 0 || !this.isTableHead((AuthorElement)authorNode2) && !this.isTableFoot((AuthorElement)authorNode2)) continue;
                authorNode = authorNode2.getParent();
                return this.getBodyElement(authorNode);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
        }
        return null;
    }

    private AuthorElement getBodyElement(AuthorNode authorNode) {
        if (authorNode == null) {
            return null;
        }
        if (authorNode.getType() == 0) {
            List<AuthorNode> list = ((AuthorElement)authorNode).getContentNodes();
            for (int i2 = 0; list != null && i2 < list.size(); ++i2) {
                AuthorNode authorNode2 = list.get(i2);
                if (authorNode2.getType() != 0 || !this.isTableBody((AuthorElement)authorNode2)) continue;
                return (AuthorElement)authorNode2;
            }
        }
        return null;
    }

    @Override
    public boolean isIgnored(AuthorNode authorNode) {
        return authorNode.getType() == 3 || authorNode.getType() == 5;
    }

    @Override
    public String[] getSortKeysValues(AuthorNode authorNode, SortCriteriaInformation sortCriteriaInformation) throws AuthorOperationException {
        CriterionInformation[] criterionInformationArray = sortCriteriaInformation.criteriaInfo;
        String[] stringArray = null;
        if (authorNode instanceof AuthorElement && criterionInformationArray.length > 0) {
            stringArray = new String[criterionInformationArray.length];
            AuthorElement authorElement = (AuthorElement)authorNode;
            if (this.isTableRow(authorElement)) {
                List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
                int n2 = list.size();
                for (int i2 = 0; i2 < criterionInformationArray.length; ++i2) {
                    CriterionInformation criterionInformation = criterionInformationArray[i2];
                    int n3 = criterionInformation.getKeyIndex();
                    AuthorNode authorNode2 = null;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int[] nArray;
                        AuthorNode authorNode3 = list.get(i3);
                        if (!(authorNode3 instanceof AuthorElement) || (nArray = this.authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode3)) == null || nArray[0] > n3 || nArray[1] < n3) continue;
                        authorNode2 = authorNode3;
                        break;
                    }
                    if (authorNode2 == null) continue;
                    stringArray[i2] = this.getTextContentToSort(authorNode2);
                }
            }
        }
        return stringArray;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement authorElement) throws AuthorOperationException {
        ArrayList<CriterionInformation> arrayList;
        block8: {
            Object object;
            AuthorElement authorElement2;
            block9: {
                AuthorNode authorNode;
                Object object2;
                arrayList = new ArrayList<CriterionInformation>();
                List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
                int n2 = 0;
                authorElement2 = null;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    int n3;
                    object2 = list.get(i2);
                    if (object2.getType() != 0 || (n3 = this.getNonIgnoredChildren((AuthorElement)object2).size()) <= n2) continue;
                    authorElement2 = (AuthorElement)object2;
                    n2 = n3;
                }
                AuthorElementBaseInterface authorElementBaseInterface = null;
                authorElementBaseInterface = authorElement.getParentElement();
                if (authorElementBaseInterface == null) break block8;
                object2 = authorElementBaseInterface.getContentNodes();
                AuthorElement authorElement3 = null;
                for (int i3 = 0; i3 < object2.size(); ++i3) {
                    AuthorElement authorElement4;
                    object = (AuthorNode)object2.get(i3);
                    if (object.getType() != 0 || !this.isTableHead(authorElement4 = (AuthorElement)object)) continue;
                    authorElement3 = authorElement4;
                    break;
                }
                AuthorElement authorElement5 = null;
                if (authorElement3 != null) {
                    object = this.getNonIgnoredChildren(authorElement3);
                    for (int i4 = 0; i4 < object.size(); ++i4) {
                        int n4;
                        authorNode = object.get(i4);
                        if (authorNode.getType() != 0 || (n4 = this.getNonIgnoredChildren((AuthorElement)authorNode).size()) != n2) continue;
                        authorElement5 = (AuthorElement)authorNode;
                        break;
                    }
                }
                if (authorElement5 == null || authorElement2 == null) break block9;
                object = this.getNonIgnoredChildren(authorElement5);
                for (int i5 = 0; i5 < n2; ++i5) {
                    authorNode = object.get(i5);
                    if (authorNode.getType() != 0) continue;
                    try {
                        AuthorElement authorElement6 = (AuthorElement)authorNode;
                        String string = authorElement6.getTextContent();
                        arrayList.add(new CriterionInformation(i5, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), string.length() > 0 ? string : "Column " + (i5 + 1), TableSortUtil.isEntirelySelected(this.authorAccess, authorElement6) || this.isCaretInColumn(this.authorAccess, i5)));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
                    }
                }
                break block8;
            }
            if (authorElement2 == null) break block8;
            object = this.getNonIgnoredChildren(authorElement2);
            for (int i6 = 0; i6 < object.size(); ++i6) {
                if (object.get(i6).getType() != 0) continue;
                arrayList.add(new CriterionInformation(i6, CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.ORDER.ASCENDING.getName(), "Column " + (i6 + 1), TableSortUtil.isEntirelySelected(this.authorAccess, (AuthorElement)object.get(i6)) || this.isCaretInColumn(this.authorAccess, i6)));
            }
        }
        return arrayList;
    }

    @Override
    protected boolean forceSortAll() {
        return TableSortUtil.isColumnOrTableSelection(this.authorAccess);
    }

    public boolean isCaretInColumn(AuthorAccess authorAccess, int n2) {
        if (n2 < 0) {
            return false;
        }
        boolean bl = false;
        int n3 = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n3);
            if (authorNode != null && authorNode.getType() == 0 && authorNode.getParent().getType() == 0 && this.isTableRow((AuthorElement)authorNode.getParent())) {
                List<AuthorNode> list = this.getNonIgnoredChildren((AuthorElement)authorNode.getParent());
                int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices((AuthorElement)authorNode);
                if (nArray != null) {
                    if (nArray[0] <= n2 && nArray[1] >= n2) {
                        bl = true;
                    }
                } else if (n2 < list.size()) {
                    bl = list.get(n2) == authorNode;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    protected int getRowIndexForTableBody(AuthorNode authorNode) {
        int n2 = 0;
        if (authorNode.getParent() != null) {
            AuthorNode authorNode2 = authorNode.getParent();
            List<AuthorNode> list = ((AuthorParentNode)authorNode2).getContentNodes();
            for (AuthorNode authorNode3 : list) {
                if (authorNode3.getType() != 0) continue;
                if (this.isTableHead((AuthorElement)authorNode3)) {
                    ++n2;
                    continue;
                }
                if (!this.isTableFoot((AuthorElement)authorNode3)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public abstract boolean isTableBody(AuthorElement var1);

    public abstract boolean isTableRow(AuthorElement var1);

    public abstract boolean isTableHead(AuthorElement var1);

    public abstract boolean isTableFoot(AuthorElement var1);

    public abstract boolean isTable(AuthorElement var1);

    public abstract boolean isTableGroup(AuthorElement var1);
}

