/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SplitLeftRightOperationBase
extends AbstractTableOperation {
    private static final String SPLIT_LEFT = "Left";
    private static final String SPLIT_RIGHT = "Right";
    private static final String ARGUMENT_NAME = "Split point";

    public SplitLeftRightOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        try {
            AuthorTableCellSpanProvider authorTableCellSpanProvider;
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            AuthorElement authorElement = this.getElementAncestor(authorNode, 0);
            if (authorElement != null) {
                int n3;
                AuthorElement authorElement2 = this.getElementAncestor(authorNode, 2);
                if (authorElement2 == null) throw new AuthorOperationException("The table cell must be inside a table element.");
                authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement2);
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, authorElement);
                Integer n4 = authorTableCellSpanProvider.getColSpan(authorElement);
                int n5 = n3 = n4 != null ? n4 : 1;
                if (n3 <= 1) {
                    AuthorOperationException authorOperationException = new AuthorOperationException("The cell you are trying to split does not span over multiple columns.");
                    authorOperationException.setOperationRejectedOnPurpose(true);
                    throw authorOperationException;
                }
            } else {
                AuthorOperationException authorOperationException = new AuthorOperationException("The caret must be inside a table cell.");
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            boolean bl = SPLIT_LEFT.equals(argumentsMap.getArgumentValue(ARGUMENT_NAME));
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            AuthorDocumentFragment authorDocumentFragment = this.createEmptyCell(authorAccess, authorElement, this.getAttributesSkippedAtCopy());
            int n6 = -1;
            n6 = bl ? authorElement.getStartOffset() : authorElement.getEndOffset() + 1;
            this.decreaseColSpan(authorAccess, authorTableCellSpanProvider, authorElement, bl);
            authorDocumentController.insertFragment(n6, authorDocumentFragment);
            authorAccess.getEditorAccess().setCaretPosition(n6 + 1);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The location relative to the source cell for the newly split cell.", new String[]{SPLIT_LEFT, SPLIT_RIGHT}, SPLIT_LEFT)};
    }

    @Override
    public String getDescription() {
        return "This operation splits the content of a table cell that spans over multiple columns.";
    }

    private void decreaseColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, boolean bl) throws AuthorOperationException {
        int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement);
        int n2 = nArray[0] + 1;
        int n3 = nArray[1] + 1;
        if (bl) {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2 + 1, n3);
        } else {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, n3 - 1);
        }
    }

    protected abstract String[] getAttributesSkippedAtCopy();
}

