/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;
import ro.sync.xml.XmlUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SATableCustomizerDialog
extends OKCancelDialog
implements TableCustomizerConstants {
    private JCheckBox titleCheckbox;
    private JTextField titleTextField;
    private JSpinner rowsSpinner;
    private JSpinner columnsSpinner;
    private JComboBox colWidthsCombobox;
    private JCheckBox headerCheckbox;
    private JCheckBox footerCheckbox;
    private JComboBox frameCombo;
    private JComboBox rowsepCombo;
    private JComboBox colsepCombo;
    private JComboBox alignCombo;
    private final boolean hasFooter;
    private final boolean hasFrameAttribute;
    private final boolean hasRowsepAttribute;
    private final boolean hasColsepAttribute;
    private final boolean hasAlignAttribute;
    private boolean showModelChooser;
    private JRadioButton calsModelRadio;
    private JRadioButton otherModelRadio;
    private final boolean simpleTableModel;
    protected final AuthorResourceBundle authorResourceBundle;
    private final int predefinedColumnsCount;
    private final int predefinedRowsCount;
    private final boolean choiceTableModel;
    private boolean isCalsTable;

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, false, false, false, false, false, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, bl4, false, bl5, bl6, bl7, bl8, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, bl8, bl9, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        super(frame, authorResourceBundle.getMessage(bl5 ? "Insert_choice_table" : "Insert_table"), true);
        Object object;
        JLabel jLabel;
        TableCustomizerConstants.ColumnWidthsType[] columnWidthsTypeArray;
        JPanel jPanel;
        int n4;
        this.hasFooter = bl;
        this.hasFrameAttribute = bl2;
        this.showModelChooser = bl3;
        this.simpleTableModel = bl4;
        this.choiceTableModel = bl5;
        this.isCalsTable = bl6;
        this.hasRowsepAttribute = bl8;
        this.hasColsepAttribute = bl9;
        this.hasAlignAttribute = bl10;
        this.authorResourceBundle = authorResourceBundle;
        this.predefinedRowsCount = n2;
        this.predefinedColumnsCount = n3;
        this.setOkButtonText(authorResourceBundle.getMessage("Insert"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 3, 3));
        jPanel3.setBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Model")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.calsModelRadio = new JRadioButton("CALS");
        this.calsModelRadio.setName("CALS model");
        this.calsModelRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SATableCustomizerDialog.this.addValuesToFrameCombo(1);
                    SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(1));
                    SATableCustomizerDialog.this.updateTitleState(true);
                    SATableCustomizerDialog.this.updateElementsState(true);
                    SATableCustomizerDialog.this.updateAlignState(true);
                }
            }
        });
        jPanel3.add(this.calsModelRadio);
        buttonGroup.add(this.calsModelRadio);
        if (!bl5) {
            if (bl4) {
                this.otherModelRadio = new JRadioButton(authorResourceBundle.getMessage("Simple"));
                this.otherModelRadio.setName("Simple table model");
                this.otherModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(3));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(3);
                            SATableCustomizerDialog.this.updateTitleState(false);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(false);
                        }
                    }
                });
                jPanel3.add(this.otherModelRadio);
                buttonGroup.add(this.otherModelRadio);
            } else {
                this.otherModelRadio = new JRadioButton("HTML");
                this.otherModelRadio.setName("HTML model");
                this.otherModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(0));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(0);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(true);
                        }
                    }
                });
                jPanel3.add(this.otherModelRadio);
                buttonGroup.add(this.otherModelRadio);
            }
        } else {
            this.showModelChooser = false;
            jPanel3.setVisible(false);
        }
        int n5 = n4 = bl7 ? 1 : 2;
        if (bl3) {
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            n4 = 1;
        }
        if (!bl7 && !bl5) {
            this.titleCheckbox = this.createTitleCheckbox();
            this.titleCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SATableCustomizerDialog.this.titleTextField.setEditable(SATableCustomizerDialog.this.titleCheckbox.isSelected());
                }
            });
            this.titleCheckbox.setBorder(BorderFactory.createEmptyBorder());
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)this.titleCheckbox, gridBagConstraints);
            this.titleTextField = new JTextField();
            this.titleTextField.setName("Title text field");
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel2.add((Component)this.titleTextField, gridBagConstraints);
        }
        if (n3 <= 0 || n2 <= 0) {
            jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Table_size")));
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel2.add((Component)jPanel, gridBagConstraints);
            columnWidthsTypeArray = new GridBagConstraints();
            jLabel = new JLabel(authorResourceBundle.getMessage("Rows"));
            columnWidthsTypeArray.gridx = 0;
            columnWidthsTypeArray.gridy = 0;
            columnWidthsTypeArray.anchor = 17;
            columnWidthsTypeArray.fill = 2;
            columnWidthsTypeArray.weightx = 0.0;
            columnWidthsTypeArray.insets = new Insets(0, 5, 5, 5);
            jPanel.add((Component)jLabel, columnWidthsTypeArray);
            this.rowsSpinner = new JSpinner();
            this.rowsSpinner.setName("Rows spinner");
            this.rowsSpinner.setModel(new SpinnerNumberModel(2, 0, 1000, 1));
            ++columnWidthsTypeArray.gridx;
            columnWidthsTypeArray.weightx = 1.0;
            jPanel.add((Component)this.rowsSpinner, columnWidthsTypeArray);
            object = new JLabel(authorResourceBundle.getMessage("Columns"));
            ++columnWidthsTypeArray.gridx;
            columnWidthsTypeArray.weightx = 0.0;
            jPanel.add((Component)object, columnWidthsTypeArray);
            this.columnsSpinner = new JSpinner();
            this.columnsSpinner.setName("Columns spinner");
            this.columnsSpinner.setModel(new SpinnerNumberModel(2, 0, 100, 1));
            ++columnWidthsTypeArray.gridx;
            columnWidthsTypeArray.weightx = 1.0;
            jPanel.add((Component)this.columnsSpinner, columnWidthsTypeArray);
            if (bl5) {
                this.columnsSpinner.setEnabled(false);
                this.columnsSpinner.setValue(2);
            }
        }
        jPanel = new JPanel(new FlowLayout(0, 0, 0));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 1, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        this.headerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_header"));
        this.headerCheckbox.setName("Header checkbox");
        this.headerCheckbox.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add(this.headerCheckbox);
        if (bl) {
            jPanel.add(new JLabel("  "));
            this.footerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_footer"));
            this.footerCheckbox.setName("Footer checkbox");
            this.footerCheckbox.setBorder(BorderFactory.createEmptyBorder());
            jPanel.add(this.footerCheckbox);
        }
        if ((columnWidthsTypeArray = this.getColumnWidthsSpecifications(n4)) != null) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Column_widths") + ": ");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.colWidthsCombobox = new JComboBox();
            this.colWidthsCombobox.setName("Column Widths combo");
            object = this.colWidthsCombobox.getRenderer();
            this.colWidthsCombobox.setRenderer(new ListCellRenderer((ListCellRenderer)object){
                final /* synthetic */ ListCellRenderer val$initRenderer;
                {
                    this.val$initRenderer = listCellRenderer;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    String string = null;
                    if (TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS == object) {
                        string = "dynamic";
                    } else if (TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS == object) {
                        string = "proportional";
                    }
                    if (TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS == object) {
                        string = "fixed";
                    }
                    return this.val$initRenderer.getListCellRendererComponent(jList, string, n2, bl, bl2);
                }
            });
            this.updateColumnsWidthsCombo(columnWidthsTypeArray);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 1, 0);
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this.colWidthsCombobox, gridBagConstraints);
        }
        if (bl2) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Frame") + ": ");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.frameCombo = new JComboBox();
            this.frameCombo.setName("Frame combo");
            this.addValuesToFrameCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 1, 0);
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this.frameCombo, gridBagConstraints);
        }
        if (bl8) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Row_separator") + ": ");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.rowsepCombo = new JComboBox();
            this.rowsepCombo.setName("Rowsep combo");
            this.addValuesToRowsepCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 1, 0);
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this.rowsepCombo, gridBagConstraints);
        }
        if (bl9) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Column_separator") + ": ");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.colsepCombo = new JComboBox();
            this.colsepCombo.setName("Colsep combo");
            this.addValuesToColsepCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 1, 0);
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this.colsepCombo, gridBagConstraints);
        }
        if (bl10) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Alignment") + ": ");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(5, 0, 1, 0);
            gridBagConstraints.fill = 0;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            this.alignCombo = new JComboBox();
            this.alignCombo.setName("Align combo");
            this.addValuesToAlignCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints.fill = 2;
            jPanel2.add((Component)this.alignCombo, gridBagConstraints);
        }
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        this.setSize(340, this.getSize().height);
        this.setResizable(false);
    }

    protected void updateColumnsWidthsCombo(TableCustomizerConstants.ColumnWidthsType[] columnWidthsTypeArray) {
        if (this.colWidthsCombobox != null) {
            this.colWidthsCombobox.removeAllItems();
            for (int i2 = 0; i2 < columnWidthsTypeArray.length; ++i2) {
                this.colWidthsCombobox.addItem(columnWidthsTypeArray[i2]);
            }
        }
    }

    private void updateTitleState(boolean bl) {
        if (this.titleCheckbox != null) {
            this.titleCheckbox.setEnabled(bl);
            this.titleTextField.setEditable(bl && this.titleCheckbox.isSelected());
        }
    }

    private void updateElementsState(boolean bl) {
        if (this.rowsepCombo != null) {
            this.rowsepCombo.setEnabled(bl);
        }
        if (this.colsepCombo != null) {
            this.colsepCombo.setEnabled(bl);
        }
    }

    private void updateAlignState(boolean bl) {
        if (this.alignCombo != null) {
            this.alignCombo.setEnabled(bl);
        }
    }

    protected abstract String[] getFrameValues(int var1);

    protected abstract String getDefaultFrameValue(int var1);

    protected abstract String[] getRowsepValues(int var1);

    protected abstract String getDefaultRowsepValue(int var1);

    protected abstract String[] getColsepValues(int var1);

    protected abstract String[] getAlignValues(int var1);

    protected abstract String getDefaultColsepValue(int var1);

    protected abstract String getDefaultAlignValue(int var1);

    protected abstract TableCustomizerConstants.ColumnWidthsType[] getColumnWidthsSpecifications(int var1);

    protected abstract JCheckBox createTitleCheckbox();

    private void addValuesToFrameCombo(int n2) {
        String[] stringArray = this.getFrameValues(n2);
        this.frameCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.frameCombo.addItem(stringArray[i2]);
        }
        this.frameCombo.setSelectedItem(this.getDefaultFrameValue(n2));
    }

    private void addValuesToRowsepCombo(int n2) {
        String[] stringArray = this.getRowsepValues(n2);
        this.rowsepCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.rowsepCombo.addItem(stringArray[i2]);
        }
        this.rowsepCombo.setSelectedItem(this.getDefaultRowsepValue(n2));
    }

    private void addValuesToColsepCombo(int n2) {
        String[] stringArray = this.getColsepValues(n2);
        this.colsepCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.colsepCombo.addItem(stringArray[i2]);
        }
        this.colsepCombo.setSelectedItem(this.getDefaultColsepValue(n2));
    }

    private void addValuesToAlignCombo(int n2) {
        String[] stringArray = this.getAlignValues(n2);
        this.alignCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.alignCombo.addItem(stringArray[i2]);
        }
        this.alignCombo.setSelectedItem(this.getDefaultAlignValue(n2));
    }

    public TableInfo showDialog(TableInfo tableInfo) {
        this.initialize(tableInfo);
        super.setVisible(true);
        TableInfo tableInfo2 = null;
        if (this.getResult() == 1) {
            String string = null;
            if (this.titleCheckbox != null && this.titleCheckbox.isSelected()) {
                string = this.titleTextField.getText();
                string = XmlUtil.escape(string);
            }
            int n2 = this.predefinedRowsCount;
            int n3 = this.predefinedColumnsCount;
            if (this.predefinedColumnsCount <= 0 || this.predefinedRowsCount <= 0) {
                n2 = (Integer)this.rowsSpinner.getValue();
                n3 = (Integer)this.columnsSpinner.getValue();
            }
            int n4 = this.getTableModelType();
            tableInfo2 = new TableInfo(string, n2, n3, this.headerCheckbox.isSelected(), this.hasFooter ? this.footerCheckbox.isSelected() : false, this.hasFrameAttribute ? (!"<unspecified>".equals(this.frameCombo.getSelectedItem()) ? (String)this.frameCombo.getSelectedItem() : null) : null, n4, this.colWidthsCombobox != null ? (TableCustomizerConstants.ColumnWidthsType)((Object)this.colWidthsCombobox.getSelectedItem()) : null, this.hasRowsepAttribute ? (!"<unspecified>".equals(this.rowsepCombo.getSelectedItem()) ? (String)this.rowsepCombo.getSelectedItem() : null) : null, this.hasColsepAttribute ? (!"<unspecified>".equals(this.colsepCombo.getSelectedItem()) ? (String)this.colsepCombo.getSelectedItem() : null) : null, this.hasAlignAttribute ? (!"<unspecified>".equals(this.alignCombo.getSelectedItem()) ? (String)this.alignCombo.getSelectedItem() : null) : null);
        }
        return tableInfo2;
    }

    protected int getTableModelType() {
        int n2 = 2;
        if (this.showModelChooser) {
            n2 = this.calsModelRadio.isSelected() ? 1 : (this.simpleTableModel ? 3 : 0);
        } else if (this.choiceTableModel) {
            n2 = 4;
        }
        return n2;
    }

    private void initialize(TableInfo tableInfo) {
        if (this.titleCheckbox != null) {
            this.titleTextField.setEditable(true);
            this.titleTextField.setText("");
        }
        if (this.choiceTableModel) {
            this.updateColumnsWidthsCombo(this.getColumnWidthsSpecifications(4));
            this.addValuesToFrameCombo(4);
        }
        if (tableInfo != null) {
            if (this.titleCheckbox != null) {
                if (tableInfo.getTitle() != null) {
                    this.titleTextField.setText(tableInfo.getTitle());
                    this.titleCheckbox.setSelected(true);
                } else {
                    this.titleCheckbox.setSelected(false);
                    this.titleTextField.setEditable(false);
                }
            }
            if (this.showModelChooser) {
                this.calsModelRadio.setSelected(tableInfo.getTableModel() == 1 && this.isCalsTable);
                this.otherModelRadio.setSelected(tableInfo.getTableModel() != 1 || !this.isCalsTable);
            }
            if (this.predefinedColumnsCount <= 0 || this.predefinedRowsCount <= 0) {
                this.rowsSpinner.setValue(tableInfo.getRowsNumber());
                if (!this.choiceTableModel) {
                    this.columnsSpinner.setValue(tableInfo.getColumnsNumber());
                }
            }
            this.headerCheckbox.setSelected(tableInfo.isGenerateHeader());
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(tableInfo.isGenerateFooter());
            }
            if (this.colWidthsCombobox != null) {
                this.colWidthsCombobox.setSelectedItem((Object)tableInfo.getColumnsWidthsType());
            }
            if (this.frameCombo != null) {
                if (tableInfo.getFrame() != null) {
                    this.frameCombo.setSelectedItem(tableInfo.getFrame());
                } else {
                    this.frameCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.rowsepCombo != null) {
                if (tableInfo.getRowsep() != null) {
                    this.rowsepCombo.setSelectedItem(tableInfo.getRowsep());
                } else {
                    this.rowsepCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.colsepCombo != null) {
                if (tableInfo.getColsep() != null) {
                    this.colsepCombo.setSelectedItem(tableInfo.getColsep());
                } else {
                    this.colsepCombo.setSelectedItem("<unspecified>");
                }
            }
        } else {
            if (this.titleCheckbox != null) {
                this.titleCheckbox.setSelected(true);
            }
            if (this.showModelChooser) {
                if (this.isCalsTable) {
                    this.calsModelRadio.setSelected(true);
                } else {
                    this.otherModelRadio.setSelected(true);
                }
            }
            if (this.predefinedColumnsCount <= 0 || this.predefinedRowsCount <= 0) {
                this.rowsSpinner.setValue(3);
                this.columnsSpinner.setValue(2);
            }
            this.headerCheckbox.setSelected(true);
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(false);
            }
        }
        if (this.titleCheckbox != null) {
            this.titleTextField.requestFocus();
        }
    }
}

