/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SACustomTableColumnInsertionDialog
extends OKCancelDialog {
    private JSpinner columnsSpinner;
    private JRadioButton beforeRadioButton;
    private JRadioButton afterRadioButton;

    public SACustomTableColumnInsertionDialog(JFrame jFrame, AuthorResourceBundle authorResourceBundle) {
        super(jFrame, authorResourceBundle.getMessage("insert.table.columns.custom"), true);
        this.setOkButtonText(authorResourceBundle.getMessage("Insert"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(authorResourceBundle.getMessage("Number_of_columns") + ":");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.columnsSpinner = new JSpinner();
        this.columnsSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.columnsSpinner.setPreferredSize(new Dimension(110, (int)this.columnsSpinner.getPreferredSize().getHeight()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.columnsSpinner, gridBagConstraints);
        JLabel jLabel2 = new JLabel(authorResourceBundle.getMessage("Position") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.beforeRadioButton = new JRadioButton(authorResourceBundle.getMessage("Before"));
        this.beforeRadioButton.setSelected(false);
        this.afterRadioButton = new JRadioButton(authorResourceBundle.getMessage("After"));
        this.afterRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.beforeRadioButton);
        buttonGroup.add(this.afterRadioButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.beforeRadioButton);
        jPanel2.add(this.afterRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    public TableColumnsInfo showDialog(TableColumnsInfo tableColumnsInfo) {
        this.initialize(tableColumnsInfo);
        super.setVisible(true);
        TableColumnsInfo tableColumnsInfo2 = null;
        if (this.getResult() == 1) {
            int n2 = (Integer)this.columnsSpinner.getValue();
            boolean bl = this.afterRadioButton.isSelected();
            tableColumnsInfo2 = new TableColumnsInfo(n2, bl);
        }
        return tableColumnsInfo2;
    }

    private void initialize(TableColumnsInfo tableColumnsInfo) {
        if (tableColumnsInfo == null) {
            tableColumnsInfo = new TableColumnsInfo();
        }
        this.columnsSpinner.setValue(tableColumnsInfo.getColumnsNumber());
        this.beforeRadioButton.setSelected(!tableColumnsInfo.isInsertAfter());
        this.afterRadioButton.setSelected(tableColumnsInfo.isInsertAfter());
    }
}

