/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableColumnInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SATableColumnInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertColumnOperationBase
extends AbstractTableOperation {
    public static final String POSITION_ARGUMENT = "insertPosition";
    private static final String CUSTOM_COLUMN_INSERTION_ARGUMENT = "customColumnInsertion";
    public static final ArgumentDescriptor INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("customColumnInsertion", 3, "A boolean specifying if the custom column insertion has been requested or not. A custom insertion allows the user to choose the number of columns to be inserted and the position of insertion (before or after the current column).", new String[]{"true", "false"}, "false");
    public static final ArgumentDescriptor POSITION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the current column determined by the XPath expression.\nCan be: Before, After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"After", "Before"}, "After");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAMESPACE_ARGUMENT_DESCRIPTOR, POSITION_ARGUMENT_DESCRIPTOR, INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR};

    public InsertColumnOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        String string = null;
        Object object = argumentsMap.getArgumentValue("namespace");
        if (object instanceof String) {
            string = (String)object;
        }
        String string2 = "After";
        Object object2 = argumentsMap.getArgumentValue(POSITION_ARGUMENT);
        if (object2 instanceof String) {
            string2 = (String)object2;
        }
        boolean bl = false;
        Object object3 = argumentsMap.getArgumentValue(CUSTOM_COLUMN_INSERTION_ARGUMENT);
        bl = "true".equals(object3);
        this.performInsertColumns(authorAccess, string, string2, bl, null, null, false, null, null);
    }

    public void performInsertColumn(AuthorAccess authorAccess, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, TableColumnSpecificationInformation tableColumnSpecificationInformation, boolean bl, InsertRowOperationBase insertRowOperationBase, InsertTableOperationBase insertTableOperationBase) throws AuthorOperationException {
        this.performInsertColumns(authorAccess, string, "After", false, authorDocumentFragmentArray, tableColumnSpecificationInformation, bl, insertRowOperationBase, insertTableOperationBase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performInsertColumns(AuthorAccess authorAccess, String string, String string2, boolean bl, AuthorDocumentFragment[] authorDocumentFragmentArray, TableColumnSpecificationInformation tableColumnSpecificationInformation, boolean bl2, InsertRowOperationBase insertRowOperationBase, InsertTableOperationBase insertTableOperationBase) throws AuthorOperationException {
        try {
            AuthorElement authorElement;
            int n2 = -1;
            int n3 = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n3);
            int n4 = 1;
            TableColumnsInfo tableColumnsInfo = null;
            if (bl) {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.STANDALONE.equals((Object)platform)) {
                    tableColumnsInfo = SATableColumnInsertionCustomizerInvoker.getInstance().customizeTableColumnInsertion(authorAccess);
                } else if (Platform.ECLIPSE.equals((Object)platform)) {
                    tableColumnsInfo = ECTableColumnInsertionCustomizerInvoker.getInstance().customizeTableColumnInsertion(authorAccess);
                }
                if (tableColumnsInfo == null) throw new AuthorOperationStoppedByUserException("Cancelled by user");
                n4 = tableColumnsInfo.getColumnsNumber();
                string2 = !tableColumnsInfo.isInsertAfter() ? "Before" : "After";
            }
            if ((authorElement = this.getElementAncestor(authorNode, 2)) != null) {
                AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
                if (this.isTableElement(authorNode, 1)) {
                    n2 = this.findColumnIndex(authorAccess, n3 + 1);
                    if (n2 == -1) {
                        n2 = this.findColumnIndex(authorAccess, n3 - 1);
                        n2 = n2 != -1 ? ++n2 : 0;
                    }
                } else {
                    AuthorElement authorElement2 = this.getElementAncestor(authorNode, 0);
                    if (authorElement2 == null) throw new AuthorOperationException("Cannot find a cell in the table at the current caret position.");
                    int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement2);
                    if (nArray == null) throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + authorElement2);
                    Integer n5 = authorTableCellSpanProvider.getColSpan(authorElement2);
                    n2 = nArray[1] + ("After".equals(string2) ? (n5 != null ? n5 : 1) : 1);
                }
                if ("Before".equals(string2) && n2 > 0) {
                    --n2;
                }
                int n6 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
                if (authorAccess.getTableAccess().getTableNumberOfColumns(authorElement) == 0 || authorTableCellSpanProvider.hasColumnSpecifications(authorElement)) {
                    this.updateColumnCellsSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, tableColumnSpecificationInformation, string, n4);
                }
                this.insertNewColumnsCells(authorAccess, authorTableCellSpanProvider, authorElement, n2, string, authorDocumentFragmentArray, bl2, insertRowOperationBase, n4);
                this.tableHelper.updateTableColumnNumber(authorAccess, authorElement, n6 + n4);
                return;
            } else {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.WEBAPP.equals((Object)platform)) {
                    AuthorOperationException authorOperationException = new AuthorOperationException("A column can only be inserted in an existing table.");
                    authorOperationException.setOperationRejectedOnPurpose(true);
                    throw authorOperationException;
                }
                insertTableOperationBase.insertTable(authorDocumentFragmentArray, bl2, authorAccess, string, this.tableHelper, null);
            }
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, TableColumnSpecificationInformation tableColumnSpecificationInformation, String string, int n3) throws AuthorOperationException {
        int n4 = authorAccess.getTableAccess().getTableRowCount(authorElement);
        if (n2 > 0 && n4 != -1) {
            AuthorElement authorElement2 = null;
            for (int i2 = n4 - 1; i2 >= 0; --i2) {
                AuthorElement authorElement3 = authorAccess.getTableAccess().getTableCellAt(i2, n2, authorElement);
                if (authorElement2 == authorElement3) continue;
                authorElement2 = authorElement3;
                if (authorElement3 == null) continue;
                int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement3);
                int n5 = nArray[0];
                int n6 = nArray[1];
                if (n5 >= n2 || n2 > n6) continue;
                this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement3, n5 + 1, n6 + 1 + n3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertNewColumnsCells(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, InsertRowOperationBase insertRowOperationBase, int n3) throws AuthorOperationException {
        boolean bl2 = false;
        int n4 = authorAccess.getTableAccess().getTableRowCount(authorElement);
        if (n4 != -1) {
            Object object;
            Object object2;
            int n6;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n6 = 0; n6 < n4; ++n6) {
                int n7;
                if (n2 > 0) {
                    AuthorElement authorElement2 = authorAccess.getTableAccess().getTableCellAt(n6, n2, authorElement);
                    if (authorElement2 != null) {
                        object2 = authorAccess.getTableAccess().getTableColSpanIndices(authorElement2);
                        object = object2[0];
                        String n5 = object2[1];
                        if (object < n2 && n2 <= n5) {
                            if (bl2) continue;
                            bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n6);
                            continue;
                        }
                    }
                    if ((authorElement2 = authorAccess.getTableAccess().getTableCellAt(n6, n2 - 1, authorElement)) == null) {
                        if (bl2) continue;
                        bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n6);
                        continue;
                    }
                }
                if ((n7 = this.findCellInsertionOffset(authorAccess, authorElement, n6, n2)) != -1) {
                    arrayList2.add(n7);
                    object2 = this.getCellElementName(authorAccess.getTableAccess().getTableRow(n6, authorElement), n2);
                    arrayList.add((String[])object2);
                    if (object2 != null) continue;
                    throw new AuthorOperationException("The table model does not accept new columns at the given position.");
                }
                if (bl2) continue;
                bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n6);
            }
            if (authorDocumentFragmentArray == null) {
                String string2 = this.getDefaultContentForEmptyCells();
                if (string2 != null) {
                    AuthorDocumentFragment[] authorDocumentFragmentArray2 = new AuthorDocumentFragment[arrayList2.size()];
                    for (int i2 = arrayList2.size() - 1; i2 >= 0; --i2) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i3 = 0; i3 < n3; ++i3) {
                            stringBuilder.append("<").append((String)arrayList.get(i2));
                            if (string != null) {
                                stringBuilder.append(" xmlns=\"").append(string).append("\"");
                            }
                            stringBuilder.append(">");
                            stringBuilder.append(string2);
                            stringBuilder.append("</").append((String)arrayList.get(i2)).append(">");
                        }
                        authorDocumentFragmentArray2[i2] = authorAccess.getDocumentController().createNewDocumentFragmentInContext(stringBuilder.toString(), (Integer)arrayList2.get(i2));
                        authorDocumentFragmentArray = authorDocumentFragmentArray2;
                    }
                    int[] nArray = new int[arrayList2.size()];
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        nArray[i3] = (Integer)arrayList2.get(i3);
                    }
                    authorAccess.getDocumentController().insertMultipleFragments(authorElement, authorDocumentFragmentArray, nArray);
                } else {
                    void var18_32;
                    int n8 = 0;
                    object2 = new int[arrayList2.size() * n3];
                    String[] stringArray = new String[arrayList2.size() * n3];
                    boolean bl3 = false;
                    while (var18_32 < arrayList2.size()) {
                        int n5 = (Integer)arrayList2.get((int)var18_32);
                        String string3 = (String)arrayList.get((int)var18_32);
                        for (int i4 = 0; i4 < n3; ++i4) {
                            object2[n8] = (String)n5;
                            stringArray[n8] = string3;
                            ++n8;
                        }
                        ++var18_32;
                    }
                    authorAccess.getDocumentController().insertMultipleElements(authorElement, stringArray, (int[])object2, string);
                }
                authorAccess.getEditorAccess().setCaretPosition((Integer)arrayList2.get(0) + 1);
            } else {
                int n7;
                boolean bl4;
                int n8;
                n6 = arrayList2.size();
                int[] nArray = new int[n6];
                object2 = new String[n6];
                for (object = 0; object < n6; ++object) {
                    nArray[object] = (Integer)arrayList2.get((int)object);
                    object2[object] = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, (String)arrayList.get((int)object), object, string, this.tableHelper, new String[0]);
                }
                AuthorDocumentFragment[] authorDocumentFragmentArray3 = authorAccess.getDocumentController().createNewDocumentFragmentsInContext((String[])object2, nArray);
                boolean bl5 = false;
                if (insertRowOperationBase != null && n6 <= authorDocumentFragmentArray.length - 1) {
                    n8 = authorAccess.getTableAccess().getTableRowCount(authorElement);
                    AuthorElement authorElement2 = authorAccess.getTableAccess().getTableRow(n8 - 1, authorElement);
                    if (authorElement2 == null) {
                        AuthorOperationException authorOperationException = new AuthorOperationException("The operation failed because the last table row could not be determined.");
                        authorOperationException.setOperationRejectedOnPurpose(true);
                        throw authorOperationException;
                    }
                    int n9 = authorElement2.getEndOffset() + 1;
                    bl4 = true;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = insertRowOperationBase.getCellElementName(authorElement, n2);
                    for (n7 = n6; n7 < authorDocumentFragmentArray.length; ++n7) {
                        try {
                            String string5 = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, string4, n7, string, this.tableHelper, new String[0]);
                            String string6 = insertRowOperationBase.getRowXMLFragment(authorAccess, authorElement, string, string5, n2);
                            if (string6 == null) {
                                throw new AuthorOperationException("The column cannot be inserted.");
                            }
                            stringBuilder.append(string6);
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            throw new AuthorOperationException("The column cannot be inserted.");
                        }
                    }
                    authorDocumentFragmentArray3 = Arrays.copyOf(authorDocumentFragmentArray3, authorDocumentFragmentArray3.length + 1);
                    authorDocumentFragmentArray3[authorDocumentFragmentArray3.length - 1] = authorAccess.getDocumentController().createNewDocumentFragmentInContext(stringBuilder.toString(), n9);
                    nArray = Arrays.copyOf(nArray, nArray.length + 1);
                    nArray[nArray.length - 1] = n9;
                }
                if ((n8 = authorAccess.getDocumentController().insertMultipleFragments(authorElement, authorDocumentFragmentArray3, nArray)) != 0) {
                    int n10 = 0;
                    authorAccess.getEditorAccess().setCaretPosition(nArray[0] + 1);
                    ArrayList<ContentInterval> arrayList3 = new ArrayList<ContentInterval>();
                    for (int i5 = 0; i5 < nArray.length; ++i5) {
                        int n11 = nArray[i5];
                        n7 = authorDocumentFragmentArray3[i5].getLength();
                        arrayList3.add(new ContentInterval(n11 + n10, n11 + n10 + n7));
                        n10 += n7;
                    }
                    authorAccess.getEditorAccess().getAuthorSelectionModel().setSelectionIntervals(arrayList3, false);
                    if (!bl4) {
                        authorAccess.getEditorAccess().getAuthorSelectionModel().setSelectionInterpretationMode(SelectionInterpretationMode.TABLE_COLUMN);
                    }
                }
            }
        } else {
            throw new AuthorOperationException("Could not obtain the number of rows. Table is invalid.");
        }
    }

    private boolean checkForCompatibility(AuthorAccess authorAccess, AuthorDocumentFragment[] authorDocumentFragmentArray, int n2) throws AuthorOperationException {
        boolean bl = false;
        if (authorDocumentFragmentArray != null && n2 < authorDocumentFragmentArray.length) {
            int n3 = authorAccess.getWorkspaceAccess().showConfirmDialog(authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("handle.paste.column.warning"), new String[]{authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("cancel")}, new int[]{1, 0});
            if (n3 != 1) {
                throw new AuthorOperationStoppedByUserException("Cancelled by user");
            }
            bl = true;
        }
        return bl;
    }

    private int findColumnIndex(AuthorAccess authorAccess, int n2) throws BadLocationException, AuthorOperationException {
        int n3 = -1;
        AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
        if (this.isTableElement(authorNode, 0)) {
            int[] nArray = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)authorNode);
            if (nArray != null) {
                n3 = nArray[1];
            } else {
                throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + authorNode);
            }
        }
        return n3;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Insert a table column.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected String getDefaultContentForEmptyCells() {
        return null;
    }

    protected static ArgumentDescriptor[] removeMultipleInsertionDescriptor(ArgumentDescriptor[] argumentDescriptorArray) {
        ArrayList arrayList = new ArrayList(argumentDescriptorArray.length);
        Collections.addAll(arrayList, argumentDescriptorArray);
        arrayList.remove(INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR);
        return arrayList.toArray(new ArgumentDescriptor[0]);
    }
}

