/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableRowsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECCustomTableRowInsertionDialog
extends Dialog {
    private TableRowsInfo tableRowsInfo;
    private int rows;
    private boolean insertBelow;
    Spinner rowsSpinner;
    Button aboveRadioButton;
    Button belowRadioButton;
    AuthorResourceBundle authorResourceBundle;

    public ECCustomTableRowInsertionDialog(Shell shell, AuthorResourceBundle authorResourceBundle) {
        super(shell);
        this.authorResourceBundle = authorResourceBundle;
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.authorResourceBundle.getMessage("insert.table.rows.custom"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(this.authorResourceBundle.getMessage("Number_of_rows") + ":");
        this.rowsSpinner = new Spinner(composite2, 2048);
        this.rowsSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.rowsSpinner.setLayoutData((Object)gridData);
        this.rowsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ECCustomTableRowInsertionDialog.this.rows = ECCustomTableRowInsertionDialog.this.rowsSpinner.getSelection();
            }
        });
        this.rows = new TableRowsInfo().getRowsNumber();
        Label label2 = new Label(composite2, 0);
        label2.setText(this.authorResourceBundle.getMessage("Position") + ":");
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new RowLayout());
        this.aboveRadioButton = new Button(composite3, 16);
        this.aboveRadioButton.setText(this.authorResourceBundle.getMessage("Above"));
        this.aboveRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECCustomTableRowInsertionDialog.this.insertBelow = false;
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ECCustomTableRowInsertionDialog.this.insertBelow = false;
            }
        });
        this.belowRadioButton = new Button(composite3, 16);
        this.belowRadioButton.setText(this.authorResourceBundle.getMessage("Below"));
        this.belowRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECCustomTableRowInsertionDialog.this.insertBelow = true;
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ECCustomTableRowInsertionDialog.this.insertBelow = true;
            }
        });
        this.initialize();
        return composite2;
    }

    public TableRowsInfo showDialog(TableRowsInfo tableRowsInfo) {
        this.tableRowsInfo = tableRowsInfo;
        if (0 == this.open()) {
            return new TableRowsInfo(this.rows, this.insertBelow);
        }
        return null;
    }

    private void initialize() {
        if (this.tableRowsInfo != null) {
            this.rows = this.tableRowsInfo.getRowsNumber();
            this.rowsSpinner.setSelection(this.rows);
            this.insertBelow = this.tableRowsInfo.isInsertBelow();
            this.aboveRadioButton.setSelection(!this.insertBelow);
            this.belowRadioButton.setSelection(this.insertBelow);
        } else {
            TableRowsInfo tableRowsInfo = new TableRowsInfo();
            this.rows = tableRowsInfo.getRowsNumber();
            this.rowsSpinner.setSelection(this.rows);
            this.insertBelow = tableRowsInfo.isInsertBelow();
            this.aboveRadioButton.setSelection(!this.insertBelow);
            this.belowRadioButton.setSelection(this.insertBelow);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setText(this.authorResourceBundle.getMessage("Insert"));
    }
}

