/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.List;
import java.util.TreeSet;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.SortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class TableSortOperation
extends SortOperation {
    public TableSortOperation() {
        super("Selected_rows", "All_rows");
    }

    @Override
    public void canBeSorted(AuthorElement authorElement, int[] nArray) throws AuthorOperationException {
        int n2;
        List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
        if (nArray == null || nArray[1] < 0) {
            nArray = new int[]{0, list.size() - 1};
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n2 = 0; n2 <= nArray[1]; ++n2) {
            AuthorNode authorNode = list.get(n2);
            if (authorNode.getType() != 0) continue;
            List<AuthorNode> list2 = this.getNonIgnoredChildren((AuthorElement)authorNode);
            int n3 = list2.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int[] nArray2;
                AuthorNode authorNode2 = list2.get(i2);
                if (authorNode2.getType() != 0 || (nArray2 = this.authorAccess.getTableAccess().getTableRowSpanIndices((AuthorElement)authorNode2)) == null || nArray2[1] - nArray2[0] <= 0) continue;
                for (int i3 = nArray2[0]; i3 <= nArray2[1]; ++i3) {
                    treeSet.add(i3);
                }
            }
        }
        n2 = this.getRowIndexForTableBody(authorElement);
        for (int i4 = nArray[0]; i4 <= nArray[1] && i4 >= 0 && i4 < list.size(); ++i4) {
            if (!treeSet.contains(i4 + n2)) continue;
            throw new AuthorOperationException("The 'Sort' operation is unavailable for tables with multiple rowspan cells.");
        }
    }

    protected abstract int getRowIndexForTableBody(AuthorNode var1);
}

