/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class TEIListSortOperation
extends SortOperation {
    public TEIListSortOperation() {
        super("Selected_items", "All_items");
    }

    @Override
    public AuthorElement getSortParent(int n2, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode;
        if (authorAccess.getEditorAccess().hasSelection() && (authorNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && authorNode.getType() == 0 && "list".equals(((AuthorElement)authorNode).getLocalName())) {
            return (AuthorElement)authorNode;
        }
        try {
            for (AuthorNode authorNode2 = authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode2 != null && authorNode2.getType() != 2; authorNode2 = authorNode2.getParent()) {
                AuthorElement authorElement;
                if (authorNode2.getType() != 0 || !"list".equals((authorElement = (AuthorElement)authorNode2).getLocalName())) continue;
                return authorElement;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException(badLocationException.getMessage(), badLocationException);
        }
        return null;
    }

    @Override
    public boolean isIgnored(AuthorNode authorNode) {
        return authorNode.getType() == 3 || authorNode.getType() == 5;
    }

    private void checkValidForSorting(AuthorNode authorNode) throws AuthorOperationException {
        if (!(authorNode instanceof AuthorElement) || !"item".equals(((AuthorElement)authorNode).getLocalName())) {
            throw new AuthorOperationException("The 'Sort' operation is unavailable for lists containing elements which are not 'item'.");
        }
    }

    @Override
    public void canBeSorted(AuthorElement authorElement, int[] nArray) throws AuthorOperationException {
        List<AuthorNode> list = this.getNonIgnoredChildren(authorElement);
        if (nArray == null) {
            nArray = new int[]{0, list.size() - 1};
        }
        for (int i2 = nArray[0]; i2 <= nArray[1] && i2 >= 0 && i2 < list.size(); ++i2) {
            this.checkValidForSorting(list.get(i2));
        }
    }

    @Override
    public String[] getSortKeysValues(AuthorNode authorNode, SortCriteriaInformation sortCriteriaInformation) throws AuthorOperationException {
        CriterionInformation[] criterionInformationArray = sortCriteriaInformation.criteriaInfo;
        String[] stringArray = null;
        if (authorNode instanceof AuthorElement && criterionInformationArray.length > 0) {
            stringArray = new String[1];
            AuthorElement authorElement = (AuthorElement)authorNode;
            if ("item".equals(authorElement.getLocalName())) {
                stringArray[0] = this.getTextContentToSort(authorNode);
            }
        }
        return stringArray;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement authorElement) throws AuthorOperationException {
        ArrayList<CriterionInformation> arrayList = new ArrayList<CriterionInformation>();
        int n2 = this.getNonIgnoredChildren(authorElement).size();
        if (n2 > 0) {
            arrayList.add(new CriterionInformation(0, this.authorAccess.getAuthorResourceBundle().getMessage("List_item")));
        }
        return arrayList;
    }
}

