/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class CountWordsOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)CountWordsOperation.class.getName());
    private static final int WORD_STATE = 0;
    private static final int WHITESPACE_STATE = 1;

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        Object object;
        int n2 = 0;
        int n3 = authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            n2 = authorAccess.getEditorAccess().getSelectionStart();
            n3 = authorAccess.getEditorAccess().getSelectionEnd() - 1;
        }
        TextContentIterator textContentIterator = authorAccess.getDocumentController().getTextContentIterator(n2, n3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = true;
        while (textContentIterator.hasNext()) {
            object = textContentIterator.next();
            int n10 = object.getEditableState();
            if (n10 != 2) {
                CharSequence charSequence = object.getText();
                int n11 = charSequence.length();
                int n12 = 0;
                int n13 = 0;
                boolean bl2 = false;
                boolean bl3 = true;
                for (int i2 = 0; i2 < n11; ++i2) {
                    char c2 = charSequence.charAt(i2);
                    if (!Character.isWhitespace(c2)) {
                        if (bl3) {
                            bl3 = false;
                            ++n13;
                        }
                        ++n12;
                        if (i2 != 0) continue;
                        bl2 = true;
                        continue;
                    }
                    if (bl3) continue;
                    bl3 = true;
                }
                if (bl2 && !bl && !this.isWordStart(authorAccess, object.getTextStartOffset())) {
                    --n13;
                }
                if (n10 == 0) {
                    n5 += n12;
                    n4 += n13;
                } else if (n10 == 1) {
                    n9 += n12;
                    n8 += n13;
                } else {
                    n7 += n12;
                    n6 += n13;
                }
            }
            bl = false;
        }
        object = new StringBuilder();
        if (n6 == 0 && n8 == 0) {
            ((StringBuilder)object).append("Words: ");
            ((StringBuilder)object).append(n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append("Characters (no spaces): ");
            ((StringBuilder)object).append(n5);
        } else {
            String string = "     ";
            ((StringBuilder)object).append("Regular content:");
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append("Words: ");
            ((StringBuilder)object).append(n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append("Characters (no spaces): ");
            ((StringBuilder)object).append(n5);
            if (n8 > 0) {
                ((StringBuilder)object).append("\n\n");
                ((StringBuilder)object).append("Filtered content:");
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("Words: ");
                ((StringBuilder)object).append(n8);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("Characters (no spaces): ");
                ((StringBuilder)object).append(n9);
            }
            if (n6 > 0) {
                ((StringBuilder)object).append("\n\n");
                ((StringBuilder)object).append("Read-only content:");
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("Words: ");
                ((StringBuilder)object).append(n6);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("Characters (no spaces): ");
                ((StringBuilder)object).append(n7);
            }
            ((StringBuilder)object).append("\n\n");
            ((StringBuilder)object).append("Total:");
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append("Words: ");
            ((StringBuilder)object).append(n6 + n8 + n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append("Characters (no spaces): ");
            ((StringBuilder)object).append(n7 + n9 + n5);
        }
        authorAccess.getWorkspaceAccess().showInformationMessage(((StringBuilder)object).toString());
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Count words either in the whole document or in the selection.";
    }

    private boolean isWordStart(AuthorAccess authorAccess, int n2) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        boolean bl = false;
        try {
            Segment segment = new Segment();
            --n2;
            while (n2 > 1) {
                authorDocumentController.getChars(n2, 1, segment);
                char c2 = segment.array[segment.offset];
                if (c2 == '\u0000') {
                    OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n2);
                    AuthorNode authorNode = offsetInformation.getNodeForMarkerOffset();
                    Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
                    if (!styles.isInline()) {
                        bl = true;
                        break;
                    }
                } else {
                    bl = Character.isWhitespace(c2);
                    break;
                }
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

