/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class TransformOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)TransformOperation.class.getName());
    public static final String CURRENT_ELEMENT_LOCATION = "currentElementLocation";
    public static final String ACTION_REPLACE = "Replace";
    public static final String ACTION_AT_CARET = "At caret position";
    public static final String ACTION_INSERT_BEFORE = "Before";
    public static final String ACTION_INSERT_AFTER = "After";
    public static final String ACTION_INSERT_AS_FIRST_CHILD = "Inside as first child";
    public static final String ACTION_INSERT_AS_LAST_CHILD = "Inside as last child";
    public static final String CARET_POSITION_PRESERVE = "Preserve";
    public static final String CARET_POSITION_BEFORE = "Before";
    public static final String CARET_POSITION_START = "Start";
    public static final String CARET_POSITION_EDITABLE = "First editable position";
    public static final String CARET_POSITION_END = "End";
    public static final String CARET_POSITION_AFTER = "After";
    private static final String ARGUMENT_XPATH_SOURCE = "sourceLocation";
    private static final String ARGUMENT_XPATH_TARGET = "targetLocation";
    protected String ARGUMENT_SCRIPT = "script";
    private static final String ARGUMENT_ACTION = "action";
    private static final String ARGUMENT_CARET_POSITION = "caretPosition";
    private static final String ARGUMENT_EXPAND_EDITOR_VARIABLES = "expandEditorVariables";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[6];

    public TransformOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_SOURCE, 2, "An XPath expression indicating the element that the script will be applied on.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_TARGET, 2, "An XPath expression indicating the insert location for the result of the transformation.\nNote: If it is not defined then the insert location will be at the caret.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(this.ARGUMENT_SCRIPT, 4, "The script. The base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ACTION, 3, "The insert action relative to the node determined by the target XPath expression.\nIt can be: Replace, At caret position, Before, After, Inside as first child or Inside as last child.\n", new String[]{ACTION_REPLACE, ACTION_AT_CARET, "Before", "After", ACTION_INSERT_AS_FIRST_CHILD, ACTION_INSERT_AS_LAST_CHILD}, ACTION_REPLACE);
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_CARET_POSITION, 3, "The position of the caret after the action is executed.\nIt can be: Preserve, Before, Start, First editable position, End or After.\n", new String[]{CARET_POSITION_PRESERVE, "Before", CARET_POSITION_START, CARET_POSITION_EDITABLE, CARET_POSITION_END, "After"}, CARET_POSITION_EDITABLE);
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_EDITOR_VARIABLES, 3, "Parameter controlling the expansion of editor variables returned by the script processing.\nExpansion is enabled by default.", new String[]{"true", "false"}, "true");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        int n2;
        int n3;
        Object object;
        int n4;
        void var16_31;
        void var13_20;
        String string;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        AuthorNode authorNode;
        AuthorElement authorElement;
        Object object5 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_SOURCE);
        Object object6 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_TARGET);
        Object object7 = argumentsMap.getArgumentValue(this.ARGUMENT_SCRIPT);
        Object object8 = argumentsMap.getArgumentValue(ARGUMENT_ACTION);
        Object object9 = argumentsMap.getArgumentValue(ARGUMENT_CARET_POSITION);
        if (!(object7 instanceof String)) {
            throw new IllegalArgumentException("The argument \"script\" was not defined as a string object!");
        }
        String string3 = (String)object7;
        AuthorNode authorNode2 = null;
        AuthorElement authorElement2 = null;
        AuthorNode authorNode3 = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("Cannot identify the current node", badLocationException);
        }
        authorNode2 = authorNode3;
        for (authorNode3 = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode3 != null && !(authorNode3 instanceof AuthorElement); authorNode3 = authorNode3.getParent()) {
        }
        authorElement2 = authorNode3 instanceof AuthorElement ? (AuthorElement)authorNode3 : authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (object5 instanceof String && !"".equals(object5)) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object5, true, true, false);
            if (authorNodeArray.length <= 0 || !(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The source XPath location does not identify an element: " + object5);
            authorElement = (AuthorElement)authorNodeArray[0];
        } else {
            authorElement = authorElement2;
        }
        String string4 = "";
        AuthorElement authorElement3 = authorElement2;
        if (authorElement3.isDescendentOf(authorElement)) {
            void var13_16;
            void var14_22;
            while (var14_22 != authorElement) {
                authorNode = (AuthorElement)var14_22.getParent();
                List<AuthorNode> list = authorNode.getContentNodes();
                int n5 = 1;
                for (int i2 = 0; i2 < list.size() && (object4 = list.get(i2)) != var14_22; ++i2) {
                    boolean bl = false;
                    object3 = authorAccess.getReviewController().getChangeHighlights(object4.getStartOffset(), object4.getEndOffset());
                    if (object3 != null) {
                        for (int i3 = 0; i3 < ((AuthorPersistentHighlight[])object3).length; ++i3) {
                            if (object3[i3].getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE || object3[i3].getStartOffset() > object4.getStartOffset() || object4.getEndOffset() > object3[i3].getEndOffset()) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue;
                    ++n5;
                }
                String string5 = "/*[" + n5 + "]" + (String)var13_16;
                AuthorNode authorNode4 = authorNode;
            }
            String string6 = "/*[1]" + (String)var13_16;
        } else {
            String string7 = "/..";
        }
        if (object6 instanceof String && !"".equals(object6)) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object6, true, true, false);
            if (authorNodeArray.length <= 0) throw new AuthorOperationException("The target XPath location does not identify a node: " + object6);
            authorNode = authorNodeArray[0];
        } else {
            authorNode = authorNode2;
        }
        Object var16_28 = null;
        try {
            object2 = authorAccess.getDocumentController().createDocumentFragment(authorElement, true);
            string2 = authorAccess.getDocumentController().serializeFragmentToXML((AuthorDocumentFragment)object2);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
            throw new AuthorOperationException("Could not serialize source", badLocationException);
        }
        if (string2 == null) {
            throw new AuthorOperationException("Cannot serialize the source element: " + object5);
        }
        object2 = authorAccess.getDocumentController().getDoctype();
        if (object2 != null && (string = ((AuthorDocumentType)object2).serializeDoctype()) != null) {
            String string8 = string + string2;
        }
        InputSource inputSource = new InputSource(new StringReader(string3));
        object4 = authorAccess.getUtilAccess().expandEditorVariables("${framework}", authorAccess.getEditorAccess().getEditorLocation());
        if (object4 != null && ((String)object4).contains("${framework}")) {
            object4 = authorAccess.getEditorAccess().getEditorLocation().toString();
        }
        inputSource.setSystemId((String)object4);
        SAXSource sAXSource = new SAXSource(inputSource);
        object3 = null;
        try {
            object3 = this.createTransformer(authorAccess, sAXSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            logger.debug((Object)transformerConfigurationException, (Throwable)transformerConfigurationException);
            throw new AuthorOperationException("Cannot create a transformer from the provided script:\n" + string3 + "\nReason:" + transformerConfigurationException.getMessage());
        }
        if (object3 == null) return;
        ((Transformer)object3).setParameter(CURRENT_ELEMENT_LOCATION, var13_20);
        StringWriter stringWriter = new StringWriter();
        InputSource inputSource2 = new InputSource(new StringReader((String)var16_31));
        inputSource2.setSystemId(authorElement.getXMLBaseURL().toString());
        SAXSource sAXSource2 = new SAXSource(inputSource2);
        try {
            ((Transformer)object3).transform(sAXSource2, new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            throw new AuthorOperationException("The script cannot be executed: " + transformerException.getMessageAndLocation());
        }
        boolean bl = argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES) == null || "true".equals(argumentsMap.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES));
        boolean bl2 = false;
        String string9 = stringWriter.toString();
        if (string9.startsWith("<?xml ") && (n4 = string9.indexOf("?>")) != -1) {
            string9 = string9.substring(n4 + 2);
        }
        if (bl) {
            n4 = string9.indexOf("${selection}");
            if (n4 != -1) {
                String string10 = "";
                try {
                    if (authorAccess.getEditorAccess().hasSelection()) {
                        object = authorAccess.getDocumentController().createDocumentFragment(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
                        string10 = authorAccess.getDocumentController().serializeFragmentToXML((AuthorDocumentFragment)object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
                string9 = string9.substring(0, n4) + string10 + string9.substring(n4 + "${selection}".length(), string9.length());
            }
            if ((n3 = (string9 = authorAccess.getUtilAccess().expandEditorVariables(string9, authorAccess.getEditorAccess().getEditorLocation())).indexOf("${caret}")) != -1) {
                string9 = string9.substring(0, n3) + "<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>" + string9.substring(n3 + "${caret}".length(), string9.length());
                bl2 = true;
            }
        }
        n4 = authorAccess.getEditorAccess().getCaretOffset();
        n3 = authorAccess.getEditorAccess().getCaretOffset();
        if (ACTION_REPLACE.equals(object8)) {
            n3 = authorNode.getStartOffset();
        } else if (!ACTION_AT_CARET.equals(object8)) {
            object = object6 != null && ((String)object6).trim().length() > 0 ? (String)object6 : ".";
            n3 = authorAccess.getDocumentController().getXPathLocationOffset((String)object, (String)object8);
        }
        object = null;
        try {
            object = authorAccess.getDocumentController().createPositionInContent(n3);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        if (ACTION_REPLACE.equals(object8)) {
            if (authorNode.getParent().getType() == 2) {
                AuthorDocumentFragment authorDocumentFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext(string9, authorNode.getStartOffset());
                authorAccess.getDocumentController().replaceRoot(authorDocumentFragment);
            } else {
                authorAccess.getDocumentController().insertXMLFragment(string9, authorNode, "Before");
                authorAccess.getDocumentController().deleteNode(authorNode);
            }
        } else if (ACTION_AT_CARET.equals(object8)) {
            authorAccess.getDocumentController().insertXMLFragment(string9, authorAccess.getEditorAccess().getCaretOffset());
        } else {
            authorAccess.getDocumentController().insertXMLFragment(string9, authorNode, (String)object8);
        }
        int n6 = n3 + 1;
        int n7 = n2 = object != null ? object.getOffset() - 1 : n6;
        if (n4 < n6) {
            n4 = n6;
        }
        if (n4 > n2) {
            n4 = n2;
        }
        if (bl2) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n3);
            return;
        }
        if ("Before".equals(object9)) {
            authorAccess.getEditorAccess().setCaretPosition(n6 - 1);
            return;
        }
        if (CARET_POSITION_START.equals(object9)) {
            authorAccess.getEditorAccess().setCaretPosition(n6);
            return;
        }
        if (CARET_POSITION_PRESERVE.equals(object9)) {
            authorAccess.getEditorAccess().setCaretPosition(n4);
            return;
        }
        if (CARET_POSITION_END.equals(object9)) {
            authorAccess.getEditorAccess().setCaretPosition(n2);
            return;
        }
        if ("After".equals(object9)) {
            authorAccess.getEditorAccess().setCaretPosition(n2 + 1);
            return;
        }
        try {
            authorAccess.getEditorAccess().goToNextEditablePosition(n6 - 1, n2);
            return;
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
    }

    protected abstract Transformer createTransformer(AuthorAccess var1, Source var2) throws TransformerConfigurationException;

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Run a script on a source element and then replace or insert the result in a target node.";
    }
}

