/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class MoveElementOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)MoveElementOperation.class.getName());
    private static final String ARGUMENT_SOURCE_LOCATION = "sourceLocation";
    private static final String ARGUMENT_DELETE_LOCATION = "deleteLocation";
    private static final String ARGUMENT_SURROUND_FRAGMENT_LOCATION = "surroundFragment";
    private static final String ARGUMENT_TARGET_LOCATION = "targetLocation";
    private static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    private static final String ARGUMENT_MOVE_ONLY_CONTENT = "moveOnlySourceContentNodes";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[6];

    public MoveElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SOURCE_LOCATION, 2, "An XPath expression that identifies the node to be moved. If missing, the node at caret will be moved.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_MOVE_ONLY_CONTENT, 3, "Controls whether the source element is moved entirely or just its content (the content of a node consists in text, other nodes or both). If true, the copied fragment consists in just the content of the node identified by the argument 'sourceLocation'. If false, the entire node will be copied.", new String[]{"true", "false"}, "false");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_DELETE_LOCATION, 2, "An XPath expression that identifies the node to be removed. Optional. If missing, the node identified by 'sourceLocation' as being moved will be removed.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SURROUND_FRAGMENT_LOCATION, 1, "A string representation of an XML fragment. The moved node will be wrapped in this string before moving it in the destination.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_TARGET_LOCATION, 2, "An XPath expression that identifies the location where the node must be moved to.");
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RELATIVE_LOCATION, 3, "The insert position relative to the node determined by the \"targetLocation\" XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
    }

    @Override
    public String getDescription() {
        return "Moves an element to a different location. The element to move as well as the destination are provided through XPath expressions.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        block25: {
            String string = (String)argumentsMap.getArgumentValue(ARGUMENT_SOURCE_LOCATION);
            AuthorNode authorNode = null;
            if (string != null && string.trim().length() > 0) {
                authorNode = this.executeLocationXPath(authorAccess, string);
            } else {
                int n2 = authorAccess.getEditorAccess().getCaretOffset();
                try {
                    authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("To move " + authorNode));
            }
            if (authorNode != null) {
                String string2;
                AuthorNode authorNode2 = authorNode;
                String string3 = (String)argumentsMap.getArgumentValue(ARGUMENT_DELETE_LOCATION);
                if (string3 != null) {
                    authorNode2 = this.executeLocationXPath(authorAccess, string3);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("To delete " + authorNode2));
                }
                if ((string2 = (String)argumentsMap.getArgumentValue(ARGUMENT_TARGET_LOCATION)) != null) {
                    String string4 = (String)argumentsMap.getArgumentValue(ARGUMENT_RELATIVE_LOCATION);
                    AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                    try {
                        authorDocumentController.beginCompoundEdit();
                        AuthorDocumentFragment authorDocumentFragment = null;
                        String string5 = (String)argumentsMap.getArgumentValue(ARGUMENT_MOVE_ONLY_CONTENT);
                        if (string5 == null) {
                            string5 = "false";
                        }
                        if ("true".equals(string5)) {
                            if (authorNode.getStartOffset() + 1 != authorNode.getEndOffset()) {
                                authorDocumentFragment = authorDocumentController.createDocumentFragment(authorNode.getStartOffset() + 1, authorNode.getEndOffset() - 1);
                            }
                        } else {
                            authorDocumentFragment = authorDocumentController.createDocumentFragment(authorNode, true);
                        }
                        int n3 = authorDocumentController.getXPathLocationOffset(string2, string4);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Insert location for fragment: " + n3));
                        }
                        if (n3 != -1) {
                            if (authorNode2.getStartOffset() < n3 && n3 <= authorNode2.getEndOffset()) {
                                throw new AuthorOperationException("Trying to move inside the node that will be removed. Node to remove: " + authorNode2 + ". Computed insertion offset " + n3);
                            }
                            String string6 = (String)argumentsMap.getArgumentValue(ARGUMENT_SURROUND_FRAGMENT_LOCATION);
                            if (string6 != null) {
                                AuthorDocumentFragment authorDocumentFragment2 = authorDocumentController.createNewDocumentFragmentInContext(string6, n3);
                                authorDocumentController.insertFragment(n3, authorDocumentFragment2);
                                AuthorNode authorNode3 = AuthorNodeUtil.getFirstLeaf(authorDocumentFragment2);
                                if (authorNode3 != null) {
                                    n3 += authorNode3.getStartOffset() + 1;
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Insert location for moved: " + n3));
                                }
                            }
                            if (authorDocumentFragment != null) {
                                authorDocumentController.insertFragment(n3, authorDocumentFragment);
                            }
                            authorDocumentController.deleteNode(authorNode2);
                            break block25;
                        }
                        throw new AuthorOperationException("The XPath expression: " + string2 + " - doesn't identify any node");
                    }
                    catch (BadLocationException badLocationException) {
                        throw new AuthorOperationException("Unable to move the element because of: ", badLocationException);
                    }
                    finally {
                        authorDocumentController.endCompoundEdit();
                    }
                }
                throw new AuthorOperationException("The argument 'targetLocation' was not specified.");
            }
        }
    }

    private AuthorNode executeLocationXPath(AuthorAccess authorAccess, String string) throws AuthorOperationException {
        AuthorNode authorNode = null;
        AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath(string, true, true, true);
        if (authorNodeArray.length > 0) {
            if (authorNodeArray.length > 1) {
                logger.warn((Object)("More than one nodes identified by: " + string + ". Only the first node will be processed"));
            }
        } else {
            throw new AuthorOperationException("The XPath expression: " + string + " - doesn't identify any node");
        }
        authorNode = authorNodeArray[0];
        return authorNode;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

