/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertFragmentOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)InsertFragmentOperation.class.getName());
    public static final String ARGUMENT_FRAGMENT = "fragment";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_FRAGMENT = new ArgumentDescriptor("fragment", 1, "The fragment to be inserted");
    public static final String ARGUMENT_XPATH_LOCATION = "insertLocation";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_XPATH_LOCATION = new ArgumentDescriptor("insertLocation", 2, "An XPath expression indicating the insert location for the fragment.\nNote: If it is not defined then the insert location will be at the caret.");
    public static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
    public static final String ARGUMENT_GO_TO_NEXT_EDITABLE_POSITION = "goToNextEditablePosition";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION = new ArgumentDescriptor("goToNextEditablePosition", 3, "After inserting the fragment, the first editable position is detected and the caret is placed at that location. It handles any in-place editors used to edit attributes. It will be ignored if the fragment specifies a caret position using the caret editor variable.", new String[]{"true", "false"}, "true");
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{ARGUMENT_DESCRIPTOR_FRAGMENT, ARGUMENT_DESCRIPTOR_XPATH_LOCATION, ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION, SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_FRAGMENT);
        Object object2 = argumentsMap.getArgumentValue(ARGUMENT_XPATH_LOCATION);
        Object object3 = argumentsMap.getArgumentValue(ARGUMENT_RELATIVE_LOCATION);
        Object object4 = argumentsMap.getArgumentValue(ARGUMENT_GO_TO_NEXT_EDITABLE_POSITION);
        if (object4 == null) {
            object4 = "true";
        }
        boolean bl = "true".equals(object4);
        Object object5 = argumentsMap.getArgumentValue("schemaAware");
        this.doOperationInternal(authorAccess, object, object2, object3, bl, object5);
    }

    protected void doOperationInternal(AuthorAccess authorAccess, Object object, Object object2, Object object3, boolean bl, Object object4) throws AuthorOperationException {
        if (object instanceof String) {
            String string = (String)object;
            boolean bl2 = MoveCaretUtil.hasImposedEditorVariableCaretOffset(string);
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            if ("false".equals(object4)) {
                if ((bl2 || bl) && object2 != null && ((String)object2).trim().length() > 0) {
                    n2 = authorAccess.getDocumentController().getXPathLocationOffset((String)object2, (String)object3);
                }
                authorAccess.getDocumentController().insertXMLFragment(string, (String)object2, (String)object3);
            } else {
                Integer n3;
                SchemaAwareHandlerResult schemaAwareHandlerResult = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string, (String)object2, (String)object3);
                if (schemaAwareHandlerResult != null && (n3 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset")) != null) {
                    n2 = n3;
                }
            }
            if (bl2) {
                MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n2);
            } else if (bl) {
                try {
                    int n4 = authorAccess.getEditorAccess().getCaretOffset();
                    authorAccess.getEditorAccess().goToNextEditablePosition(n2, n4);
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
        } else {
            throw new IllegalArgumentException("The argument value was not defined, it is " + object);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Insert a document fragment.";
    }
}

