/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.NameValue;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorWorkspaceAccess;
import ro.sync.ecss.extensions.commons.CannotEditException;
import ro.sync.ecss.images.ImageHandlerDispatcher;
import ro.sync.ecss.images.xmlimages.XMLImageHandler;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertEquationOperation
implements AuthorOperation {
    protected static final Logger logger = Logger.getLogger((String)InsertEquationOperation.class.getName());
    private static final String ARGUMENT_FRAGMENT_WITH_MATHML = "fragment";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    public static final String MATH_ML = "<mml:math xmlns:mml=\"http://www.w3.org/1998/Math/MathML\"></mml:math>";

    public InsertEquationOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_FRAGMENT_WITH_MATHML, 1, "The fragment of XML containing the default MathML content which should be inserted");
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        try {
            AuthorWorkspaceAccess authorWorkspaceAccess = authorAccess.getWorkspaceAccess();
            XMLImageHandler xMLImageHandler = ImageHandlerDispatcher.getInstance().getXMLImageHandlerFor("mathml");
            if (xMLImageHandler != null) {
                String string = null;
                AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                AuthorDocumentType authorDocumentType = authorDocumentController.getDoctype();
                if (authorDocumentType != null) {
                    string = authorDocumentType.getContent();
                }
                List<NameValue> list = null;
                AuthorSchemaManager authorSchemaManager = authorDocumentController.getAuthorSchemaManager();
                if (string != null && authorSchemaManager != null) {
                    list = authorSchemaManager.getEntities();
                }
                String string2 = this.createDefaultFragmentToEdit(authorAccess, authorSchemaManager);
                Object object = argumentsMap.getArgumentValue(ARGUMENT_FRAGMENT_WITH_MATHML);
                if (object instanceof String && !((String)object).isEmpty()) {
                    string2 = (String)object;
                }
                String string3 = this.extractMathMLFragment(string2);
                String string4 = null;
                if (string3 != null) {
                    string4 = xMLImageHandler.editImage(string3, string, authorAccess.getEditorAccess().getEditorLocation().toString(), list);
                }
                if (string4 != null) {
                    string2 = string2.replace(string3, string4);
                }
                if (string4 != null || string3 == null) {
                    int n2 = authorAccess.getEditorAccess().getCaretOffset();
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string2, n2);
                }
            } else {
                authorWorkspaceAccess.showInformationMessage("MathML editing is not supported.");
            }
        }
        catch (CannotEditException cannotEditException) {
            throw new AuthorOperationException(cannotEditException.getMessage(), cannotEditException);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Insert a MathML equation.";
    }

    protected String createDefaultFragmentToEdit(AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) {
        return MATH_ML;
    }

    private String extractMathMLFragment(String string) {
        String string2;
        int n2;
        String string3 = null;
        int n3 = string.indexOf("http://www.w3.org/1998/Math/MathML");
        if (n3 != -1 && (n2 = (string2 = string.substring(0, n3)).lastIndexOf("<")) != -1) {
            String string4;
            String string5;
            int n4;
            String string6 = null;
            for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                char c2 = string.charAt(i2);
                if (!Character.isWhitespace(c2)) continue;
                string6 = string.substring(n2 + 1, i2);
                break;
            }
            if (string6 != null && (n4 = (string5 = string.substring(n3, string.length())).indexOf(string4 = "</" + string6 + ">")) != -1) {
                string3 = string.substring(n2, n3 + n4 + string4.length());
            }
        }
        return string3;
    }
}

