/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteMultipleActionsOperation
implements AuthorOperation {
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    private static final String ACTION_IDS = "actionIDs";

    public ExecuteMultipleActionsOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ACTION_IDS, 0, "The action IDs which will be executed in sequence, separated by new lines.");
    }

    @Override
    public String getDescription() {
        return "Run a sequence of actions defined in the associated document type.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ACTION_IDS);
        if (object != null) {
            String string = (String)object;
            String[] stringArray = string.split("\n");
            Map<String, Object> map = authorAccess.getEditorAccess().getActionsProvider().getAuthorExtensionActions();
            Map<String, Object> map2 = authorAccess.getEditorAccess().getActionsProvider().getAuthorCommonActions();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object object2;
                String string2 = stringArray[i2];
                boolean bl = false;
                if (map != null && (object2 = map.get(string2)) != null) {
                    bl = true;
                    authorAccess.getEditorAccess().getActionsProvider().invokeAction(object2);
                }
                if (!bl && map2 != null && (object2 = map2.get(string2)) != null) {
                    bl = true;
                    authorAccess.getEditorAccess().getActionsProvider().invokeAction(object2);
                }
                if (bl) continue;
                throw new AuthorOperationException("Could not find an extension action with the ID: '" + string2 + "'");
            }
        } else {
            throw new AuthorOperationException("The actions IDs were not specified as a parameter.");
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

