/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class DeleteElementsOperation
implements AuthorOperation {
    public static final String ARGUMENT_ELEMENT_XPATH_LOCATIONS = "elementLocations";
    protected ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];

    public DeleteElementsOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATIONS, 2, "An XPath expression indicating the elements to be deleted.\nNote: If it is not defined then the element at the caret position will be used.");
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATIONS);
        AuthorNode[] authorNodeArray = null;
        if (object instanceof String && ((String)object).trim().length() > 0) {
            authorNodeArray = authorAccess.getDocumentController().findNodesByXPath(((String)object).trim(), true, true, true);
            if (authorNodeArray.length == 0) {
                throw new AuthorOperationException("The element XPath location does not identify a node: " + object);
            }
        } else {
            try {
                authorNodeArray = new AuthorNode[]{authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset())};
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current node", badLocationException);
            }
        }
        if (authorNodeArray.length > 0) {
            int n2;
            Object object2;
            Arrays.sort(authorNodeArray, new Comparator<AuthorNode>(){

                @Override
                public int compare(AuthorNode authorNode, AuthorNode authorNode2) {
                    int n2 = 0;
                    n2 = authorNode.getStartOffset() < authorNode2.getStartOffset() ? -1 : 1;
                    return n2;
                }
            });
            ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
            for (int i2 = 0; i2 < authorNodeArray.length; ++i2) {
                boolean bl = false;
                AuthorNode authorNode = authorNodeArray[i2];
                for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                    object2 = (AuthorNode)arrayList.get(i3);
                    if (object2.getEndOffset() <= authorNode.getEndOffset()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(authorNode);
            }
            ArrayList<AuthorNode> arrayList2 = null;
            ArrayList<AuthorNode> arrayList3 = null;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                AuthorNode authorNode = (AuthorNode)arrayList.get(n2);
                if (authorNode.getParent() != null && authorNode.getParent().getType() == 2) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<AuthorNode>();
                    }
                    arrayList2.add(authorNode);
                    continue;
                }
                if (authorNode.getParent() == null) continue;
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<AuthorNode>();
                }
                arrayList3.add(authorNode);
            }
            if (arrayList2 != null) {
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    authorAccess.getDocumentController().deleteNode((AuthorNode)arrayList2.get(n2));
                }
            }
            if (arrayList3 != null) {
                AuthorNode authorNode = authorAccess.getDocumentController().getCommonAncestor(arrayList.toArray(new AuthorNode[0]));
                if (arrayList.contains(authorNode)) {
                    authorNode = authorNode.getParent();
                }
                int[] nArray = new int[arrayList.size()];
                object2 = new int[arrayList.size()];
                for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                    AuthorNode authorNode2 = (AuthorNode)arrayList.get(i4);
                    nArray[i4] = authorNode2.getStartOffset();
                    object2[i4] = authorNode2.getEndOffset();
                }
                if (authorNode != null && authorNode instanceof AuthorElement) {
                    authorAccess.getDocumentController().multipleDelete((AuthorElement)authorNode, nArray, (int[])object2);
                }
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Deletes the elements specified by an XPath expression or the element at the caret position";
    }
}

