/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangePseudoClassesOperation
implements AuthorOperation {
    private static final String ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS = "setLocations";
    private static final String ARGUMENT_SET_PSEUDOCLASS_NAMES = "setPseudoClassNames";
    private static final String ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS = "removeLocations";
    private static final String ARGUMENT_REMOVE_PSEUDOCLASS_NAMES = "removePseudoClassNames";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[4];

    public ChangePseudoClassesOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes on which the specified list of pseudo classes will be set.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SET_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be set on the matched nodes.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, 2, "An XPath expression indicating a list of nodes from which the specified list of pseudo classes will be removed.\nNote: If it is not defined, then the element at the caret position will be used.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, 0, "A space-separated list of pseudo class names which will be removed from the matched nodes.");
    }

    @Override
    public String getDescription() {
        return "Sets a set of pseudo classes to all nodes identified by an XPath expression.\nRemoves a set of pseudo classes from all nodes identified by an XPath expression.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, argumentsMap, ARGUMENT_ELEMENT_SET_XPATH_LOCATIONS, ARGUMENT_SET_PSEUDOCLASS_NAMES, true);
        ChangePseudoClassesOperation.setOrRemovePseudoClasses(authorAccess, argumentsMap, ARGUMENT_ELEMENT_REMOVE_XPATH_LOCATIONS, ARGUMENT_REMOVE_PSEUDOCLASS_NAMES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrRemovePseudoClasses(AuthorAccess authorAccess, ArgumentsMap argumentsMap, String string, String string2, boolean bl) throws AuthorOperationException {
        String[] stringArray;
        Object object = argumentsMap.getArgumentValue(string);
        Object object2 = argumentsMap.getArgumentValue(string2);
        if (object2 instanceof String && (stringArray = ((String)object2).split(" ")) != null && stringArray.length > 0) {
            Object object3;
            ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            if (object instanceof String && ((String)object).trim().length() > 0) {
                object3 = authorDocumentController.findNodesByXPath((String)object, true, true, true);
                for (int i2 = 0; i2 < ((AuthorNode[])object3).length; ++i2) {
                    AuthorNode authorNode = object3[i2];
                    if (authorNode.getType() != 0) continue;
                    arrayList.add((AuthorElement)authorNode);
                }
                if (arrayList.size() == 0) {
                    throw new AuthorOperationException("The element XPath location does not identify an element: " + object);
                }
            } else {
                object3 = null;
                try {
                }
                catch (BadLocationException badLocationException) {
                    throw new AuthorOperationException("Cannot identify the current element", badLocationException);
                }
                for (object3 = authorDocumentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); object3 != null && !(object3 instanceof AuthorElement); object3 = object3.getParent()) {
                }
                if (object3 instanceof AuthorElement) {
                    arrayList.add((AuthorElement)object3);
                } else {
                    throw new AuthorOperationException("You need to have the carret inside an element.");
                }
            }
            authorDocumentController.disableLayoutUpdate();
            try {
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    AuthorElement authorElement = (AuthorElement)arrayList.get(i3);
                    for (int i4 = 0; i4 < stringArray.length; ++i4) {
                        if (bl) {
                            authorDocumentController.setPseudoClass(stringArray[i4], authorElement);
                            continue;
                        }
                        authorDocumentController.removePseudoClass(stringArray[i4], authorElement);
                    }
                }
            }
            finally {
                AuthorNode authorNode = authorDocumentController.getCommonAncestor(arrayList.toArray(new AuthorNode[0]));
                authorDocumentController.enableLayoutUpdate(authorNode);
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

