/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.util.editorvars.EditorVariables;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class GenerateIDElementsInfo {
    private static final Logger logger = Logger.getLogger(GenerateIDElementsInfo.class);
    public static final String GENERATE_ID_ELEMENTS_KEY = "generate.id.for.elements";
    public static final String GENERATE_ID_ELEMENTS_ACTIVE_KEY = "auto.generate.id.elements.active";
    public static final String GENERATE_ID_PATTERN_KEY = "generate.ids.pattern";
    public static final String FILTER_IDS_ON_COPY_KEY = "filter.ids.on.copy";
    public static final String LOCAL_NAME_PATTERN_MACRO = "${localName}";
    public static final String LOCAL_NAME_PATTERN_DESCRIPTION = "The local name of the element.";
    public static final String UUID_PATTERN_DESCRIPTION = "Universally Unique Identifier";
    public static final String ID_PATTERN_DESCRIPTION = "Compact Unique Identifier";
    public static final String DEFAULT_ID_GENERATION_PATTERN = "${localName}_${id}";
    public static String PATTERN_TOOLTIP = "${id} - Compact Unique Identifier; \n${uuid} - Universally Unique Identifier; \n ${localName} - The local name of the element.";
    private boolean autoGenerateIds;
    private String idGenerationPattern;
    private String[] elementsWithIDGeneration;
    private boolean removeIDsOnCopy;
    private String patternTooltip = PATTERN_TOOLTIP;
    private String attrQname;

    public GenerateIDElementsInfo(AuthorAccess authorAccess, GenerateIDElementsInfo generateIDElementsInfo) {
        this(GenerateIDElementsInfo.isAutoGenerateIDs(authorAccess, generateIDElementsInfo), GenerateIDElementsInfo.getIDGenerationPattern(authorAccess, generateIDElementsInfo), GenerateIDElementsInfo.getIDGenerationElements(authorAccess, generateIDElementsInfo), GenerateIDElementsInfo.isFilterIDs(authorAccess, generateIDElementsInfo));
        this.setPatternTooltip(generateIDElementsInfo.getPatternTooltip());
    }

    private static String[] getIDGenerationElements(AuthorAccess authorAccess, GenerateIDElementsInfo generateIDElementsInfo) {
        return GenerateIDElementsInfo.splitStrings(authorAccess.getOptionsStorage().getOption(GENERATE_ID_ELEMENTS_KEY, generateIDElementsInfo.getElementsAsOptionsString()));
    }

    private static String getIDGenerationPattern(AuthorAccess authorAccess, GenerateIDElementsInfo generateIDElementsInfo) {
        return authorAccess.getOptionsStorage().getOption(GENERATE_ID_PATTERN_KEY, generateIDElementsInfo.getIdGenerationPattern());
    }

    private static boolean isAutoGenerateIDs(AuthorAccess authorAccess, GenerateIDElementsInfo generateIDElementsInfo) {
        Boolean bl = Boolean.valueOf(authorAccess.getOptionsStorage().getOption(GENERATE_ID_ELEMENTS_ACTIVE_KEY, Boolean.toString(generateIDElementsInfo.isAutoGenerateIDs())));
        return bl;
    }

    private static boolean isFilterIDs(AuthorAccess authorAccess, GenerateIDElementsInfo generateIDElementsInfo) {
        return Boolean.valueOf(authorAccess.getOptionsStorage().getOption(FILTER_IDS_ON_COPY_KEY, Boolean.toString(generateIDElementsInfo.isFilterIDsOnCopy())));
    }

    private static String[] splitStrings(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string.split(",");
    }

    public GenerateIDElementsInfo(boolean bl, String string, String[] stringArray) {
        this(bl, string, stringArray, true);
    }

    public GenerateIDElementsInfo(boolean bl, String string, String[] stringArray, boolean bl2) {
        this.autoGenerateIds = bl;
        this.idGenerationPattern = string;
        this.elementsWithIDGeneration = stringArray;
        this.removeIDsOnCopy = bl2;
    }

    public boolean isAutoGenerateIDs() {
        return this.autoGenerateIds;
    }

    public boolean isFilterIDsOnCopy() {
        return this.removeIDsOnCopy;
    }

    public String getIdGenerationPattern() {
        return this.idGenerationPattern;
    }

    public String[] getElementsWithIDGeneration() {
        return this.elementsWithIDGeneration;
    }

    public void saveToOptions(AuthorAccess authorAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getElementsAsOptionsString());
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_ELEMENTS_KEY, stringBuilder.toString());
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_PATTERN_KEY, this.idGenerationPattern);
        authorAccess.getOptionsStorage().setOption(GENERATE_ID_ELEMENTS_ACTIVE_KEY, Boolean.toString(this.autoGenerateIds));
        authorAccess.getOptionsStorage().setOption(FILTER_IDS_ON_COPY_KEY, Boolean.toString(this.removeIDsOnCopy));
    }

    private String getElementsAsOptionsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.elementsWithIDGeneration != null) {
            for (int i2 = 0; i2 < this.elementsWithIDGeneration.length; ++i2) {
                stringBuilder.append(this.elementsWithIDGeneration[i2]).append(",");
            }
        }
        return stringBuilder.toString();
    }

    public static String generateID(String string, String string2) {
        if (string.indexOf(LOCAL_NAME_PATTERN_MACRO) != -1) {
            string = GenerateIDElementsInfo.replaceAll(string, LOCAL_NAME_PATTERN_MACRO, string2);
        }
        string = EditorVariables.expandEditorVariables(string, null);
        return string;
    }

    private static String replaceAll(String string, String string2, String string3) {
        try {
            return Pattern.compile(string2, 16).matcher(string).replaceAll(Matcher.quoteReplacement(string3));
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public void setAutoGenerateIds(boolean bl) {
        this.autoGenerateIds = bl;
    }

    public void setElementsWithIDGeneration(String[] stringArray) {
        this.elementsWithIDGeneration = stringArray;
    }

    public void setRemoveIDsOnCopy(boolean bl) {
        this.removeIDsOnCopy = bl;
    }

    public void setIdGenerationPattern(String string) {
        this.idGenerationPattern = string;
    }

    public String getPatternTooltip() {
        return this.patternTooltip;
    }

    public void setPatternTooltip(String string) {
        this.patternTooltip = string;
    }

    public static GenerateIDElementsInfo loadDefaultsFromConfiguration(AuthorAccess authorAccess, String string) {
        URL uRL;
        if (string == null) {
            string = "idGenerationDefaultOptions.xml";
        }
        final GenerateIDElementsInfo generateIDElementsInfo = new GenerateIDElementsInfo(false, DEFAULT_ID_GENERATION_PATTERN, new String[0]);
        if (authorAccess != null && (uRL = CommonsOperationsUtil.locateResourceInClasspath(authorAccess, string)) != null) {
            XMLReader xMLReader = authorAccess.getXMLUtilAccess().newNonValidatingXMLReader();
            final ArrayList arrayList = new ArrayList();
            xMLReader.setContentHandler(new ContentHandler(){
                private StringBuilder chars = new StringBuilder();

                @Override
                public void startPrefixMapping(String string, String string2) throws SAXException {
                }

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    this.chars.setLength(0);
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void skippedEntity(String string) throws SAXException {
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                }

                @Override
                public void processingInstruction(String string, String string2) throws SAXException {
                }

                @Override
                public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
                }

                @Override
                public void endPrefixMapping(String string) throws SAXException {
                }

                @Override
                public void endElement(String string, String string2, String string3) throws SAXException {
                    if ("autoGenerate".equals(string2)) {
                        generateIDElementsInfo.autoGenerateIds = "true".equals(this.chars.toString().trim());
                    } else if ("idAttribute".equals(string2)) {
                        generateIDElementsInfo.attrQname = this.chars.toString().trim();
                    } else if ("idPattern".equals(string2)) {
                        generateIDElementsInfo.idGenerationPattern = this.chars.toString().trim();
                    } else if ("removeIDsOnCopy".equals(string2)) {
                        generateIDElementsInfo.removeIDsOnCopy = "true".equals(this.chars.toString().trim());
                    } else if ("generateForElement".equals(string2)) {
                        String string4 = this.chars.toString().trim();
                        arrayList.add(string4);
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void endDocument() throws SAXException {
                }

                @Override
                public void characters(char[] cArray, int n2, int n3) throws SAXException {
                    this.chars.append(cArray, n2, n3);
                }
            });
            try {
                xMLReader.parse(uRL.toString());
                generateIDElementsInfo.elementsWithIDGeneration = arrayList.toArray(new String[0]);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
            catch (SAXException sAXException) {
                logger.error((Object)sAXException, (Throwable)sAXException);
            }
        }
        return generateIDElementsInfo;
    }

    public String getAttrQname() {
        return this.attrQname;
    }
}

