/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECIDElementsCustomizerDialog
extends Dialog {
    private List listOfElements;
    private Button autoAssignElementIDs;
    private Button filterIDsOnCopy;
    private Text idGenerationPatternField;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private final String listMessage;
    private GenerateIDElementsInfo autoIDElementsInfo;
    private final AuthorResourceBundle authorResourceBundle;

    public ECIDElementsCustomizerDialog(Shell shell, String string, AuthorResourceBundle authorResourceBundle) {
        super(shell);
        this.listMessage = string;
        this.authorResourceBundle = authorResourceBundle;
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.authorResourceBundle.getMessage("ID_options"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 16384);
        GridData gridData = new GridData(0, 0, false, false);
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText(this.authorResourceBundle.getMessage("ID_pattern"));
        this.idGenerationPatternField = new Text(composite2, 2052);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 1;
        gridData.verticalIndent = 10;
        gridData.horizontalIndent = 5;
        this.idGenerationPatternField.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 4);
        composite3.setLayout((Layout)new GridLayout(3, true));
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        Label label2 = new Label(composite3, 16384);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
        label2.setText(this.listMessage + ":");
        this.listOfElements = new List(composite3, 2820);
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 250;
        gridData.heightHint = 200;
        this.listOfElements.setLayoutData((Object)gridData);
        this.addButton = new Button(composite3, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECIDElementsCustomizerDialog.this.addNewElement();
            }
        });
        this.addButton.setText(this.authorResourceBundle.getMessage("Add"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.addButton.setLayoutData((Object)gridData);
        this.editButton = new Button(composite3, 8);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECIDElementsCustomizerDialog.this.editElement();
            }
        });
        this.editButton.setText(this.authorResourceBundle.getMessage("Edit"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.removeButton = new Button(composite3, 8);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECIDElementsCustomizerDialog.this.removeElement();
            }
        });
        this.removeButton.setText(this.authorResourceBundle.getMessage("Remove"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.listOfElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ECIDElementsCustomizerDialog.this.updateButtonState();
            }
        });
        this.autoAssignElementIDs = new Button(composite2, 32);
        this.autoAssignElementIDs.setText(this.authorResourceBundle.getMessage("Autogenerate_ids_for_elements"));
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        this.autoAssignElementIDs.setLayoutData((Object)gridData);
        this.filterIDsOnCopy = new Button(composite2, 32);
        this.filterIDsOnCopy.setText(this.authorResourceBundle.getMessage("Remove_ids_on_copy_in_same_doc"));
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 5;
        this.filterIDsOnCopy.setLayoutData((Object)gridData);
        if (this.autoAssignElementIDs != null) {
            this.autoAssignElementIDs.setSelection(this.autoIDElementsInfo.isAutoGenerateIDs());
            String string = this.autoIDElementsInfo.getIdGenerationPattern();
            this.idGenerationPatternField.setText(string != null ? string : "");
            String[] stringArray = this.autoIDElementsInfo.getElementsWithIDGeneration();
            this.listOfElements.setItems(stringArray != null ? stringArray : new String[]{});
            this.filterIDsOnCopy.setSelection(this.autoIDElementsInfo.isFilterIDsOnCopy());
            this.idGenerationPatternField.setToolTipText(this.autoIDElementsInfo.getPatternTooltip());
        }
        this.updateButtonState();
        return composite2;
    }

    private void updateButtonState() {
        int n2 = this.listOfElements.getSelectionIndex();
        boolean bl = n2 != -1;
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    private void addNewElement() {
        String string;
        InputDialog inputDialog = new InputDialog(this.getShell(), this.authorResourceBundle.getMessage("Add"), this.listMessage + ": ", "", null);
        int n2 = inputDialog.open();
        if (n2 == 0 && (string = inputDialog.getValue()) != null) {
            this.listOfElements.add(string);
            this.listOfElements.setSelection(this.listOfElements.getItemCount() - 1);
        }
    }

    private void editElement() {
        String string;
        InputDialog inputDialog;
        int n2;
        int n3 = this.listOfElements.getSelectionIndex();
        if (n3 != -1 && (n2 = (inputDialog = new InputDialog(this.getShell(), this.authorResourceBundle.getMessage("Edit"), this.listMessage + ": ", this.listOfElements.getItem(n3), null)).open()) == 0 && (string = inputDialog.getValue()) != null) {
            this.listOfElements.setItem(n3, string);
        }
    }

    private void removeElement() {
        int n2 = this.listOfElements.getSelectionIndex();
        if (n2 != -1) {
            this.listOfElements.remove(n2);
            int n3 = this.listOfElements.getItemCount();
            if (n3 > 0) {
                if (n2 < n3) {
                    this.listOfElements.setSelection(n2);
                } else {
                    this.listOfElements.setSelection(n3 - 1);
                }
            }
        }
    }

    protected void okPressed() {
        this.autoIDElementsInfo = new GenerateIDElementsInfo(this.autoAssignElementIDs.getSelection(), this.idGenerationPatternField.getText(), this.listOfElements.getItems(), this.filterIDsOnCopy.getSelection());
        super.okPressed();
    }

    public GenerateIDElementsInfo showDialog(GenerateIDElementsInfo generateIDElementsInfo) {
        this.autoIDElementsInfo = generateIDElementsInfo;
        if (this.open() == 0) {
            return this.autoIDElementsInfo;
        }
        return null;
    }
}

