/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class URLChooserEditorSWT
extends AbstractInplaceEditor
implements ITextOperationTarget {
    private Composite urlChooserComposite;
    private Button browseButton;
    private SourceViewer textViewer;
    private Image buttonImage;
    private boolean isBrowsing = false;
    private AuthorUtilAccess utilAccess;
    private org.eclipse.swt.graphics.Font swtFont;
    private org.eclipse.swt.graphics.Color foregroundColor;

    @Override
    public String getDescription() {
        return "A sample implementation that provides a browse button associated with a text field.";
    }

    @Override
    public Object getEditorComponent(final AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.prepareComponents(authorInplaceContext);
        final AuthorAccess authorAccess = authorInplaceContext.getAuthorAccess();
        final URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        this.browseButton.addListener(13, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                block5: {
                    URLChooserEditorSWT.this.isBrowsing = true;
                    try {
                        URL uRL3 = authorInplaceContext.getAuthorAccess().getWorkspaceAccess().chooseURL("Choose URL", null, null);
                        if (uRL3 == null) break block5;
                        String string = authorInplaceContext.getAuthorAccess().getUtilAccess().makeRelative(uRL, uRL3);
                        URLChooserEditorSWT.this.utilAccess = authorAccess.getUtilAccess();
                        try {
                            URL uRL2 = URLChooserEditorSWT.this.utilAccess.removeUserCredentials(new URL(string));
                            URLChooserEditorSWT.this.textViewer.getTextWidget().setText(uRL2.toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            URLChooserEditorSWT.this.textViewer.getTextWidget().setText(string);
                        }
                        URLChooserEditorSWT.this.fireCommitValue(new EditingEvent((String)URLChooserEditorSWT.this.getValue()));
                    }
                    finally {
                        URLChooserEditorSWT.this.isBrowsing = false;
                    }
                }
            }
        });
        this.browseButton.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 16) {
                    URLChooserEditorSWT.this.fireNextEditLocationRequested();
                    traverseEvent.doit = false;
                }
            }
        });
        this.textViewer.getTextWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 8) {
                    URLChooserEditorSWT.this.firePreviousEditLocationRequested();
                    traverseEvent.doit = false;
                }
            }
        });
        this.textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                switch (verifyEvent.keyCode) {
                    case 9: {
                        verifyEvent.doit = false;
                        break;
                    }
                    case 10: 
                    case 13: 
                    case 0x1000050: {
                        if ((verifyEvent.stateMask & 0x40000) != 0) break;
                        verifyEvent.doit = false;
                        URLChooserEditorSWT.this.stopEditing(true);
                    }
                }
            }
        });
        return this.urlChooserComposite;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.textViewer.getTextWidget().setFocus();
    }

    @Override
    public Object getValue() {
        String string = this.textViewer.getTextWidget().getText();
        try {
            URL uRL = this.utilAccess.removeUserCredentials(new URL(string));
            return uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    @Override
    public void stopEditing() {
        this.stopEditing(false);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    private void stopEditing(boolean bl) {
        String string = (String)this.getValue();
        if (bl) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent(string));
        }
        this.dispose();
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
        this.dispose();
    }

    private void prepareComponents(AuthorInplaceContext authorInplaceContext) {
        this.dispose();
        this.urlChooserComposite = new Composite((Composite)authorInplaceContext.getParentHost(), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.urlChooserComposite.setLayout((Layout)gridLayout);
        this.textViewer = new SourceViewer(this.urlChooserComposite, null, 2052);
        this.textViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsPlugin.getDefault().getPreferenceStore()));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        this.textViewer.getTextWidget().setLayoutData((Object)gridData);
        this.browseButton = new Button(this.urlChooserComposite, 8);
        gridData = new GridData(0, 4, false, true);
        this.textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
                switch (verifyEvent.keyCode) {
                    case 27: {
                        verifyEvent.doit = false;
                        URLChooserEditorSWT.this.cancelEditing();
                    }
                }
            }
        });
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(URLChooserEditorSWT.this.urlChooserComposite.isDisposed() || URLChooserEditorSWT.this.browseButton.isFocusControl() || URLChooserEditorSWT.this.textViewer.getTextWidget().isFocusControl() || URLChooserEditorSWT.this.isBrowsing)) {
                            URLChooserEditorSWT.this.fireCommitValue(new EditingEvent((String)URLChooserEditorSWT.this.getValue()));
                        }
                    }
                });
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        };
        this.textViewer.getTextWidget().addFocusListener(focusListener);
        this.browseButton.addFocusListener(focusListener);
        this.browseButton.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 27: {
                        keyEvent.doit = false;
                        URLChooserEditorSWT.this.cancelEditing();
                    }
                }
            }
        });
        this.textViewer.setDocument((IDocument)new Document(""));
        IDocumentListener iDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }

            public void documentChanged(DocumentEvent documentEvent) {
                URLChooserEditorSWT.this.fireEditingOccured();
            }
        };
        this.textViewer.getDocument().addDocumentListener(iDocumentListener);
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.swtFont = new org.eclipse.swt.graphics.Font((Device)Display.getDefault(), new FontData(font.getName(), font.getSize(), font.getStyle()));
        }
        if (this.swtFont != null) {
            this.textViewer.getTextWidget().setFont(this.swtFont);
        } else {
            this.textViewer.getTextWidget().setFont(JFaceResources.getDialogFont());
        }
        Color color = (Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.foregroundColor = new org.eclipse.swt.graphics.Color((Device)Display.getDefault(), color.getRed(), color.getGreen(), color.getBlue());
            this.textViewer.getTextWidget().setForeground(this.foregroundColor);
        }
        InputStream inputStream = URLChooserEditorSWT.class.getResourceAsStream("/images/Open16.gif");
        ImageData imageData = null;
        if (inputStream != null) {
            imageData = new ImageData(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ImageDescriptor imageDescriptor = null;
        if (imageData != null) {
            imageDescriptor = ImageDescriptor.createFromImageData((ImageData)imageData);
        }
        this.buttonImage = null;
        if (imageDescriptor != null) {
            this.buttonImage = imageDescriptor.createImage();
        }
        if (this.buttonImage != null) {
            this.browseButton.setImage(this.buttonImage);
        }
        this.browseButton.setLayoutData((Object)gridData);
        this.setInitialValue(authorInplaceContext);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (URLChooserEditorSWT.this.textViewer.getTextWidget() != null) {
                    URLChooserEditorSWT.this.textViewer.getTextWidget().showSelection();
                }
            }
        });
        this.textViewer.getUndoManager().reset();
    }

    private void setInitialValue(AuthorInplaceContext authorInplaceContext) {
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (string == null) {
            string = (String)authorInplaceContext.getArguments().get("default_value");
        }
        if (string == null) {
            string = "";
        }
        this.utilAccess = authorInplaceContext.getAuthorAccess().getUtilAccess();
        try {
            URL uRL = this.utilAccess.removeUserCredentials(new URL(string));
            string = uRL.toExternalForm();
            this.textViewer.getTextWidget().setText(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.textViewer.getTextWidget().setText(string);
        }
        this.textViewer.getTextWidget().setCaretOffset(string.length());
    }

    private void dispose() {
        if (this.swtFont != null) {
            this.swtFont.dispose();
        }
        if (this.urlChooserComposite != null) {
            this.urlChooserComposite.dispose();
        }
        if (this.buttonImage != null) {
            this.buttonImage.dispose();
        }
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }

    public boolean canDoOperation(int n2) {
        return this.textViewer != null ? this.textViewer.canDoOperation(n2) : false;
    }

    public void doOperation(int n2) {
        this.textViewer.doOperation(n2);
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.setInitialValue(authorInplaceContext);
    }
}

