/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.ecss.extensions.api.webapp.plugin.UserContext;
import ro.sync.ecss.webapp.o;
import ro.sync.ecss.webapp.plugin.d;
import ro.sync.exml.v;

@API(src=SourceType.PUBLIC, type=APIType.EXTENDABLE)
public abstract class URLStreamHandlerWithContext
extends URLStreamHandler {
    private static final String FAKE_ORIGIN = "oxygen-webapp";
    private static final Logger logger = Logger.getLogger((String)URLStreamHandlerWithContext.class.getName());

    protected URLStreamHandlerWithContext() {
    }

    void setUserContext(UserContext userContext, URL uRL) throws MalformedURLException {
        String string;
        String string2 = uRL.getUserInfo();
        String string3 = this.getContextId(userContext);
        if (string2 != null) {
            try {
                string3 = string3 + ":" + URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
            }
        }
        if ((string = uRL.getAuthority()) == null) {
            string = FAKE_ORIGIN;
        }
        String string4 = string.substring(string.indexOf(64) + 1);
        this.setURL(uRL, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3 + "@" + string4, string3, uRL.getPath(), uRL.getQuery(), uRL.getRef());
    }

    protected String getContextId(UserContext userContext) {
        return userContext.getSessionId();
    }

    URL stripUrlContextId(URL uRL) {
        URL uRL2 = uRL;
        try {
            String string;
            uRL2 = new URL(uRL, uRL.toExternalForm(), this);
            String string2 = uRL.getAuthority();
            String string3 = string2.substring(string2.indexOf(64) + 1);
            if (FAKE_ORIGIN.equals(string3)) {
                string3 = null;
            }
            String string4 = uRL.getUserInfo();
            String string5 = null;
            if (string4 != null && string4.contains(":")) {
                string = string4.split(":")[1];
                try {
                    string5 = URLDecoder.decode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
                }
            }
            string = string3;
            if (string5 != null) {
                string = string5 + "@" + string3;
            }
            this.setURL(uRL2, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string, string5, uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)"Error re-parsing URL: ", (Throwable)malformedURLException);
        }
        return uRL2;
    }

    String getUrlContextId(URL uRL) {
        String string = uRL.getUserInfo();
        if (string.contains(":")) {
            string = string.split(":")[0];
        }
        return string;
    }

    @Override
    protected final URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        String string = this.getUrlContextId(uRL);
        URL uRL2 = this.stripUrlContextId(uRL);
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.openConnectionInContext(string, uRL2, proxy);
        }
        catch (UserActionRequiredException userActionRequiredException) {
            ((o)v.getInstance()).r(userActionRequiredException.getUserMessage());
            throw userActionRequiredException;
        }
        return new d(uRLConnection);
    }

    @Override
    protected final URLConnection openConnection(URL uRL) throws IOException {
        return this.openConnection(uRL, null);
    }

    protected abstract URLConnection openConnectionInContext(String var1, URL var2, Proxy var3) throws IOException;
}

