/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.WebappServletPluginExtension;
import ro.sync.exml.options.Options;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class PluginConfigExtension
extends WebappServletPluginExtension {
    private Map<String, String> defaultOptions = null;
    private WSOptionsStorage optionsStorage;

    @Override
    public abstract String getPath();

    public PluginConfigExtension() {
        this.setDefaultOptions(null);
    }

    @Override
    public void init() throws ServletException {
        this.optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String string = this.getPath();
        if (string != null && !string.isEmpty()) {
            this.optionsStorage.setOptionsDoctypePrefix("webapp-plugin-options-" + string);
        } else {
            this.optionsStorage.setOptionsDoctypePrefix(null);
        }
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getHeader("Accept");
        if ("text/html".equals(string)) {
            httpServletResponse.setStatus(200);
            httpServletResponse.getWriter().write(this.getOptionsForm());
            httpServletResponse.getWriter().flush();
        } else if ("application/json".equals(string)) {
            httpServletResponse.setStatus(200);
            httpServletResponse.getWriter().write(this.getOptionsJson());
            httpServletResponse.getWriter().flush();
        } else {
            httpServletResponse.sendError(400);
        }
    }

    @Override
    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = httpServletRequest.getReader();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        Map map = null;
        map = (Map)objectMapper.readValue(stringBuilder.toString(), (TypeReference)typeReference);
        for (Map.Entry entry : map.entrySet()) {
            this.setOption((String)entry.getKey(), (String)entry.getValue());
        }
        this.saveOptions();
        httpServletResponse.setStatus(200);
    }

    @Override
    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.defaultOptions == null) {
            httpServletResponse.setStatus(204);
            return;
        }
        for (Map.Entry<String, String> entry : this.defaultOptions.entrySet()) {
            this.optionsStorage.setOption(entry.getKey(), entry.getValue());
        }
        this.saveOptions();
        httpServletResponse.setStatus(200);
    }

    protected String getOption(String string, String string2) {
        return this.optionsStorage.getOption(string, string2);
    }

    protected void setOption(String string, String string2) {
        this.optionsStorage.setOption(string, string2);
    }

    protected void saveOptions() throws IOException {
        Options.getInstance().dumpConfigurationNow();
    }

    public Map<String, String> getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(Map<String, String> map) {
        this.defaultOptions = map;
    }

    public abstract String getOptionsForm();

    public abstract String getOptionsJson();

    @Override
    public final boolean requiresAuthorization() {
        return true;
    }
}

