/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.editor;

import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceEditingListener;
import ro.sync.ecss.extensions.api.editor.InplaceEditor;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AbstractInplaceEditor
implements InplaceEditor {
    private final List<InplaceEditingListener> editingListeners = new ArrayList<InplaceEditingListener>();

    protected void fireEditingStopped(EditingEvent editingEvent) {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.editingStopped(editingEvent);
        }
    }

    protected void fireEditingCanceled() {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.editingCanceled();
        }
    }

    protected void fireEditingOccured() {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.editingOccured();
        }
    }

    protected void fireNextEditLocationRequested() {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.nextEditLocationRequested();
        }
    }

    protected void firePreviousEditLocationRequested() {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.previousEditLocationRequested();
        }
    }

    @Override
    public final void addEditingListener(InplaceEditingListener inplaceEditingListener) {
        this.editingListeners.add(inplaceEditingListener);
    }

    @Override
    public final void removeEditingListener(InplaceEditingListener inplaceEditingListener) {
        this.editingListeners.remove(inplaceEditingListener);
    }

    protected void fireCommitValue(EditingEvent editingEvent) {
        ArrayList<InplaceEditingListener> arrayList = new ArrayList<InplaceEditingListener>(this.editingListeners);
        for (InplaceEditingListener inplaceEditingListener : arrayList) {
            inplaceEditingListener.commitValue(editingEvent);
        }
    }

    protected Boolean getBoolean(AuthorInplaceContext authorInplaceContext, String string) {
        Object object = authorInplaceContext.getArguments().get(string);
        Boolean bl = object == null ? null : Boolean.valueOf(object.toString());
        return bl;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
    }

    @Override
    public boolean insertContent(String string) {
        return false;
    }

    @Override
    public void commitValue() {
    }
}

