/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component.sync;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.component.sync.ExpandedSyncInfo;
import ro.sync.ecss.extensions.api.component.sync.Resource2Synchronize;
import ro.sync.ecss.extensions.api.component.sync.ResourcesSynchronizerListener;
import ro.sync.ecss.extensions.api.component.sync.SyncInfoManager;
import ro.sync.io.FileSystemUtil;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class ResourcesSynchronizer {
    private static Logger logger = Logger.getLogger((String)ResourcesSynchronizer.class.getName());
    private SyncInfoManager syncManager;
    private final File syncDir;
    private ResourcesSynchronizerListener listener;
    private static final String LOCK_FILE_NAME = "sync.lock";

    public ResourcesSynchronizer(File file, ResourcesSynchronizerListener resourcesSynchronizerListener) {
        this.syncDir = file;
        this.syncManager = new SyncInfoManager(file);
        this.listener = resourcesSynchronizerListener;
    }

    public SyncInfoManager getSyncManager() {
        return this.syncManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(Resource2Synchronize[] resource2SynchronizeArray) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Synchronize frameworks in " + this.syncDir));
        }
        File file = null;
        File file2 = new File(this.syncDir, LOCK_FILE_NAME);
        if (file2.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Frameworks update already in progress, returning.");
            }
            return;
        }
        boolean bl = false;
        try {
            bl = file2.createNewFile();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException, (Throwable)iOException);
        }
        {
            Object object;
            int n2;
            int n3;
            ArrayList<ExpandedSyncInfo> arrayList = new ArrayList<ExpandedSyncInfo>();
            List<ExpandedSyncInfo> list = this.syncManager.getSyncInfo();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Current frameworks info " + list));
            }
            if (this.listener != null) {
                this.listener.refreshing();
            }
            Iterator<ExpandedSyncInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                ExpandedSyncInfo expandedSyncInfo = iterator.next();
                boolean bl2 = true;
                for (n3 = 0; n3 < resource2SynchronizeArray.length; ++n3) {
                    if (!expandedSyncInfo.getRemoteZIPURL().equals(resource2SynchronizeArray[n3].getURL())) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) {
                    bl2 = false;
                    String[] stringArray2 = expandedSyncInfo.getResourceNames();
                    if (stringArray2 != null && stringArray2.length > 0) {
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            object = new File(this.syncDir, stringArray2[n2]);
                            if (((File)object).exists()) continue;
                            bl2 = true;
                            break;
                        }
                    }
                }
                if (!bl2) continue;
                iterator.remove();
                for (String object2 : stringArray = expandedSyncInfo.getResourceNames()) {
                    File file3 = new File(this.syncDir, object2);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Remove from disk " + file3.getAbsolutePath()));
                    }
                    FileSystemUtil.deleteRecursivelly(file3);
                }
            }
            for (int i2 = 0; i2 < resource2SynchronizeArray.length; ++i2) {
                URL uRL;
                block42: {
                    block41: {
                        uRL = resource2SynchronizeArray[i2].getURL();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ZIP is " + uRL));
                        }
                        if (this.listener == null || !this.listener.synchronizing(uRL)) break block41;
                    }
                    if (uRL != null) break block42;
                    logger.warn((Object)"URL of the ZIPPED frameworks is NULL");
                    resource2SynchronizeArray[i2].disconect();
                    continue;
                }
                try {
                    Object object3;
                    n3 = -1;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        if (!list.get(n2).getRemoteZIPURL().equals(uRL)) continue;
                        n3 = n2;
                        break;
                    }
                    n2 = 1;
                    if (n3 != -1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Framework already present");
                        }
                        object = list.remove(n3);
                        if (resource2SynchronizeArray[i2].getTimestamp() == ((ExpandedSyncInfo)object).getRemoteZIPTimestamp() && (long)resource2SynchronizeArray[i2].getContentLength() == ((ExpandedSyncInfo)object).getRemoteZIPContentLength()) {
                            n2 = 0;
                            arrayList.add((ExpandedSyncInfo)object);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"No update necessary");
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Update necessary, timestamp changed");
                            }
                            object3 = ((ExpandedSyncInfo)object).getResourceNames();
                            for (String string : object3) {
                                File file4 = new File(this.syncDir, string);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Remove from disk " + file4.getAbsolutePath()));
                                }
                                FileSystemUtil.deleteRecursivelly(file4);
                            }
                        }
                    }
                    if (n2 != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Update from " + uRL));
                        }
                        object = resource2SynchronizeArray[i2].getInputStream();
                        file = FileSystemUtil.createTempFile("resource", ".zip");
                        file.deleteOnExit();
                        FileSystemUtil.copyInputStreamToOutputStream((InputStream)object, new FileOutputStream(file), true);
                        object3 = FileSystemUtil.unzip(file, this.syncDir, null);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        Object object2 = object3.iterator();
                        while (object2.hasNext()) {
                            File file5 = (File)object2.next();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Top resource " + file5));
                            }
                            arrayList2.add(file5.getName());
                        }
                        if (!arrayList2.isEmpty()) {
                            object2 = new ExpandedSyncInfo(uRL, arrayList2.toArray(new String[0]), resource2SynchronizeArray[i2].getTimestamp(), resource2SynchronizeArray[i2].getContentLength());
                            arrayList.add((ExpandedSyncInfo)object2);
                        }
                    }
                    resource2SynchronizeArray[i2].disconect();
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)exception, (Throwable)exception);
                    continue;
                }
                finally {
                    resource2SynchronizeArray[i2].disconect();
                }
            }
            this.syncManager.updateSyncInfo(arrayList);
        }
    }
}

