/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.io.Serializable;
import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class WidthRepresentation
implements Serializable {
    private static final long serialVersionUID = -7141751698158508637L;
    public static WidthRepresentation DEFAULT_WIDTH_REPRESENTATION = new WidthRepresentation(0.0f, null, 0.0f, false){

        @Override
        public boolean isSpecified() {
            return false;
        }
    };
    private float fixedWidthValue;
    private Unit fixedWidthUnit = Unit.PIXEL;
    private float relativeWidthValue;
    private boolean isRelativeToParent;
    private String align;

    public WidthRepresentation(float f2, Unit unit, float f3, boolean bl) {
        this.fixedWidthValue = f2;
        if (unit != null) {
            this.fixedWidthUnit = unit;
        }
        this.relativeWidthValue = f3;
        this.isRelativeToParent = bl;
    }

    public WidthRepresentation(String string, boolean bl) {
        this.fixedWidthValue = 0.0f;
        this.fixedWidthUnit = Unit.PIXEL;
        this.relativeWidthValue = 0.0f;
        this.isRelativeToParent = false;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = ((String)stringTokenizer.nextElement()).trim();
                if (string2.length() <= 0) continue;
                char c2 = string2.charAt(string2.length() - 1);
                if (c2 == '%') {
                    if (!bl3) {
                        bl3 = true;
                        if (bl) {
                            String string3 = string2.substring(0, string2.length() - 1);
                            try {
                                this.relativeWidthValue = Float.parseFloat(string3) / 100.0f;
                                this.isRelativeToParent = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl4 = true;
                            }
                            continue;
                        }
                        bl4 = true;
                        continue;
                    }
                    bl4 = true;
                    continue;
                }
                if (c2 == '*') {
                    if (!bl3) {
                        bl3 = true;
                        String string4 = string2.substring(0, string2.length() - 1);
                        try {
                            this.relativeWidthValue = string4.length() == 0 ? 1.0f : Float.parseFloat(string4);
                            this.isRelativeToParent = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl4 = true;
                        }
                        continue;
                    }
                    bl4 = true;
                    continue;
                }
                if (!bl2) {
                    bl2 = true;
                    int n2 = string2.length();
                    try {
                        if (n2 > 1) {
                            String string5 = string2.substring(n2 - 2);
                            int n3 = 2;
                            if ("cm".equals(string5)) {
                                this.fixedWidthUnit = Unit.CENTIMETER;
                            } else if ("em".equals(string5)) {
                                this.fixedWidthUnit = Unit.EM;
                            } else if ("ex".equals(string5)) {
                                this.fixedWidthUnit = Unit.EX;
                            } else if ("in".equals(string5)) {
                                this.fixedWidthUnit = Unit.INCH;
                            } else if ("mm".equals(string5)) {
                                this.fixedWidthUnit = Unit.MILLIMETER;
                            } else if ("pc".equals(string5)) {
                                this.fixedWidthUnit = Unit.PICA;
                            } else if ("px".equals(string5)) {
                                this.fixedWidthUnit = Unit.PIXEL;
                            } else if ("pt".equals(string5)) {
                                this.fixedWidthUnit = Unit.POINT;
                            } else {
                                n3 = 0;
                                this.fixedWidthUnit = Unit.PIXEL;
                            }
                            if (n3 == 0) {
                                this.fixedWidthValue = Float.parseFloat(string2);
                                continue;
                            }
                            this.fixedWidthValue = Float.parseFloat(string2.substring(0, n2 - n3));
                            continue;
                        }
                        if (n2 != 1) continue;
                        this.fixedWidthValue = Float.parseFloat(string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                bl5 = true;
            }
            if (bl4) {
                this.relativeWidthValue = 0.0f;
            }
            if (bl5) {
                this.fixedWidthValue = 0.0f;
            }
        }
    }

    public float getFixedWidth() {
        return this.fixedWidthValue;
    }

    public Unit getFixedWidthUnit() {
        return this.fixedWidthUnit;
    }

    public float getRelativeWidth() {
        return this.relativeWidthValue;
    }

    public boolean isRelativeToParent() {
        return this.isRelativeToParent;
    }

    public boolean isApplicable() {
        return this.relativeWidthValue > 0.0f || this.fixedWidthValue > 0.0f;
    }

    public boolean isSpecified() {
        return true;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String string) {
        this.align = string;
    }

    public String toString() {
        return (this.isRelativeToParent ? "(" + this.relativeWidthValue + ")" + this.relativeWidthValue * 100.0f + "%" : this.relativeWidthValue + "*") + " + " + this.fixedWidthValue + (Object)((Object)this.fixedWidthUnit);
    }

    public String getWidthRepresentation() {
        boolean bl;
        String string = null;
        boolean bl2 = this.relativeWidthValue > 0.0f;
        boolean bl3 = bl = this.fixedWidthValue > 0.0f;
        if (bl2) {
            String string2 = this.isRelativeToParent() ? Math.round(this.relativeWidthValue * 100.0f) + "%" : (string = (this.relativeWidthValue == (float)((int)this.relativeWidthValue) ? (int)this.relativeWidthValue + "" : this.relativeWidthValue + "") + "*");
            if (bl) {
                string = this.fixedWidthValue == (float)((int)this.fixedWidthValue) ? string + " + " + (int)this.fixedWidthValue + (Object)((Object)this.fixedWidthUnit) : string + " + " + this.fixedWidthValue + (Object)((Object)this.fixedWidthUnit);
            }
        } else if (bl) {
            string = this.fixedWidthValue == (float)((int)this.fixedWidthValue) ? String.valueOf((int)this.fixedWidthValue) + (Object)((Object)this.fixedWidthUnit) : String.valueOf(this.fixedWidthValue) + (Object)((Object)this.fixedWidthUnit);
        }
        return string;
    }

    public static enum Unit {
        CENTIMETER("cm"),
        EM("em"),
        EX("ex"),
        INCH("in"),
        MILLIMETER("mm"),
        PICA("pc"),
        PIXEL("px"),
        POINT("pt");

        private String unitRepresentation;

        private Unit(String string2) {
            this.unitRepresentation = string2;
        }

        public String toString() {
            return this.unitRepresentation;
        }
    }
}

