/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.EmptySequence;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ro.sync.ecss.dom.wrappers.mutable.AuthorSource;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableDOMNodeWrapper;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;

public class MutableNodeModelBuilder {
    private static final String SELECTION_PARAM = "selection";
    private static final String OXY_NAMESPACE = "http://www.oxygenxml.com/ns/xqu";
    private static final String OXY_PREFIX = "oxyxq";
    private static final Logger logger = Logger.getLogger((String)MutableNodeModelBuilder.class.getName());

    static NodeInfo build(AuthorSource authorSource, Configuration configuration) {
        Node node = authorSource.getNode();
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrap " + document));
        }
        DocumentWrapper documentWrapper = new DocumentWrapper(document, authorSource.getSystemId(), configuration);
        DOMNodeWrapper dOMNodeWrapper = documentWrapper.wrap(document);
        return dOMNodeWrapper;
    }

    public static DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        MutableDOMNodeWrapper mutableDOMNodeWrapper;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return documentWrapper;
            }
            case 1: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)1);
                break;
            }
            case 2: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)2);
                break;
            }
            case 3: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)3);
                break;
            }
            case 4: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)3);
                break;
            }
            case 8: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)8);
                break;
            }
            case 7: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)7);
                break;
            }
            case 5: {
                throw new IllegalStateException("DOM contains entity reference nodes, which Saxon does not support. The DOM should be built using the expandEntityReferences() option");
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        return mutableDOMNodeWrapper;
    }

    private static void setContextNode(AuthorAccess authorAccess, DocumentInfo documentInfo, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        String string;
        String string2 = MutableNodeModelBuilder.getLocationXpathExpression(authorAccess);
        NodeInfo nodeInfo = MutableNodeModelBuilder.getNodesByXPath(documentInfo, configuration, string2, string = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement().getNamespaceContext().getNamespaceForPrefix(""));
        if (nodeInfo != null) {
            dynamicQueryContext.setContextItem((Item)nodeInfo);
        } else {
            dynamicQueryContext.setContextItem((Item)documentInfo);
        }
    }

    private static String getLocationXpathExpression(AuthorAccess authorAccess) {
        if (authorAccess != null) {
            try {
                AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
                if (authorEditorAccess != null) {
                    int n2 = authorEditorAccess.getCaretOffset();
                    AuthorNode authorNode = authorEditorAccess.getFullySelectedNode();
                    if (authorNode != null) {
                        n2 = authorNode.getStartOffset() + 1;
                    }
                    return authorAccess.getDocumentController().getXPathExpression(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return null;
    }

    private static NodeInfo getNodesByXPath(DocumentInfo documentInfo, Configuration configuration, String string, String string2) {
        XdmNode xdmNode;
        block14: {
            xdmNode = null;
            if (string != null && string.trim().length() > 0) {
                Processor processor = new Processor(configuration);
                XPathCompiler xPathCompiler = processor.newXPathCompiler();
                if (string2 != null) {
                    xPathCompiler.declareNamespace("", string2);
                }
                DocumentBuilder documentBuilder = processor.newDocumentBuilder();
                XdmNode xdmNode2 = documentBuilder.wrap((Object)documentInfo);
                try {
                    XPathExecutable xPathExecutable = xPathCompiler.compile(string);
                    XPathSelector xPathSelector = xPathExecutable.load();
                    xPathSelector.setContextItem((XdmItem)xdmNode2);
                    Iterator iterator = xPathSelector.iterator();
                    if (iterator != null && iterator.hasNext()) {
                        XdmItem xdmItem = (XdmItem)iterator.next();
                        XdmNode xdmNode3 = null;
                        if (!xdmItem.isAtomicValue()) {
                            xdmNode3 = (XdmNode)xdmItem;
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Context expression: '" + string + "' returned an atomic value " + xdmItem));
                        }
                        if (xdmNode3 != null) {
                            xdmNode = xdmNode3;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Set context node: " + xdmNode3));
                            }
                        }
                        if (iterator.hasNext() && logger.isDebugEnabled()) {
                            logger.debug((Object)("Context expression: '" + string + "' returned more than one result: " + iterator.next()));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Context expression returned no results: " + string));
                    }
                }
                catch (SaxonApiException saxonApiException) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("Cannot evaluate context expression: " + string), (Throwable)saxonApiException);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("XPath: " + string + " mapped to: " + xdmNode));
        }
        return xdmNode != null ? xdmNode.getUnderlyingNode() : null;
    }

    private static void setSelectionContext(AuthorAccess authorAccess, DocumentInfo documentInfo, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        Object object;
        final ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        if (authorAccess != null) {
            Object object2;
            Object object3;
            Object object4;
            Iterator<ContentInterval> iterator;
            Object object5;
            object = new ArrayList();
            AuthorSelectionModel authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
            if (authorSelectionModel.hasSelection()) {
                object5 = authorSelectionModel.getSelectionIntervals();
                iterator = object5.iterator();
                while (iterator.hasNext()) {
                    Object object6;
                    object4 = iterator.next();
                    object3 = authorAccess.getEditorAccess().getBalancedSelection(((ContentInterval)object4).getStartOffset(), ((ContentInterval)object4).getEndOffset());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" Selection: " + object4));
                        logger.debug((Object)("  Balanced: " + object3[0] + ", " + object3[1]));
                    }
                    object2 = authorAccess.getEditorAccess().getFullySelectedNode(object3[0], object3[1]);
                    boolean bl = false;
                    if (object2 == null) {
                        try {
                            object6 = authorAccess.getDocumentController().getNodesToSelect(object3[0], object3[1]);
                            if (object6 != null) {
                                object.addAll(object6);
                                bl = true;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException, (Throwable)badLocationException);
                        }
                    }
                    if (!bl && object2 == null) {
                        try {
                            object6 = authorAccess.getDocumentController().getNodeAtOffset(object3[0]);
                            if (object6 != null && object6.getStartOffset() + 1 == object3[0] && object6.getEndOffset() == object3[1]) {
                                object2 = object6;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException, (Throwable)badLocationException);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" Selected node: " + object2));
                    }
                    if (bl || object2 == null) continue;
                    object.add(object2);
                }
            }
            object5 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement().getNamespaceContext().getNamespaceForPrefix("");
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object4 = (AuthorNode)((Object)iterator.next());
                try {
                    object3 = authorAccess.getDocumentController().getXPathExpression(object4.getStartOffset() + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" Computed XPath:" + (String)object3));
                    }
                    if ((object2 = MutableNodeModelBuilder.getNodesByXPath(documentInfo, configuration, (String)object3, (String)object5)) != null) {
                        arrayList.add((AuthorNode)object2);
                        continue;
                    }
                    logger.warn((Object)("Unable to compute Xpath expression for: " + object4));
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
        }
        object = EmptySequence.getInstance();
        if (arrayList.size() > 0) {
            object = new Sequence(){

                public SequenceIterator iterate() throws XPathException {
                    return new ListIterator(arrayList);
                }

                public Item head() throws XPathException {
                    return (Item)arrayList.get(0);
                }
            };
        }
        dynamicQueryContext.setParameter(new StructuredQName(OXY_PREFIX, OXY_NAMESPACE, SELECTION_PARAM), (Sequence)object);
    }

    public static void initializeQueryContext(AuthorSource authorSource, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        DocumentInfo documentInfo = (DocumentInfo)MutableNodeModelBuilder.build(authorSource, configuration);
        MutableNodeModelBuilder.setContextNode(authorSource.getAuthorAccess(), documentInfo, configuration, dynamicQueryContext);
        MutableNodeModelBuilder.setSelectionContext(authorSource.getAuthorAccess(), documentInfo, configuration, dynamicQueryContext);
    }
}

