/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import ro.sync.ecss.dom.wrappers.AuthorAttrDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorDocumentDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorNodeDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorTextNodeDomWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableNodeModelBuilder;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.exml.editor.xmleditor.prettyprint.k;
import ro.sync.util.Equaler;
import ro.sync.xml.XmlUtil;

public class MutableDOMNodeWrapper
extends DOMNodeWrapper
implements MutableNodeInfo {
    private static final Logger logger = Logger.getLogger((String)MutableDOMNodeWrapper.class.getName());
    private Boolean deleted;
    String newAttrName = null;

    protected MutableDOMNodeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        super(node, documentWrapper, dOMNodeWrapper, n2);
    }

    @Override
    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        return MutableNodeModelBuilder.makeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
    }

    public void setNodeKind(short s2) {
        this.nodeKind = s2;
    }

    public void setTypeAnnotation(int n2) {
    }

    public void removeTypeAnnotation() {
    }

    public void insertChildren(NodeInfo[] nodeInfoArray, boolean bl, boolean bl2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("insertChildren  " + Arrays.asList(nodeInfoArray)));
        }
        if (this.node.getNodeType() == 1 || this.node.getNodeType() == 9) {
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                AuthorDocumentController authorDocumentController = this.getController();
                int[] nArray = this.getNodeOffsets();
                int n2 = nArray[0] + 1;
                if (!bl) {
                    n2 = nArray[1];
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException xPathException) {
                throw new IllegalStateException("Failed", xPathException);
            }
            catch (AuthorOperationException authorOperationException) {
                throw new IllegalStateException("Failed", authorOperationException);
            }
        }
    }

    public void insertSiblings(NodeInfo[] nodeInfoArray, boolean bl, boolean bl2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("insertSiblings " + Arrays.asList(nodeInfoArray)));
        }
        if ((this.node.getNodeType() == 1 || this.node.getNodeType() == 3 || this.node.getNodeType() == 8 || this.node.getNodeType() == 7) && this.node.getParentNode() != null) {
            int[] nArray = this.getNodeOffsets();
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                AuthorDocumentController authorDocumentController = this.getController();
                int n2 = nArray[0];
                if (!bl) {
                    n2 = nArray[1] + 1;
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException xPathException) {
                throw new IllegalStateException("Failed: " + xPathException.getMessage(), xPathException);
            }
            catch (AuthorOperationException authorOperationException) {
                throw new IllegalStateException("Failed: " + authorOperationException.getMessage(), authorOperationException);
            }
        }
    }

    public void removeAttribute(NodeInfo nodeInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove @" + nodeInfo));
        }
        if (this.node.getNodeType() == 1) {
            AuthorDocumentController authorDocumentController = this.getController();
            AuthorElement authorElement = (AuthorElement)this.getAuthorNode();
            int n2 = this.getAttributeIndex(nodeInfo, authorElement);
            authorDocumentController.removeAttribute(authorElement.getAttributeAtIndex(n2), authorElement);
        } else {
            logger.warn((Object)("Unexpected remove attribute " + nodeInfo + " on " + this));
        }
    }

    private int getAttributeIndex(NodeInfo nodeInfo, AuthorElement authorElement) {
        String string = nodeInfo.getLocalPart();
        String string2 = nodeInfo.getURI();
        int n2 = authorElement.getAttributesCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = authorElement.getAttributeAtIndex(i2);
            String string4 = XmlUtil.getProxy(string3);
            String string5 = XmlUtil.getLocalName(string3);
            String string6 = authorElement.getAttributeNamespace(string4);
            if (!Equaler.verifyEquals(string5, string) || !Equaler.verifyEquals(string2, string6)) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public void addAttribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add @" + nodeName.getLocalPart() + " in " + this));
        }
        this.defineNamespace(nodeName, true);
        AuthorDocumentController authorDocumentController = this.getController();
        String string = this.getQName(nodeName);
        authorDocumentController.setAttribute(string, new AttrValue(String.valueOf(charSequence)), (AuthorElement)((AuthorNodeDomWrapper)this.node).getWrappedAuthorNode());
    }

    public void delete() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete " + this));
        }
        this.deleted = true;
        if (this.nodeKind == 2) {
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            AuthorDocumentController authorDocumentController = this.getController();
            authorDocumentController.removeAttribute(this.node.getNodeName(), (AuthorElement)((AuthorNodeDomWrapper)mutableDOMNodeWrapper.node).getWrappedAuthorNode());
        } else {
            AuthorDocumentController authorDocumentController = this.getController();
            int[] nArray = this.getNodeOffsets();
            authorDocumentController.delete(nArray[0], nArray[1]);
        }
    }

    private AuthorDocumentController getController() {
        AuthorNodeDomWrapper authorNodeDomWrapper = (AuthorNodeDomWrapper)this.node;
        if (this.nodeKind == 2) {
            authorNodeDomWrapper = (AuthorNodeDomWrapper)((MutableDOMNodeWrapper)this.getParent()).node;
        }
        AuthorDocumentDomWrapper authorDocumentDomWrapper = (AuthorDocumentDomWrapper)authorNodeDomWrapper.getOwnerDocument();
        return authorDocumentDomWrapper.getController();
    }

    public boolean isDeleted() {
        if (this.deleted == null) {
            if (this.getNodeKind() == 2) {
                String string;
                AuthorElement authorElement = (AuthorElement)this.getAuthorNode();
                this.deleted = authorElement.getAttribute(string = this.getRenameAwareAttributeName((Attr)this.node)) != null;
            } else {
                AuthorNode authorNode = this.getAuthorNode();
                boolean bl = authorNode.getStartOffset() == authorNode.getEndOffset() || authorNode.getOwnerDocument() == null;
                this.deleted = bl;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Is deleted " + this + " ? " + this.deleted));
        }
        return this.deleted;
    }

    public void replace(NodeInfo[] nodeInfoArray, boolean bl) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.node.getNodeType() == 2) {
            MutableNodeInfo mutableNodeInfo = (MutableNodeInfo)this.getParent();
            this.delete();
            for (NodeInfo nodeInfo : nodeInfoArray) {
                if (nodeInfo.getNodeKind() != 2) {
                    throw new IllegalArgumentException("Replacement nodes must be attributes");
                }
                mutableNodeInfo.addAttribute((NodeName)new NameOfNode(nodeInfo), (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, (CharSequence)nodeInfo.getStringValue(), 0);
            }
        } else {
            if (this.isDeleted()) {
                throw new IllegalStateException("Cannot replace a deleted node");
            }
            AuthorDocumentController authorDocumentController = this.getController();
            int[] nArray = this.getNodeOffsets();
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                int n2 = nArray[0];
                int n3 = nArray[1];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace " + this + " with " + string));
                    logger.debug((Object)("replace, step 1: Delete " + n2 + " , " + n3));
                }
                authorDocumentController.delete(n2, n3);
                this.deleted = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace, step 2: Insert at " + n2));
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException xPathException) {
                throw new IllegalStateException("Failed: " + xPathException.getMessage(), xPathException);
            }
            catch (AuthorOperationException authorOperationException) {
                throw new IllegalStateException("Failed: " + authorOperationException.getMessage(), authorOperationException);
            }
        }
    }

    public void replaceStringValue(CharSequence charSequence) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("string replace " + charSequence + " in " + this));
        }
        AuthorDocumentController authorDocumentController = this.getController();
        if (this.getNodeKind() == 1 || this.getNodeKind() == 8 || this.getNodeKind() == 4 || this.getNodeKind() == 7 || this.getNodeKind() == 3) {
            int[] nArray = this.getNodeOffsets();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (this.getNodeKind() == 3 || n2 + 1 < n3) {
                if (this.getNodeKind() == 3) {
                    authorDocumentController.delete(n2, n3);
                } else {
                    authorDocumentController.delete(n2 + 1, n3 - 1);
                }
            }
            String string = "";
            if (this.getNodeKind() == 7) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)this.node;
                string = processingInstruction.getTarget() + " " + String.valueOf(charSequence);
            } else {
                string = this.unescapeAMP(charSequence);
            }
            if (string.length() > 0) {
                if (this.getNodeKind() == 3) {
                    authorDocumentController.insertText(nArray[0], string);
                } else {
                    authorDocumentController.insertText(nArray[0] + 1, string);
                }
            }
        } else if (this.getNodeKind() == 2) {
            authorDocumentController.setAttribute(this.node.getNodeName(), new AttrValue(this.unescapeAMP(charSequence)), (AuthorElement)this.getAuthorNode());
        } else {
            logger.warn((Object)("Unexpected node type for replace string value: " + this));
        }
    }

    private String unescapeAMP(CharSequence charSequence) {
        String string = String.valueOf(charSequence);
        StringWriter stringWriter = new StringWriter();
        try {
            new k(stringWriter).write(string);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
        return string;
    }

    public void rename(NodeName nodeName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rename " + this + " to " + nodeName));
        }
        AuthorDocumentController authorDocumentController = this.getController();
        if (this.nodeKind == 2) {
            this.defineNamespace(nodeName, true);
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            AuthorElement authorElement = (AuthorElement)((AuthorNodeDomWrapper)mutableDOMNodeWrapper.node).getWrappedAuthorNode();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parent node: " + authorElement + " to remove " + this.getLocalPart()));
            }
            AuthorAttrDomWrapper authorAttrDomWrapper = (AuthorAttrDomWrapper)this.node;
            authorDocumentController.removeAttribute(this.getRenameAwareAttributeName(authorAttrDomWrapper), authorElement);
            authorDocumentController.setAttribute(this.getQName(nodeName), new AttrValue(this.getStringValue()), authorElement);
            this.newAttrName = this.getQName(nodeName);
        } else if (this.nodeKind == 1) {
            this.defineNamespace(nodeName, false);
            String string = nodeName.getLocalPart();
            String string2 = nodeName.getURI();
            if (string2 != null && string2.length() > 0) {
                string = nodeName.getDisplayName() + "#" + string2;
            }
            authorDocumentController.renameElement((AuthorElement)this.getAuthorNode(), string);
        } else if (this.nodeKind == 7) {
            int n2;
            ProcessingInstruction processingInstruction = (ProcessingInstruction)this.node;
            String string = processingInstruction.getData();
            int[] nArray = this.getNodeOffsets();
            int n3 = nArray[0];
            if (n3 + 1 < (n2 = nArray[1])) {
                authorDocumentController.delete(nArray[0] + 1, nArray[1] - 1);
            }
            authorDocumentController.insertText(n3 + 1, nodeName.getLocalPart() + " " + string);
        } else {
            logger.warn((Object)("Unexpected node type in rename: " + this));
        }
    }

    private String getRenameAwareAttributeName(Attr attr) {
        return this.newAttrName != null ? this.newAttrName : attr.getName();
    }

    private String getQName(NodeName nodeName) {
        String string = nodeName.getLocalPart();
        String string2 = nodeName.getPrefix();
        if (string2 != null && string2.length() > 0) {
            string = string2 + ":" + string;
        }
        return string;
    }

    private void defineNamespace(NodeName nodeName, boolean bl) {
        String string = nodeName.getPrefix();
        String string2 = nodeName.getURI();
        this.defineNamespace(bl, string, string2);
    }

    private void defineNamespace(boolean bl, String string, String string2) {
        String string3 = this.getNamespaceForPrefix(string, bl);
        if (string3 == null || !string3.equals(string2)) {
            if (string3 == null || string3.length() == 0) {
                this.addNamespaceMapping(string, string2);
            } else {
                throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding, new NS " + string2 + " old " + string3);
            }
        }
    }

    public void addNamespace(NamespaceBinding namespaceBinding, boolean bl) {
        this.defineNamespace(false, namespaceBinding.getPrefix(), namespaceBinding.getURI());
    }

    public Builder newBuilder() {
        LinkedTreeBuilder linkedTreeBuilder = new LinkedTreeBuilder(this.getDocumentRoot().getConfiguration().makePipelineConfiguration());
        linkedTreeBuilder.setAllocateSequenceNumbers(false);
        return linkedTreeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeAsXML(NodeInfo[] nodeInfoArray) throws XPathException {
        Configuration configuration = this.getDocumentRoot().getConfiguration();
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        SerializerFactory serializerFactory = configuration.getSerializerFactory();
        StringWriter stringWriter = new StringWriter();
        Properties properties = new Properties();
        properties.setProperty("indent", "no");
        properties.setProperty("omit-xml-declaration", "yes");
        Receiver receiver = serializerFactory.getReceiver((Result)new StreamResult(new k(stringWriter)), pipelineConfiguration, properties);
        try {
            for (int i2 = 0; i2 < nodeInfoArray.length; ++i2) {
                nodeInfoArray[i2].copy(receiver, 2, 0);
            }
        }
        finally {
            receiver.close();
        }
        return stringWriter.toString();
    }

    protected AuthorNode getAuthorNode() {
        Node node = this.node;
        if (this.nodeKind == 2) {
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            node = mutableDOMNodeWrapper.node;
        }
        return ((AuthorNodeDomWrapper)node).getWrappedAuthorNode();
    }

    private int[] getNodeOffsets() {
        AuthorNode authorNode = this.getAuthorNode();
        int n2 = authorNode.getStartOffset();
        int n3 = authorNode.getEndOffset();
        if (this.node.getNodeType() == 3) {
            n2 = ((AuthorTextNodeDomWrapper)this.node).getStart();
            n3 = ((AuthorTextNodeDomWrapper)this.node).getEnd();
        }
        return new int[]{n2, n3};
    }

    private String getNamespaceForPrefix(String string, boolean bl) {
        AuthorNode authorNode = this.getAuthorNode();
        NamespaceContext namespaceContext = authorNode.getNamespaceContext();
        if (string == null) {
            string = "";
        }
        String string2 = "";
        if (!bl || string.length() > 0) {
            string2 = namespaceContext.getNamespaceForPrefix(string);
        }
        if (string.length() == 0 && string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private void addNamespaceMapping(String string, String string2) {
        AuthorNode authorNode = this.getAuthorNode();
        if (authorNode.getType() == 0) {
            AuthorDocumentController authorDocumentController = this.getController();
            String string3 = "xmlns";
            if (string != null && string.length() > 0) {
                string3 = "xmlns:" + string;
            }
            authorDocumentController.setAttribute(string3, new AttrValue(string2), (AuthorElement)authorNode);
        }
    }

    public String toString() {
        AuthorNodeDomWrapper authorNodeDomWrapper = (AuthorNodeDomWrapper)this.node;
        AuthorNode authorNode = authorNodeDomWrapper.getWrappedAuthorNode();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nodeKind == 2) {
            stringBuilder.append("@").append(this.getLocalPart());
        } else {
            stringBuilder.append("'").append(authorNode.toString().replace('\u0000', 'X')).append("'");
            stringBuilder.append(" ").append(authorNode.getClass());
        }
        return stringBuilder.toString();
    }
}

