/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableDOMNodeWrapper;

public class DocumentWrapper
extends MutableDOMNodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    protected boolean domLevel3;
    private HashMap<String, Object> userData;

    public DocumentWrapper(Node node, String string, Configuration configuration) {
        super(node, null, null, 0);
        if (node.getNodeType() != 9 && node.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        this.node = node;
        this.nodeKind = (short)9;
        this.baseURI = string;
        this.docWrapper = this;
        this.domLevel3 = true;
        if (configuration.getExternalObjectModel(node.getClass()) == null) {
            throw new IllegalArgumentException("Node class " + node.getClass().getName() + " is not recognized in this Saxon configuration");
        }
        this.setConfiguration(configuration);
    }

    public DOMNodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        Document document = node.getOwnerDocument();
        if (document == this.node || this.domLevel3 && document != null && document.isSameNode(this.node)) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public String getSystemId() {
        return this.baseURI;
    }

    @Override
    public void setSystemId(String string) {
        this.baseURI = string;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = configuration.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setDOMLevel(int n2) {
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel3 = n2 == 3;
    }

    public int getDOMLevel() {
        return this.domLevel3 ? 3 : 2;
    }

    public boolean isTyped() {
        return false;
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInfo selectID(String string, boolean bl) {
        Node node = this.node;
        synchronized (node) {
            if (this.node instanceof Document) {
                Element element = ((Document)this.node).getElementById(string);
                if (element == null) {
                    return null;
                }
                return this.wrap(element);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        Node node = this.node;
        synchronized (node) {
            return nodeInfo instanceof DocumentWrapper && this.node == ((DocumentWrapper)nodeInfo).node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getUnparsedEntityNames() {
        Node node = this.node;
        synchronized (node) {
            DocumentType documentType = ((Document)this.node).getDoctype();
            if (documentType == null) {
                List list = Collections.emptyList();
                return list.iterator();
            }
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (namedNodeMap == null) {
                List list = Collections.emptyList();
                return list.iterator();
            }
            ArrayList<String> arrayList = new ArrayList<String>(namedNodeMap.getLength());
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Entity entity = (Entity)namedNodeMap.item(i2);
                if (entity.getNotationName() == null) continue;
                arrayList.add(entity.getLocalName());
            }
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUnparsedEntity(String string) {
        Node node = this.node;
        synchronized (node) {
            DocumentType documentType = ((Document)this.node).getDoctype();
            if (documentType == null) {
                return null;
            }
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (namedNodeMap == null) {
                return null;
            }
            Entity entity = (Entity)namedNodeMap.getNamedItem(string);
            if (entity == null || entity.getNotationName() == null) {
                return null;
            }
            String string2 = entity.getSystemId();
            try {
                URI uRI = new URI(string2);
                if (!uRI.isAbsolute()) {
                    String string3 = this.getBaseURI();
                    if (string3 != null) {
                        uRI = new URI(string3).resolve(uRI);
                        string2 = uRI.toString();
                    }
                    uRI = new URI(this.getBaseURI()).resolve(uRI);
                    string2 = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new String[]{string2, entity.getPublicId()};
        }
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    public synchronized void setUserData(String string, Object object) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (object == null) {
            this.userData.remove(string);
        } else {
            this.userData.put(string, object);
        }
    }

    public synchronized Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(string);
    }
}

