/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.util.ArrayList;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;

public class DOMNodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode,
SteppingNode<DOMNodeWrapper> {
    protected Node node;
    private int namecode = -1;
    protected short nodeKind;
    private DOMNodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;
    protected int span = 1;
    private NamespaceBinding[] localNamespaces = null;

    protected DOMNodeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        this.node = node;
        this.parent = dOMNodeWrapper;
        this.index = n2;
        this.docWrapper = documentWrapper;
    }

    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        if (node == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: Node must not be null");
        }
        if (documentWrapper == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: DocumentWrapper must not be null");
        }
        return this.makeWrapper(node, documentWrapper, null, -1);
    }

    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        DOMNodeWrapper dOMNodeWrapper2;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return documentWrapper;
            }
            case 1: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = 1;
                break;
            }
            case 2: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)2;
                break;
            }
            case 3: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 4: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 8: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)8;
                break;
            }
            case 7: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)7;
                break;
            }
            case 5: {
                throw new IllegalStateException("DOM contains entity reference nodes, which Saxon does not support. The DOM should be built using the expandEntityReferences() option");
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        return dOMNodeWrapper2;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof DOMNodeWrapper)) {
            return false;
        }
        if (this.docWrapper.domLevel3) {
            Node node = this.docWrapper.node;
            synchronized (node) {
                return this.node.isSameNode(((DOMNodeWrapper)nodeInfo).node);
            }
        }
        DOMNodeWrapper dOMNodeWrapper = (DOMNodeWrapper)nodeInfo;
        return this.getNodeKind() == dOMNodeWrapper.getNodeKind() && this.getNameCode() == dOMNodeWrapper.getNameCode() && this.getSiblingPosition() == dOMNodeWrapper.getSiblingPosition() && this.getParent().isSameNodeInfo(dOMNodeWrapper.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof DOMNodeWrapper && this.docWrapper.domLevel3) {
            if (this.isSameNodeInfo(nodeInfo)) {
                return 0;
            }
            try {
                Node node = this.docWrapper.node;
                synchronized (node) {
                    short s2 = this.node.compareDocumentPosition(((DOMNodeWrapper)nodeInfo).node);
                    if ((s2 & 0xA) != 0) {
                        return 1;
                    }
                    if ((s2 & 0x14) != 0) {
                        return -1;
                    }
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (nodeInfo instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)nodeInfo));
        }
        return -nodeInfo.compareOrder((NodeInfo)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int comparePosition(NodeInfo nodeInfo) {
        if (nodeInfo instanceof DOMNodeWrapper && this.docWrapper.domLevel3) {
            if (this.isSameNodeInfo(nodeInfo)) {
                return 12;
            }
            try {
                Node node = this.docWrapper.node;
                synchronized (node) {
                    short s2 = this.node.compareDocumentPosition(((DOMNodeWrapper)nodeInfo).node);
                    if ((s2 & 2) != 0) {
                        return 6;
                    }
                    if ((s2 & 4) != 0) {
                        return 10;
                    }
                    if ((s2 & 8) != 0) {
                        return 0;
                    }
                    if ((s2 & 0x10) != 0) {
                        return 4;
                    }
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return Navigator.comparePosition((NodeInfo)this, (NodeInfo)nodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getStringValueCS() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            switch (this.nodeKind) {
                case 1: 
                case 9: {
                    NodeList nodeList = this.node.getChildNodes();
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                    DOMNodeWrapper.expandStringValue(nodeList, fastStringBuffer);
                    return fastStringBuffer;
                }
                case 2: {
                    return DOMNodeWrapper.emptyIfNull(((Attr)this.node).getValue());
                }
                case 3: {
                    if (this.span == 1) {
                        return DOMNodeWrapper.emptyIfNull(this.node.getNodeValue());
                    }
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
                    Node node2 = this.node;
                    for (int i2 = 0; i2 < this.span; ++i2) {
                        fastStringBuffer.append(DOMNodeWrapper.emptyIfNull(node2.getNodeValue()));
                        node2 = node2.getNextSibling();
                    }
                    return fastStringBuffer.condense();
                }
                case 7: 
                case 8: {
                    return DOMNodeWrapper.emptyIfNull(this.node.getNodeValue());
                }
            }
            return "";
        }
    }

    private static String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    private static void expandStringValue(NodeList nodeList, FastStringBuffer fastStringBuffer) {
        int n2 = nodeList.getLength();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            switch (node.getNodeType()) {
                case 1: {
                    DOMNodeWrapper.expandStringValue(node.getChildNodes(), fastStringBuffer);
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 10: {
                    continue block5;
                }
                default: {
                    fastStringBuffer.append(node.getNodeValue());
                }
            }
        }
    }

    @Override
    public int getNameCode() {
        if (this.namecode != -1) {
            return this.namecode;
        }
        int n2 = this.getNodeKind();
        if (n2 == 1 || n2 == 2) {
            String string = this.getPrefix();
            if (string == null) {
                string = "";
            }
            this.namecode = this.docWrapper.getNamePool().allocate(string, this.getURI(), this.getLocalPart());
            return this.namecode;
        }
        if (n2 == 7) {
            this.namecode = this.docWrapper.getNamePool().allocate("", "", this.getLocalPart());
            return this.namecode;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalPart() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            switch (this.getNodeKind()) {
                case 1: 
                case 2: {
                    return DOMNodeWrapper.getLocalName(this.node);
                }
                case 7: {
                    return this.node.getNodeName();
                }
            }
            return null;
        }
    }

    public static String getLocalName(Node node) {
        String string = node.getLocalName();
        if (string == null) {
            String string2 = node.getNodeName();
            int n2 = string2.indexOf(58);
            if (n2 >= 0) {
                return string2.substring(n2 + 1);
            }
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURI() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            if (this.nodeKind == 1) {
                return DOMNodeWrapper.getElementURI((Element)this.node);
            }
            if (this.nodeKind == 2) {
                return DOMNodeWrapper.getAttributeURI((Attr)this.node);
            }
            return "";
        }
    }

    private static String getElementURI(Element element) {
        String string;
        String string2 = element.getNamespaceURI();
        if (string2 != null) {
            return string2;
        }
        String string3 = element.getNodeName();
        int n2 = string3.indexOf(58);
        String string4 = string = n2 < 0 ? "xmlns" : "xmlns:" + string3.substring(0, n2);
        if (string.equals("xmlns:xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Node node = element;
        do {
            if (!node.hasAttribute(string)) continue;
            return node.getAttribute(string);
        } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
        if (n2 < 0) {
            return "";
        }
        throw new IllegalStateException("Undeclared namespace prefix in element name " + string3 + " in DOM input");
    }

    private static String getAttributeURI(Attr attr) {
        String string = attr.getNamespaceURI();
        if (string != null) {
            return string;
        }
        String string2 = attr.getNodeName();
        int n2 = string2.indexOf(58);
        if (n2 < 0) {
            return "";
        }
        String string3 = "xmlns:" + string2.substring(0, n2);
        if (string3.equals("xmlns:xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Node node = attr.getOwnerElement();
        do {
            if (!node.hasAttribute(string3)) continue;
            return node.getAttribute(string3);
        } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
        throw new IllegalStateException("Undeclared namespace prefix in attribute name " + string2 + " in DOM input");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefix() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            int n2 = this.getNodeKind();
            if (n2 == 1 || n2 == 2) {
                String string = this.node.getNodeName();
                int n3 = string.indexOf(58);
                if (n3 < 0) {
                    return "";
                }
                return string.substring(0, n3);
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                Node node = this.docWrapper.node;
                synchronized (node) {
                    return this.node.getNodeName();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getParent() {
        if (this.parent == null) {
            Node node = this.docWrapper.node;
            synchronized (node) {
                switch (this.getNodeKind()) {
                    case 2: {
                        this.parent = this.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                        break;
                    }
                    default: {
                        Node node2 = this.node.getParentNode();
                        if (node2 == null) {
                            return null;
                        }
                        this.parent = this.makeWrapper(node2, this.docWrapper);
                    }
                }
            }
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSiblingPosition() {
        if (this.index == -1) {
            Node node = this.docWrapper.node;
            synchronized (node) {
                switch (this.nodeKind) {
                    case 1: 
                    case 3: 
                    case 7: 
                    case 8: {
                        int n2 = 0;
                        Node node2 = this.node;
                        while (true) {
                            if ((node2 = node2.getPreviousSibling()) == null) {
                                this.index = n2;
                                return n2;
                            }
                            ++n2;
                        }
                    }
                    case 2: {
                        int n3 = 0;
                        int n4 = this.getFingerprint();
                        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || nodeInfo.getFingerprint() == n4) {
                                this.index = n3;
                                return n3;
                            }
                            ++n3;
                        }
                    }
                    case 13: {
                        int n5 = 0;
                        int n6 = this.getFingerprint();
                        AxisIterator axisIterator = this.parent.iterateAxis((byte)8);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || nodeInfo.getFingerprint() == n6) {
                                this.index = n5;
                                return n5;
                            }
                            ++n5;
                        }
                    }
                }
                this.index = 0;
                return this.index;
            }
        }
        return this.index;
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        AttributeEnumeration attributeEnumeration = new AttributeEnumeration(this);
        if (nodeTest != AnyNodeTest.getInstance()) {
            attributeEnumeration = new Navigator.AxisFilter((AxisIterator)attributeEnumeration, nodeTest);
        }
        return attributeEnumeration;
    }

    @Override
    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        boolean bl = nodeTest.getNodeKindMask() == 2;
        Navigator.EmptyTextFilter emptyTextFilter = new Navigator.EmptyTextFilter((AxisIterator)new ChildEnumeration(this, true, true, bl));
        if (nodeTest != AnyNodeTest.getInstance()) {
            emptyTextFilter = new Navigator.AxisFilter((AxisIterator)emptyTextFilter, nodeTest);
        }
        return emptyTextFilter;
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean bl) {
        boolean bl2 = nodeTest.getNodeKindMask() == 2;
        Navigator.EmptyTextFilter emptyTextFilter = new Navigator.EmptyTextFilter((AxisIterator)new ChildEnumeration(this, false, bl, bl2));
        if (nodeTest != AnyNodeTest.getInstance()) {
            emptyTextFilter = new Navigator.AxisFilter((AxisIterator)emptyTextFilter, nodeTest);
        }
        return emptyTextFilter;
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean bl) {
        return new SteppingNavigator.DescendantAxisIterator((SteppingNode)this, bl, nodeTest);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        NameTest nameTest = new NameTest(2, string, string2, this.getNamePool());
        AxisIterator axisIterator = this.iterateAxis((byte)2, (NodeTest)nameTest);
        NodeInfo nodeInfo = axisIterator.next();
        if (nodeInfo == null) {
            return null;
        }
        return nodeInfo.getStringValue();
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildNodes() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            return this.node.getNodeType() != 2 && this.node.hasChildNodes();
        }
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)fastStringBuffer, (boolean)true);
    }

    @Override
    public long getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    @Override
    public void copy(Receiver receiver, int n2, int n3) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (int)n2, (int)n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        Node node = this.docWrapper.node;
        synchronized (node) {
            if (this.node.getNodeType() == 1) {
                if (this.localNamespaces != null) {
                    return this.localNamespaces;
                }
                Element element = (Element)this.node;
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap == null) {
                    this.localNamespaces = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                int n2 = 0;
                int n3 = namedNodeMap.getLength();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Attr attr = (Attr)namedNodeMap.item(i2);
                    String string = attr.getName();
                    if (string.equals("xmlns")) {
                        ++n2;
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    this.localNamespaces = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                NamespaceBinding[] namespaceBindingArray2 = namespaceBindingArray == null || n2 > namespaceBindingArray.length ? new NamespaceBinding[n2] : namespaceBindingArray;
                int n4 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string;
                    String string2;
                    Attr attr = (Attr)namedNodeMap.item(i3);
                    String string3 = attr.getName();
                    if (string3.equals("xmlns")) {
                        string2 = "";
                        string = attr.getValue();
                        namespaceBindingArray2[n4++] = new NamespaceBinding(string2, string);
                        continue;
                    }
                    if (!string3.startsWith("xmlns:")) continue;
                    string2 = string3.substring(6);
                    string = attr.getValue();
                    namespaceBindingArray2[n4++] = new NamespaceBinding(string2, string);
                }
                if (n2 < namespaceBindingArray2.length) {
                    namespaceBindingArray2[n2] = null;
                }
                this.localNamespaces = new NamespaceBinding[namespaceBindingArray2.length];
                System.arraycopy(namespaceBindingArray2, 0, this.localNamespaces, 0, namespaceBindingArray2.length);
                return namespaceBindingArray2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isId() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            return this.node instanceof Attr && ((Attr)this.node).isId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getNextSibling() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            Node node2 = this.node.getNextSibling();
            if (node2 != null) {
                if (node2.getNodeType() == 10) {
                    node2 = node2.getNextSibling();
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getFirstChild() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            Node node2 = this.node.getFirstChild();
            if (node2 != null) {
                if (node2.getNodeType() == 10) {
                    node2 = node2.getNextSibling();
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getPreviousSibling() {
        Node node = this.docWrapper.node;
        synchronized (node) {
            Node node2 = this.node.getPreviousSibling();
            if (node2 != null) {
                if (node2.getNodeType() == 10) {
                    return null;
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getSuccessorElement(DOMNodeWrapper dOMNodeWrapper, String string, String string2) {
        Node node = this.docWrapper.node;
        synchronized (node) {
            Node node2 = dOMNodeWrapper == null ? null : dOMNodeWrapper.node;
            Node node3 = this.node;
            while ((node3 = DOMNodeWrapper.getSuccessorNode(node3, node2)) != null && (node3.getNodeType() != 1 || string2 != null && !string2.equals(DOMNodeWrapper.getLocalName(node3)) || string != null && !string.equals(DOMNodeWrapper.getElementURI((Element)node3)))) {
            }
            if (node3 == null) {
                return null;
            }
            return this.makeWrapper(node3, this.docWrapper);
        }
    }

    private static Node getSuccessorNode(Node node, Node node2) {
        if (node.hasChildNodes()) {
            return node.getFirstChild();
        }
        if (node2 != null && node.isSameNode(node2)) {
            return null;
        }
        Node node3 = node;
        do {
            Node node4;
            if ((node4 = node3.getNextSibling()) == null) continue;
            return node4;
        } while ((node3 = node3.getParentNode()) != null && (node2 == null || !node3.isSameNode(node2)));
        return null;
    }

    private final class ChildEnumeration
    extends AxisIteratorImpl
    implements LookaheadIterator {
        private DOMNodeWrapper start;
        private DOMNodeWrapper commonParent;
        private boolean downwards;
        private boolean forwards;
        private boolean elementsOnly;
        NodeList childNodes;
        private int childNodesLength;
        private int ix;
        private int currentSpan;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildEnumeration(DOMNodeWrapper dOMNodeWrapper2, boolean bl, boolean bl2, boolean bl3) {
            Node node = dOMNodeWrapper2.docWrapper.node;
            synchronized (node) {
                this.start = dOMNodeWrapper2;
                this.downwards = bl;
                this.forwards = bl2;
                this.elementsOnly = bl3;
                this.currentSpan = 1;
                this.commonParent = bl ? dOMNodeWrapper2 : dOMNodeWrapper2.getParent();
                this.childNodes = this.commonParent.node.getChildNodes();
                this.childNodesLength = this.childNodes.getLength();
                if (bl) {
                    this.currentSpan = 1;
                    this.ix = bl2 ? -1 : this.childNodesLength;
                } else {
                    this.ix = dOMNodeWrapper2.getSiblingPosition();
                    this.currentSpan = dOMNodeWrapper2.span;
                }
            }
        }

        private int skipPrecedingTextNodes() {
            Node node;
            short s2;
            int n2;
            for (n2 = 0; this.ix >= n2 && ((s2 = (node = this.childNodes.item(this.ix - n2)).getNodeType()) == 3 || s2 == 4); ++n2) {
            }
            return n2 == 0 ? 1 : n2;
        }

        private int skipFollowingTextNodes() {
            Node node;
            short s2;
            int n2 = 0;
            int n3 = this.ix;
            int n4 = this.childNodesLength;
            while (n3 < n4 && ((s2 = (node = this.childNodes.item(n3)).getNodeType()) == 3 || s2 == 4)) {
                ++n3;
                ++n2;
            }
            return n2 == 0 ? 1 : n2;
        }

        public boolean hasNext() {
            if (this.forwards) {
                return this.ix + this.currentSpan < this.childNodesLength;
            }
            return this.ix > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NodeInfo next() {
            Node node = this.start.docWrapper.node;
            synchronized (node) {
                Node node2;
                block11: while (true) {
                    if (this.forwards) {
                        this.ix += this.currentSpan;
                        if (this.ix >= this.childNodesLength) {
                            return null;
                        }
                        this.currentSpan = this.skipFollowingTextNodes();
                        node2 = this.childNodes.item(this.ix);
                        switch (node2.getNodeType()) {
                            case 10: {
                                continue block11;
                            }
                            case 1: {
                                break;
                            }
                            default: {
                                if (this.elementsOnly) continue block11;
                            }
                        }
                        DOMNodeWrapper dOMNodeWrapper = DOMNodeWrapper.this.makeWrapper(node2, DOMNodeWrapper.this.docWrapper, this.commonParent, this.ix);
                        dOMNodeWrapper.span = this.currentSpan;
                        return dOMNodeWrapper;
                    }
                    --this.ix;
                    if (this.ix < 0) {
                        return null;
                    }
                    this.currentSpan = this.skipPrecedingTextNodes();
                    this.ix -= this.currentSpan - 1;
                    node2 = this.childNodes.item(this.ix);
                    switch (node2.getNodeType()) {
                        case 10: {
                            continue block11;
                        }
                        case 1: {
                            break block11;
                        }
                        default: {
                            if (!this.elementsOnly) break block11;
                            continue block11;
                        }
                    }
                    break;
                }
                DOMNodeWrapper dOMNodeWrapper = DOMNodeWrapper.this.makeWrapper(node2, DOMNodeWrapper.this.docWrapper, this.commonParent, this.ix);
                dOMNodeWrapper.span = this.currentSpan;
                return dOMNodeWrapper;
            }
        }

        public AxisIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards, this.elementsOnly);
        }

        public int getProperties() {
            return 4;
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private ArrayList<Node> attList = new ArrayList(10);
        private int ix = 0;
        private DOMNodeWrapper start;
        private DOMNodeWrapper current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeEnumeration(DOMNodeWrapper dOMNodeWrapper2) {
            Node node = dOMNodeWrapper2.docWrapper.node;
            synchronized (node) {
                this.start = dOMNodeWrapper2;
                NamedNodeMap namedNodeMap = dOMNodeWrapper2.node.getAttributes();
                if (namedNodeMap != null) {
                    int n2 = namedNodeMap.getLength();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = namedNodeMap.item(i2).getNodeName();
                        if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                        this.attList.add(namedNodeMap.item(i2));
                    }
                }
                this.ix = 0;
            }
        }

        public boolean hasNext() {
            return this.ix < this.attList.size();
        }

        public NodeInfo next() {
            if (this.ix >= this.attList.size()) {
                return null;
            }
            this.current = this.start.makeWrapper(this.attList.get(this.ix), DOMNodeWrapper.this.docWrapper, this.start, this.ix);
            ++this.ix;
            return this.current;
        }

        public void close() {
        }

        public AxisIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }

        public int getProperties() {
            return 4;
        }
    }
}

