/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.ecss.component.editor.ab;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.conditions.b.c;
import ro.sync.ecss.conditions.b.d;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.ui.application.e;
import ro.sync.ui.application.mc;
import ro.sync.ui.application.r;
import ro.sync.ui.pd;
import ro.sync.ui.theme.l;
import ro.sync.ui.theme.p;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class PopupListEditor
extends AbstractInplaceEditor {
    private static final Logger olf = Logger.getLogger((String)PopupListEditor.class.getName());
    private static final int llf = 5;
    private final JList jlf;
    private List<CIValue> nlf;
    private Map<CIValue, d> qlf;
    private mc flf;
    private KeyAdapter rlf;
    private FocusAdapter hlf;
    private ListSelectionListener elf;
    private MouseAdapter plf;
    private int glf;
    private java.awt.Font dlf;
    private List<String> ilf;
    private ab klf = new ab();
    private Comparator<CIValue> mlf = new Comparator<CIValue>(){

        public int b(CIValue cIValue, CIValue cIValue2) {
            return -PopupListEditor.this.klf.e(cIValue, cIValue2);
        }
    };

    public PopupListEditor() {
        this.jlf = new JList(new DefaultListModel()){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (PopupListEditor.this.glf >= 0) {
                    Rectangle rectangle = this.getCellBounds(PopupListEditor.this.glf, PopupListEditor.this.glf);
                    Color color = UIManager.getColor("List.selectionBackground");
                    if (color == null) {
                        color = l.e(p.getInstance().getTextBackgroundColor());
                    }
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 2);
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 1);
                }
            }

            @Override
            public JToolTip createToolTip() {
                ro.sync.ui.d.c c2 = new ro.sync.ui.d.c();
                c2.setComponent(this);
                return c2;
            }
        };
        this.jlf.getSelectionModel().setSelectionMode(0);
        this.dlf = this.jlf.getFont();
        this.jlf.setCellRenderer(new e(this.jlf.getCellRenderer()){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                d d2;
                String string = ((CIValue)object).getValue();
                if (PopupListEditor.this.ilf != null && !PopupListEditor.this.ilf.isEmpty()) {
                    string = (String)PopupListEditor.this.ilf.get(PopupListEditor.this.nlf.indexOf(object));
                }
                if (string == null || string.length() == 0) {
                    string = "[Empty]";
                }
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, string, n2, bl, bl2);
                if (PopupListEditor.this.qlf != null && (d2 = (d)PopupListEditor.this.qlf.get(object)) != null) {
                    JLabel jLabel = new JLabel(string){

                        @Override
                        public void paint(Graphics graphics) {
                            super.paint(graphics);
                            c.b(this, graphics, d2);
                        }
                    };
                    if (jComponent instanceof JLabel) {
                        jLabel.setFont(jComponent.getFont());
                        jLabel.setForeground(jComponent.getForeground());
                        jLabel.setBackground(jComponent.getBackground());
                    }
                    jLabel.setOpaque(true);
                    c.c(jLabel, d2, true);
                    jComponent = jLabel;
                }
                jComponent.setToolTipText(((CIValue)object).getAnnotation());
                jComponent.setBorder(r.l(jComponent.getBorder(), r.d(0, 5, 0, 5)));
                return jComponent;
            }
        });
        this.rlf = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    PopupListEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                    keyEvent.consume();
                    PopupListEditor.this.ncf(false, true);
                }
            }
        };
        this.hlf = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PopupListEditor.this.fireCommitValue(new EditingEvent((String)PopupListEditor.this.getValue()));
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PopupListEditor.this.jlf.ensureIndexIsVisible(PopupListEditor.this.jlf.getSelectedIndex());
            }
        };
        this.elf = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PopupListEditor.this.fireEditingOccured();
                }
            }
        };
        this.plf = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    PopupListEditor.this.stopEditing();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n2 = PopupListEditor.this.glf;
                PopupListEditor.this.glf = PopupListEditor.this.jlf.locationToIndex(mouseEvent.getPoint());
                if (PopupListEditor.this.glf != -1) {
                    PopupListEditor.this.jlf.repaint(PopupListEditor.this.jlf.getCellBounds(PopupListEditor.this.glf, PopupListEditor.this.glf));
                }
                if (PopupListEditor.this.glf != n2) {
                    PopupListEditor.this.jlf.repaint(PopupListEditor.this.jlf.getCellBounds(n2, n2));
                }
            }
        };
    }

    private void pcf(AuthorInplaceContext authorInplaceContext) {
        Font font;
        Object object;
        DefaultListModel defaultListModel = (DefaultListModel)this.jlf.getModel();
        defaultListModel.clear();
        this.nlf = (List)authorInplaceContext.getArguments().get("values");
        this.ilf = (List)authorInplaceContext.getArguments().get("labels");
        List list = (List)authorInplaceContext.getArguments().get("styles");
        if (list != null) {
            this.qlf = new HashMap<CIValue, d>();
            for (int i2 = 0; i2 < this.nlf.size(); ++i2) {
                object = null;
                if (i2 < list.size()) {
                    object = (d)list.get(i2);
                }
                this.qlf.put(this.nlf.get(i2), (d)object);
            }
        }
        if ((font = (Font)authorInplaceContext.getArguments().get("font")) != null) {
            this.jlf.setFont(new java.awt.Font(font.getName(), 0, font.getSize()));
        } else {
            this.jlf.setFont(this.dlf);
        }
        object = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (object != null) {
            this.jlf.setForeground(new Color(((ro.sync.exml.view.graphics.Color)object).getRed(), ((ro.sync.exml.view.graphics.Color)object).getGreen(), ((ro.sync.exml.view.graphics.Color)object).getBlue(), ((ro.sync.exml.view.graphics.Color)object).getAlpha()));
        }
        Object object2 = authorInplaceContext.getArguments().get("editorSort");
        this.klf.d(this.nlf);
        this.klf.b(this.ilf);
        if ("ascending".equals(object2)) {
            Collections.sort(this.nlf, this.klf);
            Collections.sort(this.ilf, db.c);
        } else if ("descending".equals(object2)) {
            Collections.sort(this.nlf, this.mlf);
            Collections.sort(this.ilf, db.b);
        }
        this.jlf.addKeyListener(this.rlf);
        this.jlf.addFocusListener(this.hlf);
        this.jlf.getSelectionModel().addListSelectionListener(this.elf);
        this.jlf.addMouseListener(this.plf);
        this.jlf.addMouseMotionListener(this.plf);
        Border border = r.d(5, 0, 5, 0);
        int n2 = db.d(authorInplaceContext);
        if (n2 > 0 && this.nlf.size() > n2) {
            this.flf = new mc(this.jlf, 20, 31);
            this.flf.getVerticalScrollBar().setBlockIncrement(5);
            this.flf.getVerticalScrollBar().setUnitIncrement(5);
            ArrayList<Component> arrayList = new ArrayList<Component>();
            arrayList.add(this.jlf);
            this.flf.setFocusTraversalPolicy(new pd(this.flf, arrayList, arrayList.isEmpty() ? null : (Component)arrayList.get(0), false));
            this.flf.setFocusTraversalPolicyProvider(true);
            this.jlf.setBorder(border);
        } else if (!p.getInstance().isHighContrastTheme()) {
            this.jlf.setBorder(r.l(r.e(l.e(p.getInstance().getTextForegroundColor()), 1), border));
        }
        this.ucf(authorInplaceContext, this.nlf, true);
    }

    private void ucf(AuthorInplaceContext authorInplaceContext, List<CIValue> list, boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)this.jlf.getModel();
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (olf.isDebugEnabled()) {
            olf.debug((Object)("initialValue " + string));
        }
        String string2 = (String)authorInplaceContext.getArguments().get("default_value");
        if (olf.isDebugEnabled()) {
            olf.debug((Object)("defaultValue " + string2));
        }
        CIValue cIValue = new CIValue(string != null ? string : string2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            CIValue cIValue2 = list.get(i2);
            if (bl) {
                defaultListModel.addElement(cIValue2);
            }
            if (!cIValue2.getInsertString().equals(cIValue)) continue;
            cIValue = cIValue2;
            if (!bl) break;
        }
        this.jlf.setSelectedValue(cIValue, true);
    }

    @Override
    public String getDescription() {
        return "A renderer that uses checkboxes to allow multiple selection.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.pcf(authorInplaceContext);
        Dimension dimension = null;
        if (this.flf != null && this.jlf.getModel().getSize() > 0) {
            Component component = this.jlf.getCellRenderer().getListCellRendererComponent(this.jlf, this.jlf.getModel().getElementAt(0), 0, false, false);
            Dimension dimension2 = component.getPreferredSize();
            dimension = this.jlf.getPreferredSize();
            int n2 = db.d(authorInplaceContext);
            dimension.height = dimension2.height * n2 + 10;
            dimension.width += this.flf.getVerticalScrollBar().getPreferredSize().width;
        } else {
            dimension = this.jlf.getPreferredSize();
        }
        if (point != null) {
            rectangle.x = point.x;
        }
        rectangle.y += rectangle.height;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        return this.flf != null ? this.flf : this.jlf;
    }

    @Override
    public void requestFocus() {
        this.jlf.requestFocus();
    }

    @Override
    public Object getValue() {
        String string = null;
        if (this.jlf.getSelectedIndex() != -1) {
            string = ((CIValue)this.jlf.getSelectedValue()).getInsertString();
        }
        return string;
    }

    @Override
    public void stopEditing() {
        this.ncf(true, false);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    private void ncf(boolean bl, boolean bl2) {
        this.jlf.removeKeyListener(this.rlf);
        this.jlf.removeFocusListener(this.hlf);
        this.jlf.getSelectionModel().removeListSelectionListener(this.elf);
        this.jlf.removeMouseListener(this.plf);
        this.jlf.removeMouseMotionListener(this.plf);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void cancelEditing() {
        this.jlf.removeKeyListener(this.rlf);
        this.jlf.removeFocusListener(this.hlf);
        this.jlf.getSelectionModel().removeListSelectionListener(this.elf);
        this.jlf.removeMouseListener(this.plf);
        this.jlf.removeMouseMotionListener(this.plf);
        this.fireEditingCanceled();
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.ucf(authorInplaceContext, this.nlf, false);
    }
}

