/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.css.sac.LexicalUnit;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.editor.ButtonEditor;
import ro.sync.ecss.component.editor.f;
import ro.sync.ecss.component.editor.h;
import ro.sync.ecss.css.functions.lb;
import ro.sync.ecss.extensions.api.AuthorExtensionActionProvider;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.IAuthorExtensionAction;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.exml.ic;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.ui.Icons;
import ro.sync.ui.application.d.q;
import ro.sync.ui.application.qb;
import ro.sync.ui.be;
import ro.sync.ui.d.c;
import ro.sync.util.PlatformDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ButtonGroupEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    private static final ic fmf = ro.sync.exml.q.e();
    private final JToggleButton gmf = new JToggleButton(){

        @Override
        public JToolTip createToolTip() {
            c c2 = new c();
            c2.setComponent(this);
            return c2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isContentAreaFilled() && (this.getModel().isRollover() || this.isSelected())) {
                ButtonEditor.kcf(graphics, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
        }
    };
    private final qb imf;
    private ActionListener dmf;
    private KeyListener jmf;
    private final java.awt.Font cmf = this.gmf.getFont();
    private final Color emf = this.gmf.getForeground();
    private Border hmf = this.gmf.getBorder();

    public ButtonGroupEditor() {
        this.imf = new qb(null, null);
        this.imf.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.gmf.setSelected(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.gmf.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                ButtonGroupEditor.this.gmf.setSelected(false);
            }
        });
    }

    @Override
    public String getDescription() {
        return "A button group that shows a popup to choose among several extension actions";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.ief(authorInplaceContext);
        return this.gmf;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.gmf.requestFocus();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void stopEditing() {
        this.imf.setVisible(false);
        this.fireEditingStopped(new EditingEvent((String)null));
    }

    @Override
    public void commitValue() {
        this.stopEditing();
    }

    @Override
    public void cancelEditing() {
        this.imf.setVisible(false);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.ief(authorInplaceContext);
        return this.gmf;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return null;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return this.bef(authorInplaceContext);
    }

    private java.awt.Font vdf(AuthorInplaceContext authorInplaceContext) {
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            return new java.awt.Font(font.getName(), font.getStyle(), font.getSize());
        }
        return this.cmf;
    }

    private Color rdf(AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return this.emf;
    }

    private Icon zdf(String string) throws FileNotFoundException {
        Icon icon = be.r(string);
        if (icon == null && (icon = be.h(string)) == null) {
            throw new FileNotFoundException("File " + string + " not found.");
        }
        return icon;
    }

    private Icon hef(AuthorInplaceContext authorInplaceContext) {
        Object object = authorInplaceContext.getArguments().get("icon");
        if (object instanceof String) {
            Icon icon;
            try {
                icon = this.zdf((String)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                icon = Icons.getIcon("/images/MissingProject10.png");
            }
            authorInplaceContext.getArguments().put("icon", icon);
            return icon;
        }
        return (Icon)object;
    }

    private String def(AuthorInplaceContext authorInplaceContext) {
        return (String)authorInplaceContext.getArguments().get("label");
    }

    private String bef(AuthorInplaceContext authorInplaceContext) {
        return (String)authorInplaceContext.getArguments().get("tooltip");
    }

    public static List<IAuthorExtensionAction> processActions(AuthorExtensionActionProvider authorExtensionActionProvider, String string) {
        ArrayList<IAuthorExtensionAction> arrayList = new ArrayList<IAuthorExtensionAction>();
        if (authorExtensionActionProvider != null) {
            for (String string2 : string.split(",")) {
                IAuthorExtensionAction iAuthorExtensionAction = authorExtensionActionProvider.getExtensionAction(string2 = string2.trim());
                if (iAuthorExtensionAction == null) {
                    iAuthorExtensionAction = new f(string2);
                }
                arrayList.add(iAuthorExtensionAction);
            }
        }
        return arrayList;
    }

    public static List<IAuthorExtensionAction> processActions(AuthorExtensionActionProvider authorExtensionActionProvider, List<LexicalUnit> list) {
        ArrayList<IAuthorExtensionAction> arrayList = new ArrayList<IAuthorExtensionAction>();
        if (authorExtensionActionProvider != null) {
            for (LexicalUnit lexicalUnit : list) {
                IAuthorExtensionAction iAuthorExtensionAction = null;
                if (lexicalUnit.getLexicalUnitType() != 114) continue;
                iAuthorExtensionAction = authorExtensionActionProvider.getExtensionAction((lb)lexicalUnit);
                if (iAuthorExtensionAction == null) {
                    String string = null;
                    if (lexicalUnit instanceof lb) {
                        lb lb2 = (lb)lexicalUnit;
                        Map<String, Object> map = lb2.d();
                        string = (String)map.get(lb.h);
                    }
                    if (string != null) {
                        iAuthorExtensionAction = new f(string);
                    }
                }
                arrayList.add(iAuthorExtensionAction);
            }
        }
        return arrayList;
    }

    private List<IAuthorExtensionAction> jef(AuthorInplaceContext authorInplaceContext) {
        List list = (List)authorInplaceContext.getArguments().get("actionIDs");
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static h._b processActionDisplayStyle(String string) {
        try {
            if (string.equals(string.toLowerCase())) {
                return h._b.valueOf(string.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid actionDisplayStyle value. Valid ones are: text, icon, both.");
    }

    private h._b ydf(AuthorInplaceContext authorInplaceContext) {
        h._b _b2 = (h._b)((Object)authorInplaceContext.getArguments().get("actionStyle"));
        return _b2 != null ? _b2 : h._b.b;
    }

    private void ief(final AuthorInplaceContext authorInplaceContext) {
        this.gmf.setFont(this.vdf(authorInplaceContext));
        this.gmf.setForeground(this.rdf(authorInplaceContext));
        Icon icon = this.hef(authorInplaceContext);
        this.gmf.setIcon(icon);
        this.gmf.setSelectedIcon(icon);
        this.gmf.setPressedIcon(icon);
        this.gmf.setDisabledIcon(q.b(icon));
        String string = this.def(authorInplaceContext);
        if (string != null) {
            this.gmf.setText(string);
        } else {
            this.gmf.setText(fmf.b("Unknown"));
        }
        this.gmf.setToolTipText(this.bef(authorInplaceContext));
        ButtonEditor.icf(this.gmf, authorInplaceContext, this.hmf);
        if (this.dmf != null) {
            this.gmf.removeActionListener(this.dmf);
        }
        if (this.jmf != null) {
            this.gmf.removeKeyListener(this.jmf);
        }
        this.dmf = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonGroupEditor.this.gef(authorInplaceContext);
            }
        };
        this.gmf.addActionListener(this.dmf);
        this.jmf = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    ButtonGroupEditor.this.fireEditingCanceled();
                } else if (keyEvent.getKeyCode() == 10) {
                    ButtonGroupEditor.this.gef(authorInplaceContext);
                }
            }
        };
        this.gmf.addKeyListener(this.jmf);
    }

    private void gef(AuthorInplaceContext authorInplaceContext) {
        this.imf.setFont(this.vdf(authorInplaceContext));
        this.imf.setForeground(this.rdf(authorInplaceContext));
        this.imf.removeAll();
        h._b _b2 = this.ydf(authorInplaceContext);
        if (_b2 != h._b.e) {
            for (IAuthorExtensionAction iAuthorExtensionAction : this.jef(authorInplaceContext)) {
                this.imf.add(new _b(iAuthorExtensionAction, _b2));
            }
        } else {
            Insets insets = new Insets(2, 2, 2, 2);
            int n2 = 0;
            int n3 = 0;
            for (IAuthorExtensionAction object2 : this.jef(authorInplaceContext)) {
                _b n5 = new _b(object2, _b2);
                if (_b2 == h._b.e) {
                    JMenuItem n6 = new JMenuItem(n5);
                    this.imf.add(n6);
                    n6.setHideActionText(true);
                    n6.setIconTextGap(0);
                    n6.setMargin(insets);
                    Insets insets2 = n6.getBorder().getBorderInsets(n6);
                    int n4 = insets2.left + insets.left + n6.getIcon().getIconWidth() + insets.right + insets2.right;
                    if (PlatformDetector.isMacOS()) {
                        n4 += 20;
                    }
                    n2 = Math.max(n2, n4);
                    n3 += insets2.top + insets.top + n6.getIcon().getIconHeight() + insets.bottom + insets2.bottom;
                    continue;
                }
                this.imf.add(n5);
            }
            Insets insets3 = this.imf.getMargin();
            Insets insets4 = this.imf.getBorder().getBorderInsets(this.imf);
            int n5 = insets4.left + insets3.left + n2 + insets3.right + insets4.right;
            int n6 = insets4.top + insets3.top + n3 + insets3.bottom + insets4.bottom;
            this.imf.setPreferredSize(new Dimension(n5, n6));
        }
        this.imf.show(this.gmf, 0, this.gmf.getBounds().height);
    }

    private static Icon wdf(IAuthorExtensionAction iAuthorExtensionAction, h._b _b2) {
        switch (_b2) {
            case e: 
            case d: {
                String string = (String)iAuthorExtensionAction.getValue("small_icon_path");
                Icon icon = be.r(string);
                if (icon == null && _b2 == h._b.e) {
                    icon = Icons.getIcon("/images/MissingProject10.png");
                }
                return icon;
            }
        }
        return null;
    }

    private static String eef(IAuthorExtensionAction iAuthorExtensionAction, h._b _b2) {
        switch (_b2) {
            case d: 
            case b: {
                String string = (String)iAuthorExtensionAction.getValue("action_name");
                assert (string != null);
                return string;
            }
        }
        return null;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.ief(authorInplaceContext);
        return ButtonEditor.hcf(this.gmf, authorInplaceContext);
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
    }

    private class _b
    extends AbstractAction {
        private IAuthorExtensionAction c;

        public _b(IAuthorExtensionAction iAuthorExtensionAction, h._b _b2) {
            super(ButtonGroupEditor.eef(iAuthorExtensionAction, _b2), ButtonGroupEditor.wdf(iAuthorExtensionAction, _b2));
            this.putValue("ShortDescription", iAuthorExtensionAction.getValue("description"));
            this.c = iAuthorExtensionAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ButtonGroupEditor.this.fireEditingStopped(new EditingEvent(this.c));
            ButtonGroupEditor.this.imf.setVisible(false);
        }
    }
}

