/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.IAuthorExtensionAction;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.ic;
import ro.sync.exml.v;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.ui.application.d.q;
import ro.sync.ui.application.r;
import ro.sync.ui.be;
import ro.sync.ui.d.c;
import ro.sync.ui.theme.l;
import ro.sync.ui.theme.p;
import ro.sync.util.PlatformDetector;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ButtonEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    protected static final ic messages = ro.sync.exml.q.e();
    JButton ykf;
    private ActionListener blf;
    private KeyListener xkf;
    private final java.awt.Font alf;
    private Border wkf;
    private Color clf;
    private Map<String, Icon> zkf = new HashMap<String, Icon>();

    public ButtonEditor() {
        this.ykf = new JButton(){

            @Override
            public JToolTip createToolTip() {
                c c2 = new c();
                c2.setComponent(this);
                return c2;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (!this.isContentAreaFilled() && this.getModel().isRollover()) {
                    ButtonEditor.kcf(graphics, this.getWidth(), this.getHeight());
                }
                super.paintComponent(graphics);
                if (!this.isContentAreaFilled() && this.isFocusOwner()) {
                    ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        };
        this.alf = this.ykf.getFont();
        this.clf = this.ykf.getForeground();
        this.wkf = this.ykf.getBorder();
    }

    static void kcf(Graphics graphics, int n2, int n3) {
        graphics.setColor(new Color(255, 232, 118));
        graphics.fillRect(0, 0, n2 - 1, n3 - 1);
        graphics.setColor(l.e(p.getInstance().getTextBackgroundColor()));
        graphics.drawRect(0, 0, n2 - 1, n3 - 1);
    }

    static void icf(AbstractButton abstractButton, AuthorInplaceContext authorInplaceContext, Border border) {
        boolean bl;
        boolean bl2;
        abstractButton.getModel().setRollover(authorInplaceContext.getRelativeMouseLocation() != null);
        boolean bl3 = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl3 = Platform.STANDALONE.equals((Object)authorInplaceContext.getAuthorAccess().getWorkspaceAccess().getPlatform());
        }
        boolean bl4 = Boolean.TRUE.equals(authorInplaceContext.getArguments().get("transparent"));
        boolean bl5 = bl2 = PlatformDetector.isMacOS() && !bl3;
        if (bl2) {
            bl4 = false;
        }
        boolean bl6 = bl = !bl4;
        if (PlatformDetector.isMacOS()) {
            bl = false;
        }
        abstractButton.setOpaque(bl);
        Border border2 = border;
        if (bl4) {
            if (PlatformDetector.isWin32()) {
                border2 = abstractButton.getIcon() == null ? r.d(3, 4, 3, 4) : r.d(1, 2, 1, 2);
            } else if (PlatformDetector.isMacOS()) {
                border2 = r.d(1, 1, 1, 1);
            }
            abstractButton.setFocusPainted(false);
            abstractButton.setContentAreaFilled(false);
            if (!PlatformDetector.isMacOS()) {
                abstractButton.setBorderPainted(false);
            }
        } else {
            abstractButton.setFocusPainted(true);
            abstractButton.setContentAreaFilled(true);
            if (!PlatformDetector.isMacOS()) {
                abstractButton.setBorderPainted(true);
            }
        }
        abstractButton.setBorder(border2);
        AuthorNode authorNode = authorInplaceContext.getElem();
        if (authorNode.getType() == 6) {
            authorNode = authorNode.getParent();
        }
        if (authorInplaceContext.getAuthorAccess() != null) {
            boolean bl7;
            AuthorDocumentController authorDocumentController = authorInplaceContext.getAuthorAccess().getDocumentController();
            boolean bl8 = bl7 = authorDocumentController.isEditable(authorNode) && authorInplaceContext.getAuthorAccess().getEditorAccess().isEditable();
            if (!bl7) {
                Object object = authorInplaceContext.getArguments().get("enableInReadOnlyContext");
                bl7 = "true".equals(object);
            }
            abstractButton.setEnabled(bl7);
        }
    }

    void gcf(AuthorInplaceContext authorInplaceContext) {
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.ykf.setFont(new java.awt.Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.ykf.setFont(this.alf);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.ykf.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.ykf.setForeground(this.clf);
        }
        final Object object = authorInplaceContext.getArguments().get("actionID");
        IAuthorExtensionAction iAuthorExtensionAction = null;
        if (object instanceof IAuthorExtensionAction) {
            iAuthorExtensionAction = (IAuthorExtensionAction)object;
        }
        final IAuthorExtensionAction iAuthorExtensionAction2 = iAuthorExtensionAction;
        if (this.blf != null) {
            this.ykf.removeActionListener(this.blf);
        }
        if (this.xkf != null) {
            this.ykf.removeKeyListener(this.xkf);
        }
        if (iAuthorExtensionAction2 != null) {
            String string;
            Object object2;
            String string2 = (String)iAuthorExtensionAction2.getValue("description");
            Icon icon = null;
            Boolean bl = this.getBoolean(authorInplaceContext, "showIcon");
            if ((bl == null || bl.booleanValue()) && (icon = this.zkf.get(object2 = (String)iAuthorExtensionAction2.getValue("small_icon_path"))) == null) {
                icon = be.t((String)object2, false);
                if (icon == null) {
                    string = (String)iAuthorExtensionAction2.getValue("large_icon_path");
                    icon = this.zkf.get(string);
                    if (icon == null && (icon = be.h(string)) != null) {
                        this.zkf.put(string, icon);
                    }
                } else {
                    this.zkf.put((String)object2, icon);
                }
            }
            this.ykf.setIcon(icon);
            this.ykf.setSelectedIcon(icon);
            this.ykf.setPressedIcon(icon);
            this.ykf.setDisabledIcon(q.b(icon));
            object2 = this.getBoolean(authorInplaceContext, "showText");
            string = null;
            if (icon == null || Boolean.TRUE.equals(object2)) {
                string = (String)iAuthorExtensionAction2.getValue("action_name");
            }
            this.ykf.setText(string);
            this.ykf.setToolTipText(string2);
            this.blf = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonEditor.this.fireEditingStopped(new EditingEvent(iAuthorExtensionAction2));
                }
            };
        } else {
            this.ykf.setIcon(null);
            this.ykf.setText(messages.b("Unknown"));
            this.ykf.setToolTipText("Unknown action");
            this.blf = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    v.getInstance().showErrorMessage("Unknown action ID: " + String.valueOf(object) + ". The document must have an associated Document Type in which an action with the given ID must be declared.");
                    ButtonEditor.this.fireEditingStopped(new EditingEvent((String)null));
                }
            };
        }
        this.ykf.addActionListener(this.blf);
        this.xkf = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    ButtonEditor.this.fireEditingCanceled();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    ButtonEditor.this.fireEditingStopped(new EditingEvent(iAuthorExtensionAction2));
                }
            }
        };
        this.ykf.addKeyListener(this.xkf);
        ButtonEditor.icf(this.ykf, authorInplaceContext, this.wkf);
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.gcf(authorInplaceContext);
        return this.ykf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RendererLayoutInfo hcf(AbstractButton abstractButton, AuthorInplaceContext authorInplaceContext) {
        boolean bl = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl = Platform.STANDALONE.equals((Object)authorInplaceContext.getAuthorAccess().getWorkspaceAccess().getPlatform());
        }
        int n2 = 0;
        if (!bl && PlatformDetector.isMacOS() && abstractButton.getIcon() != null) {
            n2 = 5;
        }
        Dimension dimension = abstractButton.getPreferredSize();
        String string = abstractButton.getText();
        int n3 = -1;
        if (string == null || string.length() == 0) {
            try {
                abstractButton.setText(" ");
                n3 = abstractButton.getBaseline(dimension.width, dimension.height);
            }
            finally {
                abstractButton.setText(string);
            }
        } else {
            n3 = abstractButton.getBaseline(dimension.width, dimension.height);
        }
        return new RendererLayoutInfo(n3, new ro.sync.exml.view.graphics.Dimension(dimension.width + n2, dimension.height + n2));
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.gcf(authorInplaceContext);
        return ButtonEditor.hcf(this.ykf, authorInplaceContext);
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.gcf(authorInplaceContext);
        return this.ykf;
    }

    @Override
    public void requestFocus() {
        this.ykf.requestFocus();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void stopEditing() {
        this.fireEditingStopped(new EditingEvent((String)null));
    }

    @Override
    public void commitValue() {
        this.stopEditing();
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public String getDescription() {
        return "A button linked to an author extension action";
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.gcf(authorInplaceContext);
        return this.ykf.getToolTipText();
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
    }
}

