/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;
import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.DescendantSelector;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.SimpleSelector;
import org.w3c.flute.css.sac.SubjectSelector;
import org.w3c.flute.parser.selectors.AbstractLocalizableSelector;

public class DescendantSelectorImpl
extends AbstractLocalizableSelector
implements DescendantSelector {
    private Selector ancestorSelector;
    private SimpleSelector simpleSelector;
    private boolean isSubject;
    private boolean hasSubject;

    @Override
    public short getSelectorType() {
        return 10;
    }

    public DescendantSelectorImpl(Selector selector, SimpleSelector simpleSelector, boolean bl, Locator locator) {
        super(locator);
        this.ancestorSelector = selector;
        this.simpleSelector = simpleSelector;
        this.isSubject = bl;
        this.hasSubject = bl || selector instanceof SubjectSelector && ((SubjectSelector)selector).hasSubject();
    }

    @Override
    public Selector getAncestorSelector() {
        return this.ancestorSelector;
    }

    @Override
    public SimpleSelector getSimpleSelector() {
        return this.simpleSelector;
    }

    @Override
    public boolean isSubject() {
        return this.isSubject;
    }

    @Override
    public boolean hasSubject() {
        return this.hasSubject;
    }

    @Override
    public Selector getSubjectAncestorSelector() {
        if (this.hasSubject()) {
            SubjectSelector subjectSelector = this;
            while (!subjectSelector.isSubject()) {
                subjectSelector = (SubjectSelector)((DescendantSelector)subjectSelector).getAncestorSelector();
            }
            return subjectSelector;
        }
        return null;
    }

    @Override
    public int getDepth() {
        return this.getDepth(this);
    }

    private int getDepth(DescendantSelector descendantSelector) {
        Selector selector;
        int n2 = 1;
        if (descendantSelector != null && (selector = descendantSelector.getAncestorSelector()) instanceof DescendantSelector) {
            n2 = this.getDepth((DescendantSelector)selector) + 1;
        }
        return n2;
    }

    @Override
    public void setIsSubject(boolean bl) {
        this.isSubject = bl;
    }

    @Override
    public String getSerialization(Map<String, String> map) {
        return this.getSerialization(" ", map);
    }

    protected String getSerialization(String string, Map<String, String> map) {
        return this.ancestorSelector.getSerialization(map) + string + this.simpleSelector.getSerialization(map) + (this.isSubject ? "!" : "");
    }
}

