/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.flute.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.flute.parser.MediaFeatureExpression;

public class MediaQuery {
    private final int definedInLine;
    private final int definedInColumn;
    private final MediaQueryPrefix prefix;
    private String mediaType;
    private final Set<MediaFeatureExpression> mediaFeatureExpresions;

    public MediaQuery(String string) {
        this(string, -1, -1);
    }

    public MediaQuery(String string, int n2, int n3) {
        this(null, string, n2, n3);
    }

    public MediaQuery(MediaQueryPrefix mediaQueryPrefix, String string, int n2, int n3) {
        this.definedInLine = n2;
        this.definedInColumn = n3;
        this.mediaType = string;
        this.mediaFeatureExpresions = new LinkedHashSet<MediaFeatureExpression>();
        this.prefix = mediaQueryPrefix;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void addMediaFeatureExpression(MediaFeatureExpression mediaFeatureExpression) {
        this.mediaFeatureExpresions.add(mediaFeatureExpression);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix != null) {
            stringBuilder.append((Object)((Object)this.prefix) + " ");
        }
        stringBuilder.append(this.mediaType);
        for (MediaFeatureExpression mediaFeatureExpression : this.mediaFeatureExpresions) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(mediaFeatureExpression);
        }
        return stringBuilder.toString();
    }

    public MediaQuery clone() {
        MediaQuery mediaQuery = new MediaQuery(this.prefix, this.mediaType, this.getLine(), this.getColumn());
        for (MediaFeatureExpression mediaFeatureExpression : this.mediaFeatureExpresions) {
            mediaQuery.mediaFeatureExpresions.add(mediaFeatureExpression.clone());
        }
        return mediaQuery;
    }

    public int getLine() {
        return this.definedInLine;
    }

    public int getColumn() {
        return this.definedInColumn;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.definedInColumn;
        n2 = 31 * n2 + this.definedInLine;
        n2 = 31 * n2 + (this.mediaFeatureExpresions == null ? 0 : ((Object)this.mediaFeatureExpresions).hashCode());
        n2 = 31 * n2 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        n2 = 31 * n2 + (this.prefix == null ? 0 : this.prefix.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MediaQuery mediaQuery = (MediaQuery)object;
        if (this.definedInColumn != mediaQuery.definedInColumn) {
            return false;
        }
        if (this.definedInLine != mediaQuery.definedInLine) {
            return false;
        }
        if (this.mediaType == null ? mediaQuery.mediaType != null : !this.mediaType.equals(mediaQuery.mediaType)) {
            return false;
        }
        if (this.prefix != mediaQuery.prefix) {
            return false;
        }
        return !(this.mediaFeatureExpresions == null ? mediaQuery.mediaFeatureExpresions != null : !((Object)this.mediaFeatureExpresions).equals(mediaQuery.mediaFeatureExpresions));
    }

    public Set<MediaFeatureExpression> getMediaFeatureExpresions() {
        return this.mediaFeatureExpresions;
    }

    public static enum MediaQueryPrefix {
        NOT,
        ONLY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

