/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import org.apache.xerces.impl.xs.traversers.DOMOverrideImpl;
import org.apache.xerces.impl.xs.traversers.OverrideTransformationManager;
import org.apache.xerces.impl.xs.traversers.OverrideTransformer;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAttributeGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAttributeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDComplexTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDElementTraverser;
import org.apache.xerces.impl.xs.traversers.XSDGroupTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandlerXerces;
import org.apache.xerces.impl.xs.traversers.XSDKeyrefTraverser;
import org.apache.xerces.impl.xs.traversers.XSDNotationTraverser;
import org.apache.xerces.impl.xs.traversers.XSDSimpleTypeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDTypeAlternativeTraverser;
import org.apache.xerces.impl.xs.traversers.XSDUniqueOrKeyTraverser;
import org.apache.xerces.impl.xs.traversers.XSDWildcardTraverser;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Element;
import ro.sync.exml.n.c.u;

public class XSDHandler
extends XSDHandlerXerces {
    private static Logger logger = Logger.getLogger((String)XSDHandler.class.getName());
    private XMLLocator locator;

    public XSDHandler(short s2, XSConstraints xSConstraints) {
        this.fSchemaVersion = s2;
        this.fXSConstraints = xSConstraints;
        this.fHiddenNodes = new Hashtable();
        SchemaParsingConfig schemaParsingConfig = new SchemaParsingConfig();
        this.fSchemaParser = new SchemaDOMParser((XMLParserConfiguration)schemaParsingConfig);
        this.fSchemaParser.setSupportedVersion(this.fSupportedVersion);
        XMLEntityManager xMLEntityManager = (XMLEntityManager)schemaParsingConfig.getProperty("http://apache.org/xml/properties/internal/entity-manager");
        this.locator = xMLEntityManager.getEntityScanner();
    }

    public XSDHandler(XSGrammarBucket xSGrammarBucket, short s2, XSConstraints xSConstraints) {
        this(s2, xSConstraints);
        this.fGrammarBucket = xSGrammarBucket;
        this.fSchemaGrammarDescription = new XSDDescription();
    }

    @Override
    protected void createTraversers() {
        this.fAttributeChecker = new XSAttributeChecker(this);
        this.fAttributeGroupTraverser = new XSDAttributeGroupTraverser(this, this.fAttributeChecker);
        this.fAttributeTraverser = new XSDAttributeTraverser(this, this.fAttributeChecker);
        this.fComplexTypeTraverser = new XSDComplexTypeTraverser(this, this.fAttributeChecker);
        this.fElementTraverser = new XSDElementTraverser(this, this.fAttributeChecker);
        this.fGroupTraverser = new XSDGroupTraverser(this, this.fAttributeChecker);
        this.fKeyrefTraverser = new XSDKeyrefTraverser(this, this.fAttributeChecker);
        this.fNotationTraverser = new XSDNotationTraverser(this, this.fAttributeChecker);
        this.fSimpleTypeTraverser = new XSDSimpleTypeTraverser(this, this.fAttributeChecker);
        this.fUniqueOrKeyTraverser = new XSDUniqueOrKeyTraverser(this, this.fAttributeChecker);
        this.fWildCardTraverser = new XSDWildcardTraverser(this, this.fAttributeChecker);
    }

    @Override
    protected void createXSD11Traversers() {
        this.fTypeAlternativeTraverser = new XSDTypeAlternativeTraverser(this, this.fAttributeChecker);
    }

    @Override
    void reportSchemaError(String string, Object[] objectArray, Element element, Exception exception) {
        if (this.fErrorReporter instanceof u) {
            if (element instanceof ElementImpl) {
                u u2 = (u)this.fErrorReporter;
                u2.e((ElementImpl)((Object)element));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("The element is not instance of ElementImpl " + element));
            }
        }
        super.reportSchemaError(string, objectArray, element, exception);
    }

    @Override
    void reportSchemaWarning(String string, Object[] objectArray, Element element, Exception exception) {
        if (this.fErrorReporter instanceof u) {
            if (element instanceof ElementImpl) {
                u u2 = (u)this.fErrorReporter;
                u2.e((ElementImpl)((Object)element));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("The element is not instance of ElementImpl " + element));
            }
        }
        super.reportSchemaWarning(string, objectArray, element, exception);
    }

    @Override
    public void reset(XMLComponentManager xMLComponentManager) {
        super.reset(xMLComponentManager);
        XMLErrorReporter xMLErrorReporter = (XMLErrorReporter)this.fSchemaParser.getProperty("http://apache.org/xml/properties/internal/error-reporter");
        if (xMLErrorReporter != null) {
            Locale locale;
            MessageFormatter messageFormatter = xMLErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            if (messageFormatter != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", messageFormatter);
            }
            if ((messageFormatter = xMLErrorReporter.getMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114")) != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", messageFormatter);
            }
            if ((messageFormatter = xMLErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1")) != null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", messageFormatter);
            }
            if ((locale = xMLErrorReporter.getLocale()) != null) {
                this.fErrorReporter.setLocale(locale);
            }
        }
        if (this.fErrorReporter instanceof u && this.locator != null) {
            this.fErrorReporter.setDocumentLocator(this.locator);
        }
        this.fSchemaParser.setProperty("http://apache.org/xml/properties/internal/error-reporter", this.fErrorReporter);
    }

    @Override
    public void setSchemaVersionInfo(short s2, XSConstraints xSConstraints) {
        super.setSchemaVersionInfo(s2, xSConstraints);
        if (s2 >= 4 && this.fOverrideHandler == null) {
            this.fOverrideHandler = new OverrideTransformationManager(this, (OverrideTransformer)new DOMOverrideImpl(this));
        }
    }
}

