/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XS10Constraints;
import org.apache.xerces.impl.xs.XS11Constraints;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import ro.sync.exml.n.c.u;

public abstract class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.getS4SGrammar((short)1).getGlobalTypeDecl("string");
    private static XSParticleDecl fEmptyParticle = null;
    static final XSConstraints XS_1_0_CONSTRAINTS = new XS10Constraints(1);
    static final XSConstraints XS_1_0_CONSTRAINTS_EXTENDED = new XS10Constraints(2);
    static final XSConstraints XS_1_1_CONSTRAINTS = new XS11Constraints();
    private final XSComplexTypeDecl fAnyType;
    protected final short fSchemaVersion;
    private static Logger logger = Logger.getLogger((String)XSConstraints.class.getName());

    public static XSParticleDecl getEmptySequence() {
        if (fEmptyParticle == null) {
            XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
            xSModelGroupImpl.fCompositor = (short)102;
            xSModelGroupImpl.fParticleCount = 0;
            xSModelGroupImpl.fParticles = null;
            xSModelGroupImpl.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            XSParticleDecl xSParticleDecl = new XSParticleDecl();
            xSParticleDecl.fType = (short)3;
            xSParticleDecl.fValue = xSModelGroupImpl;
            xSParticleDecl.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            fEmptyParticle = xSParticleDecl;
        }
        return fEmptyParticle;
    }

    protected XSConstraints(XSComplexTypeDecl xSComplexTypeDecl, short s2) {
        this.fAnyType = xSComplexTypeDecl;
        this.fSchemaVersion = s2;
    }

    public final short getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public boolean isTypeTablesEquivalent(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        return true;
    }

    public boolean checkTypeDerivationOk(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s2) {
        if (xSTypeDefinition == this.fAnyType) {
            return xSTypeDefinition == xSTypeDefinition2;
        }
        if (xSTypeDefinition == SchemaGrammar.fAnySimpleType) {
            return xSTypeDefinition2 == this.fAnyType || xSTypeDefinition2 == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDefinition.getTypeCategory() == 16) {
            if (xSTypeDefinition2.getTypeCategory() == 15) {
                if (xSTypeDefinition2 == this.fAnyType) {
                    xSTypeDefinition2 = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)xSTypeDefinition, (XSSimpleType)xSTypeDefinition2, s2);
        }
        return this.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition, xSTypeDefinition2, s2);
    }

    public boolean checkSimpleDerivationOk(XSSimpleType xSSimpleType, XSTypeDefinition xSTypeDefinition, short s2) {
        if (xSSimpleType == SchemaGrammar.fAnySimpleType) {
            return xSTypeDefinition == this.fAnyType || xSTypeDefinition == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDefinition.getTypeCategory() == 15) {
            if (xSTypeDefinition == this.fAnyType) {
                xSTypeDefinition = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return this.checkSimpleDerivation(xSSimpleType, (XSSimpleType)xSTypeDefinition, s2);
    }

    public boolean checkComplexDerivationOk(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDefinition xSTypeDefinition, short s2) {
        if (xSComplexTypeDecl == this.fAnyType) {
            return xSComplexTypeDecl == xSTypeDefinition;
        }
        return this.checkComplexDerivation(xSComplexTypeDecl, xSTypeDefinition, s2);
    }

    private boolean checkSimpleDerivation(XSSimpleType xSSimpleType, XSSimpleType xSSimpleType2, short s2) {
        if (xSSimpleType == xSSimpleType2) {
            return true;
        }
        if ((s2 & 2) != 0 || (xSSimpleType.getBaseType().getFinal() & 2) != 0) {
            return false;
        }
        XSSimpleType xSSimpleType3 = (XSSimpleType)xSSimpleType.getBaseType();
        if (xSSimpleType3 == xSSimpleType2) {
            return true;
        }
        if (xSSimpleType3 != SchemaGrammar.fAnySimpleType && this.checkSimpleDerivation(xSSimpleType3, xSSimpleType2, s2)) {
            return true;
        }
        if ((xSSimpleType.getVariety() == 2 || xSSimpleType.getVariety() == 3) && xSSimpleType2 == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (xSSimpleType2.getVariety() == 3 && this.checkEmptyFacets(xSSimpleType2)) {
            XSObjectList xSObjectList = xSSimpleType2.getMemberTypes();
            int n2 = xSObjectList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                xSSimpleType2 = (XSSimpleType)xSObjectList.item(i2);
                if (!this.checkSimpleDerivation(xSSimpleType, xSSimpleType2, s2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkComplexDerivation(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDefinition xSTypeDefinition, short s2) {
        if (xSComplexTypeDecl == xSTypeDefinition) {
            return true;
        }
        if ((xSComplexTypeDecl.fDerivedBy & s2) != 0) {
            return false;
        }
        XSTypeDefinition xSTypeDefinition2 = xSComplexTypeDecl.fBaseType;
        if (xSTypeDefinition2 == xSTypeDefinition) {
            return true;
        }
        if (xSTypeDefinition2 == this.fAnyType || xSTypeDefinition2 == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (xSTypeDefinition2.getTypeCategory() == 15) {
            return this.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition2, xSTypeDefinition, s2);
        }
        if (xSTypeDefinition2.getTypeCategory() == 16) {
            if (xSTypeDefinition.getTypeCategory() == 15) {
                if (xSTypeDefinition == this.fAnyType) {
                    xSTypeDefinition = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)xSTypeDefinition2, (XSSimpleType)xSTypeDefinition, s2);
        }
        return false;
    }

    public Object ElementDefaultValidImmediate(XSTypeDefinition xSTypeDefinition, String string, ValidationContext validationContext, ValidatedInfo validatedInfo) {
        Object object;
        XSSimpleType xSSimpleType = null;
        if (xSTypeDefinition.getTypeCategory() == 16) {
            xSSimpleType = (XSSimpleType)xSTypeDefinition;
        } else {
            object = (XSComplexTypeDecl)xSTypeDefinition;
            if (((XSComplexTypeDecl)object).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)object).fXSSimpleType;
            } else if (((XSComplexTypeDecl)object).fContentType == 3) {
                if (!((XSParticleDecl)((XSComplexTypeDecl)object).getParticle()).emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        object = null;
        if (xSSimpleType == null) {
            xSSimpleType = STRING_TYPE;
        }
        try {
            object = xSSimpleType.validate(string, validationContext, validatedInfo);
            if (validatedInfo != null) {
                object = xSSimpleType.validate(validatedInfo.stringValue(), validationContext, validatedInfo);
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
        return object;
    }

    void reportSchemaError(XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator, String string, Object[] objectArray) {
        if (xMLErrorReporter instanceof u) {
            if (simpleLocator.getElem() instanceof ElementImpl) {
                u u2 = (u)xMLErrorReporter;
                u2.e((ElementImpl)((Object)simpleLocator.getElem()));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("The element is not instance of ElementImpl " + simpleLocator.getElem()));
            }
        }
        if (simpleLocator != null) {
            xMLErrorReporter.reportError((XMLLocator)simpleLocator, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        } else {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    public void fullSchemaChecking(XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter) {
        XSModelGroupImpl xSModelGroupImpl;
        XSGroupDecl xSGroupDecl;
        SymbolHash symbolHash;
        int n2;
        Object[] objectArray;
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        for (int i2 = schemaGrammarArray.length - 1; i2 >= 0; --i2) {
            substitutionGroupHandler.addSubstitutionGroup(schemaGrammarArray[i2].getSubstitutionGroups());
        }
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl.fType = (short)3;
        xSParticleDecl2.fType = (short)3;
        for (int i3 = schemaGrammarArray.length - 1; i3 >= 0; --i3) {
            objectArray = schemaGrammarArray[i3].getRedefinedGroupDecls();
            SimpleLocator[] simpleLocatorArray = schemaGrammarArray[i3].getRGLocators();
            n2 = 0;
            while (n2 < objectArray.length) {
                XSGroupDecl xSGroupDecl2 = objectArray[n2++];
                symbolHash = xSGroupDecl2.fModelGroup;
                xSGroupDecl = objectArray[n2++];
                xSModelGroupImpl = xSGroupDecl.fModelGroup;
                xSParticleDecl.fValue = symbolHash;
                xSParticleDecl2.fValue = xSModelGroupImpl;
                if (xSModelGroupImpl == null) {
                    if (symbolHash == null) continue;
                    this.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n2 / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl2.fName, "rcase-Recurse.2"});
                    continue;
                }
                if (symbolHash == null) {
                    if (xSParticleDecl2.emptiable()) continue;
                    this.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n2 / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl2.fName, "rcase-Recurse.2"});
                    continue;
                }
                this.groupSubsumption(xSParticleDecl, xSParticleDecl2, xSGrammarBucket, substitutionGroupHandler, cMBuilder, xMLErrorReporter, xSGroupDecl2.fName, simpleLocatorArray[n2 / 2 - 1]);
            }
        }
        symbolHash = new SymbolHash();
        xSGroupDecl = new Stack();
        xSModelGroupImpl = this.fSchemaVersion == 4 ? new ArrayList() : null;
        for (int i4 = schemaGrammarArray.length - 1; i4 >= 0; --i4) {
            int n3 = 0;
            n2 = schemaGrammarArray[i4].fFullChecked ? 1 : 0;
            XSComplexTypeDecl[] xSComplexTypeDeclArray = schemaGrammarArray[i4].getUncheckedComplexTypeDecls();
            objectArray = schemaGrammarArray[i4].getUncheckedCTLocators();
            for (int i5 = 0; i5 < xSComplexTypeDeclArray.length; ++i5) {
                XSCMValidator xSCMValidator;
                if (n2 == 0 && xSComplexTypeDeclArray[i5].fParticle != null) {
                    symbolHash.clear();
                    try {
                        this.checkElementDeclsConsistent(xSComplexTypeDeclArray[i5], xSComplexTypeDeclArray[i5].fParticle, symbolHash, substitutionGroupHandler, xSGrammarBucket, (ArrayList)xSModelGroupImpl, (Stack)xSGroupDecl);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[i5], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (xSComplexTypeDeclArray[i5].fBaseType != null && xSComplexTypeDeclArray[i5].fBaseType != this.fAnyType && xSComplexTypeDeclArray[i5].fDerivedBy == 2 && xSComplexTypeDeclArray[i5].fBaseType instanceof XSComplexTypeDecl) {
                    xSCMValidator = xSComplexTypeDeclArray[i5].fParticle;
                    XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSComplexTypeDeclArray[i5].fBaseType;
                    XSParticleDecl xSParticleDecl3 = xSComplexTypeDecl.fParticle;
                    if (xSCMValidator == null) {
                        if (xSParticleDecl3 != null && !xSParticleDecl3.emptiable()) {
                            this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[i5], "derivation-ok-restriction.5.3.2", new Object[]{xSComplexTypeDeclArray[i5].fName, xSComplexTypeDeclArray[i5].fBaseType.getName()});
                        }
                    } else if (xSParticleDecl3 != null) {
                        this.typeSubsumption(xSComplexTypeDeclArray[i5], xSComplexTypeDecl, xSGrammarBucket, substitutionGroupHandler, cMBuilder, xMLErrorReporter, (SimpleLocator)objectArray[i5]);
                    } else {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[i5], "derivation-ok-restriction.5.4.2", new Object[]{xSComplexTypeDeclArray[i5].fName});
                    }
                }
                xSCMValidator = xSComplexTypeDeclArray[i5].getContentModel(cMBuilder, true);
                boolean bl = false;
                if (xSCMValidator != null) {
                    try {
                        bl = xSCMValidator.checkUniqueParticleAttribution(substitutionGroupHandler, this);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[i5], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (n2 != 0 || !bl) continue;
                xSComplexTypeDeclArray[n3++] = xSComplexTypeDeclArray[i5];
            }
            if (n2 != 0) continue;
            schemaGrammarArray[i4].setUncheckedTypeNum(n3);
            schemaGrammarArray[i4].fFullChecked = true;
        }
    }

    public void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        short s2 = xSParticleDecl.fType;
        if (s2 == 2) {
            return;
        }
        if (s2 == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            this.findElemInTable(xSComplexTypeDecl, xSElementDecl, symbolHash);
            if (xSElementDecl.fScope == 1) {
                XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
                for (int i2 = 0; i2 < xSElementDeclArray.length; ++i2) {
                    this.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[i2], symbolHash);
                }
            }
            return;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        for (int i3 = 0; i3 < xSModelGroupImpl.fParticleCount; ++i3) {
            this.checkElementDeclsConsistent(xSComplexTypeDecl, xSModelGroupImpl.fParticles[i3], symbolHash, substitutionGroupHandler);
        }
    }

    protected void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler, XSGrammarBucket xSGrammarBucket, ArrayList arrayList, Stack stack) throws XMLSchemaException {
        if (stack.size() > 0) {
            stack.clear();
        }
        while (true) {
            short s2;
            if ((s2 = xSParticleDecl.fType) != 2) {
                XSModelGroupImpl xSModelGroupImpl;
                if (s2 == 1) {
                    xSModelGroupImpl = (XSElementDecl)xSParticleDecl.fValue;
                    this.findElemInTable(xSComplexTypeDecl, (XSElementDecl)xSModelGroupImpl, symbolHash);
                    if (xSModelGroupImpl.fScope == 1) {
                        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSModelGroupImpl, this.fSchemaVersion);
                        for (int i2 = 0; i2 < xSElementDeclArray.length; ++i2) {
                            this.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[i2], symbolHash);
                        }
                    }
                } else {
                    xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
                    for (int i3 = xSModelGroupImpl.fParticleCount - 1; i3 >= 0; --i3) {
                        stack.push(xSModelGroupImpl.fParticles[i3]);
                    }
                }
            }
            if (stack.isEmpty()) break;
            xSParticleDecl = (XSParticleDecl)stack.pop();
        }
    }

    public void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        XSElementDecl xSElementDecl2 = this.findExistingElement(xSElementDecl, symbolHash);
        if (xSElementDecl2 == null || xSElementDecl2 == xSElementDecl) {
            return;
        }
        if (xSElementDecl.fType != xSElementDecl2.fType) {
            throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, xSElementDecl.fName});
        }
    }

    protected XSElementDecl findExistingElement(XSElementDecl xSElementDecl, SymbolHash symbolHash) {
        String string = xSElementDecl.fName + "," + xSElementDecl.fTargetNamespace;
        XSElementDecl xSElementDecl2 = (XSElementDecl)symbolHash.get((Object)string);
        if (xSElementDecl2 == null) {
            symbolHash.put((Object)string, (Object)xSElementDecl);
        }
        return xSElementDecl2;
    }

    protected boolean overlapUPA(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, SubstitutionGroupHandler substitutionGroupHandler) {
        int n2;
        if (xSElementDecl.fName == xSElementDecl2.fName && xSElementDecl.fTargetNamespace == xSElementDecl2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
        for (int i2 = xSElementDeclArray.length - 1; i2 >= 0; --i2) {
            if (xSElementDeclArray[i2].fName != xSElementDecl2.fName || xSElementDeclArray[i2].fTargetNamespace != xSElementDecl2.fTargetNamespace) continue;
            return true;
        }
        XSElementDecl[] xSElementDeclArray2 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl2, this.fSchemaVersion);
        for (n2 = xSElementDeclArray2.length - 1; n2 >= 0; --n2) {
            if (xSElementDeclArray2[n2].fName != xSElementDecl.fName || xSElementDeclArray2[n2].fTargetNamespace != xSElementDecl.fTargetNamespace) continue;
            return true;
        }
        for (n2 = xSElementDeclArray.length - 1; n2 >= 0; --n2) {
            for (int i3 = xSElementDeclArray2.length - 1; i3 >= 0; --i3) {
                if (xSElementDeclArray[n2].fName != xSElementDeclArray2[i3].fName || xSElementDeclArray[n2].fTargetNamespace != xSElementDeclArray2[i3].fTargetNamespace) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlapUPA(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        XSWildcardDecl xSWildcardDecl3 = this.performIntersectionWith(xSWildcardDecl, xSWildcardDecl2, xSWildcardDecl.fProcessContents);
        return xSWildcardDecl3 == null || xSWildcardDecl3.fType != 3 || xSWildcardDecl3.fNamespaceList.length != 0;
    }

    public boolean overlapUPA(Object object, Object object2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (object instanceof XSElementDecl) {
            if (object2 instanceof XSElementDecl) {
                return this.overlapUPA((XSElementDecl)object, (XSElementDecl)object2, substitutionGroupHandler);
            }
            return this.overlapUPA((XSElementDecl)object, (XSWildcardDecl)object2, substitutionGroupHandler);
        }
        if (object2 instanceof XSElementDecl) {
            return this.overlapUPA((XSElementDecl)object2, (XSWildcardDecl)object, substitutionGroupHandler);
        }
        return this.overlapUPA((XSWildcardDecl)object, (XSWildcardDecl)object2);
    }

    boolean areSame(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl.fType == xSWildcardDecl2.fType) {
            if (xSWildcardDecl.fType == 1) {
                return true;
            }
            if (xSWildcardDecl.fType == 2) {
                return xSWildcardDecl.fNamespaceList[0] == xSWildcardDecl2.fNamespaceList[0];
            }
            if (xSWildcardDecl.fNamespaceList.length == xSWildcardDecl2.fNamespaceList.length) {
                for (int i2 = 0; i2 < xSWildcardDecl.fNamespaceList.length; ++i2) {
                    if (this.elementInSet(xSWildcardDecl.fNamespaceList[i2], xSWildcardDecl2.fNamespaceList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    String[] intersect2sets(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[Math.min(stringArray.length, stringArray2.length)];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.elementInSet(stringArray[i2], stringArray2)) continue;
            stringArray3[n2++] = stringArray[i2];
        }
        String[] stringArray4 = new String[n2];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
        return stringArray4;
    }

    String[] union2sets(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (this.elementInSet(stringArray[i2], stringArray2)) continue;
            stringArray3[n2++] = stringArray[i2];
        }
        String[] stringArray4 = new String[n2 + stringArray2.length];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray4, n2, stringArray2.length);
        return stringArray4;
    }

    boolean subset2sets(String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (this.elementInSet(stringArray[i2], stringArray2)) continue;
            return false;
        }
        return true;
    }

    boolean elementInSet(String string, String[] stringArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length && !bl; ++i2) {
            if (string != stringArray[i2]) continue;
            bl = true;
        }
        return bl;
    }

    boolean disjoint2sets(String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.elementInSet(stringArray[i2], stringArray2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isSubsetOf(XSWildcardDecl var1, XSWildcardDecl var2);

    public abstract XSWildcardDecl performUnionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    public abstract XSWildcardDecl performIntersectionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    protected abstract boolean checkEmptyFacets(XSSimpleType var1);

    public abstract boolean overlapUPA(XSElementDecl var1, XSWildcardDecl var2, SubstitutionGroupHandler var3);

    protected abstract void groupSubsumption(XSParticleDecl var1, XSParticleDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, String var7, SimpleLocator var8);

    protected abstract void typeSubsumption(XSComplexTypeDecl var1, XSComplexTypeDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, SimpleLocator var7);
}

