/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xpath.regex.Token;
import org.apache.xerces.util.XMLChar;

public class RegexpInputGeneratorInternal {
    private static Logger logger = Logger.getLogger((String)RegexpInputGeneratorInternal.class.getName());
    private Random random = new Random();

    public RegexpInputGeneratorInternal(long l2) {
        this.random.setSeed(l2);
    }

    public String generateMatchingInput(String string, boolean bl) {
        String string2 = null;
        try {
            RegularExpression regularExpression = new RegularExpression(string, "X");
            Token token = regularExpression.tokentree;
            if (token != null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.dumpToken(stringBuilder, token, bl, 0);
                string2 = stringBuilder.toString();
            }
        }
        catch (ParseException parseException) {
            logger.debug((Object)("Invalid expression '" + string + "'"));
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Object)("Runtime Exception when generating input for the expression '" + string + "'"));
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpToken(StringBuilder stringBuilder, Token token, boolean bl, int n2) {
        boolean bl2;
        char c2;
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder2 = new StringBuilder(n2);
            for (c2 = '\u0000'; c2 < n2; ++c2) {
                stringBuilder2.append("  ");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(stringBuilder2 + "------------\n" + stringBuilder2 + "Token\t" + token + " class: " + token.getClass() + "\n" + stringBuilder2 + "Type\t" + token.type + " Char\t|" + (char)token.getChar() + "-" + token.getChar() + "|" + " String\t|" + token.getString() + "|\n" + stringBuilder2 + "Min-max\t" + token.getMin() + " -> " + token.getMax() + "\n" + stringBuilder2 + "Length\t" + token.getMinLength() + " -> " + token.getMaxLength() + "\n"));
            }
        }
        boolean bl3 = bl2 = token.getMinLength() > 0;
        if (!bl2) {
            boolean bl4 = bl ? this.chooseRand(0, 1) == 1 : (bl2 = false);
            if (bl2 && logger.isDebugEnabled()) {
                logger.debug((Object)"Optional, but dice said to generate");
            }
        }
        if (bl2) {
            switch (token.type) {
                case 0: {
                    stringBuilder.append((char)token.getChar());
                    return;
                }
                case 11: {
                    c2 = bl ? (char)this.chooseRand(97, 122) : (char)'a';
                    stringBuilder.append(c2);
                    return;
                }
                case 1: {
                    int n3 = token.size();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        this.dumpToken(stringBuilder, token.getChild(i2), bl, n2 + 1);
                    }
                    return;
                }
                case 2: {
                    int n4 = token.size();
                    int n5 = bl ? this.chooseRand(0, n4 - 1) : 0;
                    this.dumpToken(stringBuilder, token.getChild(n5), bl, n2 + 1);
                    return;
                }
                case 3: 
                case 9: {
                    int n6;
                    Token.ClosureToken closureToken = (Token.ClosureToken)token;
                    int n7 = closureToken.getMin();
                    int n8 = closureToken.getMax();
                    if (n7 == -1) {
                        n7 = 0;
                    }
                    if (n8 == -1) {
                        n8 = 3;
                    }
                    if (n8 < n7) {
                        n8 = n7;
                    }
                    int n9 = n6 = bl ? this.chooseRand(n7, n8) : n7;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Closure: " + n7 + " -> " + n8 + " choosen: " + n6));
                    }
                    for (int i3 = 0; i3 < n6; ++i3) {
                        this.dumpToken(stringBuilder, closureToken.child, bl, n2 + 1);
                    }
                    return;
                }
                case 4: {
                    RangeToken rangeToken = (RangeToken)token;
                    char c3 = this.generateCharFromRangeToken(rangeToken, bl, true);
                    stringBuilder.append(c3);
                    return;
                }
                case 5: {
                    RangeToken rangeToken = (RangeToken)token;
                    char c4 = this.generateCharFromRangeToken((RangeToken)RangeToken.complementRanges((Token)rangeToken), bl, true);
                    stringBuilder.append(c4);
                    return;
                }
                case 6: {
                    this.dumpToken(stringBuilder, token.getChild(0), bl, n2 + 1);
                    return;
                }
                case 7: {
                    return;
                }
                case 8: {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug((Object)"The anchors are not supported");
                    return;
                }
                case 10: {
                    stringBuilder.append(token.getString());
                    return;
                }
                default: {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug((Object)("Unhandled token: " + token));
                }
            }
            return;
        }
        if (!logger.isDebugEnabled()) return;
        logger.debug((Object)"The content is optional. Skipped.");
    }

    private int chooseRand(int n2, int n3) {
        int n4 = n3 - n2 + 1;
        if (n4 > 0) {
            return n2 + this.random.nextInt(n3 - n2 + 1);
        }
        return n2;
    }

    private char generateCharFromRangeToken(RangeToken rangeToken, boolean bl, boolean bl2) {
        char c2;
        int n2;
        int n3;
        int n4;
        int n5 = rangeToken.ranges.length / 2;
        int n6 = -1;
        int n7 = -1;
        rangeToken.sortRanges();
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = rangeToken.ranges[n4 * 2];
            n2 = rangeToken.ranges[n4 * 2 + 1];
            if (n2 < 32) continue;
            if (n3 < 32) {
                rangeToken.ranges[n4 * 2] = 32;
            }
            if (n7 == -1) {
                n7 = n4;
            }
            if (n2 > 255) {
                if (n3 > 255) break;
                rangeToken.ranges[n4 * 2 + 1] = 255;
                n6 = n4;
                break;
            }
            n6 = n4;
        }
        if (n7 == -1 || n6 == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No range with valid ASCII chars");
            }
            if (n5 > 0) {
                n7 = 0;
                n6 = 0;
            } else {
                return 'A';
            }
        }
        n4 = bl ? this.chooseRand(n7, n6) : n7;
        n3 = rangeToken.ranges[n4 * 2];
        n2 = rangeToken.ranges[n4 * 2 + 1];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Range Start " + (char)n3 + " Range End " + (char)n2));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Range Start " + n3 + " Range End " + n2));
        }
        char c3 = c2 = bl ? (char)this.chooseRand(n3, n2) : (char)n3;
        if (!XMLChar.isValid((int)c2)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Character generated " + c2 + " was not a valid XML char"));
            }
            return ' ';
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Value from range " + c2));
        }
        return c2;
    }
}

