/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class MemoClosure
extends Closure {
    private List<Item> reservoir = null;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public synchronized SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                SequenceIterator sequenceIterator = this.expression.iterate((XPathContext)this.savedXPathContext);
                if (sequenceIterator instanceof EmptyIterator) {
                    this.state = 5;
                    this.inputIterator = EmptyIterator.emptyIterator();
                    return this.inputIterator;
                }
                this.inputIterator = sequenceIterator;
                this.reservoir = new ArrayList<Item>(50);
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.reservoir.size()) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator((Item)this.reservoir.get(0));
                    }
                }
                return new ListIterator(this.reservoir);
            }
            case 4: {
                XPathException xPathException = new XPathException("Attempt to access a variable while it is being evaluated");
                xPathException.setErrorCode("XTDE0640");
                throw xPathException;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public synchronized void process(XPathContext xPathContext) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.state == 4) {
            XPathException xPathException = new XPathException("Attempt to access a variable while it is being evaluated");
            xPathException.setErrorCode("XTDE0640");
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        if (this.reservoir != null) {
            Item item;
            SequenceIterator sequenceIterator = this.iterate();
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            while ((item = sequenceIterator.next()) != null) {
                sequenceReceiver.append(item, 0, 2);
            }
        } else {
            this.state = 4;
            Controller controller = xPathContext.getController();
            XPathContextMajor xPathContextMajor = this.savedXPathContext.newContext();
            SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
            sequenceOutputter.open();
            TeeOutputter teeOutputter = new TeeOutputter((Receiver)xPathContext.getReceiver(), (Receiver)sequenceOutputter);
            teeOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMajor.setReceiver((SequenceReceiver)teeOutputter);
            xPathContextMajor.setTemporaryOutputState(206);
            this.expression.process((XPathContext)xPathContextMajor);
            sequenceOutputter.close();
            List list = sequenceOutputter.getList();
            if (list.isEmpty()) {
                this.state = 5;
            } else {
                this.reservoir = list;
                this.state = 3;
            }
            this.savedXPathContext = null;
            sequenceOutputter.reset();
        }
    }

    private void append(Item item) {
        assert (this.reservoir != null);
        this.reservoir.add(item);
    }

    private void condense() {
        if (this.reservoir != null) {
            ((ArrayList)this.reservoir).trimToSize();
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public synchronized Item itemAt(int n2) throws XPathException {
        if (n2 < 0) {
            return null;
        }
        if (this.reservoir != null && n2 < this.reservoir.size()) {
            return this.reservoir.get(n2);
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            Item item;
            if (this.inputIterator == null) {
                this.state = 4;
                item = this.expression.iterate((XPathContext)this.savedXPathContext);
                this.inputIterator = item;
            }
            if ((item = this.inputIterator.next()) == null) {
                this.state = 5;
                return null;
            }
            this.state = 1;
            this.reservoir = new ArrayList<Item>(50);
            this.append(item);
            if (n2 == 0) {
                return item;
            }
        }
        int n3 = n2 - this.reservoir.size() + 1;
        while (n3-- > 0) {
            Item item = this.inputIterator.next();
            if (item == null) {
                this.state = 3;
                this.condense();
                return null;
            }
            this.append(item);
            this.state = 1;
        }
        return this.reservoir.get(n2);
    }

    public GroundedValue materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent(this.iterate());
    }

    public boolean isRead() {
        return this.isFullyRead() || this.state == 1;
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public MemoClosure getMemoClosure() {
            return MemoClosure.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item next() throws XPathException {
            MemoClosure memoClosure = MemoClosure.this;
            synchronized (memoClosure) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoClosure.this.reservoir.size()) {
                    return (Item)MemoClosure.this.reservoir.get(this.position);
                }
                if (MemoClosure.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoClosure.this.inputIterator != null);
                Item item = MemoClosure.this.inputIterator.next();
                if (item == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoClosure.this.reservoir.size();
                MemoClosure.this.append(item);
                MemoClosure.this.state = 1;
                return item;
            }
        }

        public void close() {
        }

        public ProgressiveIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLength() throws XPathException {
            Item item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.reservoir.size();
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int n2 = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = n2;
            return MemoClosure.this.reservoir.size();
        }

        public GroundedValue materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                assert (MemoClosure.this.reservoir != null);
                return new SequenceExtent(MemoClosure.this.reservoir);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate());
        }

        public int getProperties() {
            return 3;
        }
    }
}

