/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.IAccumulatorManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.z.IntHashMap;

public class StylesheetPackage
extends StylesheetModule
implements GlobalVariableManager {
    private NestedIntegerValue packageVersionOLD = null;
    private PackageVersion packageVersion = null;
    private String packageName;
    private List<StylesheetPackage> usedPackages = new ArrayList<StylesheetPackage>();
    protected HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibraryList functionLibrary;
    private FunctionLibraryList stylesheetFunctionLibrary;
    private ExecutableFunctionLibrary overriding;
    private ExecutableFunctionLibrary underriding;
    private DecimalValue version;
    private HashMap<StructuredQName, ComponentDeclaration> globalVariableIndex = new HashMap(20);
    private HashMap<SymbolicName, Component> componentIndex = new HashMap(20);
    private List<Component> hiddenComponents = new ArrayList<Component>();
    private HashMap<StructuredQName, ComponentDeclaration> templateIndex = new HashMap(20);
    private HashMap<SymbolicName, ComponentDeclaration> functionIndex = new HashMap(8);
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private RuleManager ruleManager;
    private IAccumulatorManager accumulatorManager = null;
    private int numberOfAliases = 0;
    private List<ComponentDeclaration> namespaceAliasList = new ArrayList<ComponentDeclaration>(5);
    private HashMap<String, NamespaceBinding> namespaceAliasMap;
    private Set<String> aliasResultUriSet;
    private boolean needsDynamicOutputProperties = false;
    private int largestPatternStackFrame = 0;
    private HashMap<DocumentURI, XSLModuleRoot> moduleCache = new HashMap(4);
    private SpaceStrippingRule stripperRules;
    private CharacterMapIndex characterMapIndex = new CharacterMapIndex();
    private List<Action> fixupActions = new ArrayList<Action>();
    private List<Action> completionActions = new ArrayList<Action>();
    private boolean createsSecondaryResultDocuments = false;

    public StylesheetPackage(XSLPackage xSLPackage) {
        super((StyleElement)xSLPackage, 0);
        this.keyManager = new KeyManager(xSLPackage.getConfiguration());
        this.decimalFormatManager = new DecimalFormatManager();
        this.ruleManager = new RuleManager();
        try {
            this.setInputTypeAnnotations(xSLPackage.getInputTypeAnnotationsAttribute());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public Component getComponent(SymbolicName symbolicName) {
        return this.componentIndex.get(symbolicName);
    }

    public void removeGlobalVariable(ComponentDeclaration componentDeclaration) {
        StructuredQName structuredQName = componentDeclaration.getSourceElement().getObjectName();
        SymbolicName symbolicName = new SymbolicName(206, structuredQName);
        if (this.globalVariableIndex.get(structuredQName) == componentDeclaration) {
            this.componentIndex.remove(symbolicName);
            this.globalVariableIndex.remove(structuredQName);
        }
    }

    public StylesheetPackage getPrincipalStylesheetModule() {
        return this;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void addFixupAction(Action action) {
        this.fixupActions.add(action);
    }

    public void addCompletionAction(Action action) {
        this.completionActions.add(action);
    }

    public FunctionLibraryList createFunctionLibrary(Compilation compilation) {
        Configuration configuration = this.getConfiguration();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new StylesheetFunctionLibrary(this, true));
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new StylesheetFunctionLibrary(this, false));
        this.stylesheetFunctionLibrary = functionLibraryList;
        FunctionLibraryList functionLibraryList2 = new FunctionLibraryList();
        int n2 = 3;
        if (DecimalValue.THREE.equals((Object)this.getVersion())) {
            n2 |= 0x50;
        }
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)SystemFunctionLibrary.getSystemFunctionLibrary((int)n2));
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)new StylesheetFunctionLibrary(this, true));
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)configuration.getVendorFunctionLibrary());
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)new ConstructorFunctionLibrary(configuration));
        CompilerInfo compilerInfo = compilation.getCompilerInfo();
        if (compilerInfo.getExtensionFunctionLibrary() != null) {
            functionLibraryList2.addFunctionLibrary(compilerInfo.getExtensionFunctionLibrary());
        }
        this.queryFunctions = new XQueryFunctionLibrary(configuration);
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)this.queryFunctions);
        functionLibraryList2.addFunctionLibrary((FunctionLibrary)configuration.getIntegratedFunctionLibrary());
        configuration.addExtensionBinders(functionLibraryList2);
        for (StylesheetPackage stylesheetPackage : this.usedPackages) {
            FunctionLibraryList functionLibraryList3 = stylesheetPackage.getStylesheetFunctionLibrary();
            functionLibraryList2.addFunctionLibrary((FunctionLibrary)functionLibraryList3);
        }
        this.functionLibrary = functionLibraryList2;
        return this.functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public FunctionLibraryList getStylesheetFunctionLibrary() {
        return this.stylesheetFunctionLibrary;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        return this.characterMapIndex;
    }

    public void declareXQueryFunction(XQueryFunction xQueryFunction) throws XPathException {
        this.queryFunctions.declareFunction(xQueryFunction);
    }

    public void putStylesheetDocument(DocumentURI documentURI, XSLStylesheet xSLStylesheet) {
        this.moduleCache.put(documentURI, (XSLModuleRoot)xSLStylesheet);
    }

    public XSLModuleRoot getStylesheetDocument(DocumentURI documentURI) {
        XSLModuleRoot xSLModuleRoot = this.moduleCache.get(documentURI);
        if (xSLModuleRoot != null) {
            XPathException xPathException = new XPathException("Stylesheet module " + documentURI + " is included or imported more than once. " + "This is permitted, but may lead to errors or unexpected behavior");
            xSLModuleRoot.issueWarning(xPathException);
        }
        return xSLModuleRoot;
    }

    public void preprocess() throws XPathException {
        ComponentDeclaration componentDeclaration2;
        this.spliceUsePackages((XSLPackage)this.getRootElement(), this.getRootElement().getCompilation());
        this.importSchemata();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (ComponentDeclaration componentDeclaration2 : this.topLevel) {
            StyleElement styleElement = componentDeclaration2.getSourceElement();
            if (styleElement.isActionCompleted(16)) continue;
            styleElement.setActionCompleted(16);
            styleElement.fixupReferences();
        }
        XSLPackage xSLPackage = (XSLPackage)this.getStylesheetElement();
        componentDeclaration2 = new ComponentDeclaration((StylesheetModule)this, (StyleElement)xSLPackage);
        if (!xSLPackage.isActionCompleted(1)) {
            xSLPackage.setActionCompleted(1);
            this.getRootElement().validate(componentDeclaration2);
            xSLPackage.validate(null);
            for (ComponentDeclaration componentDeclaration3 : this.topLevel) {
                componentDeclaration3.getSourceElement().validateSubtree(componentDeclaration3, false);
            }
        }
        for (ComponentDeclaration componentDeclaration3 : this.topLevel) {
            StyleElement styleElement = componentDeclaration3.getSourceElement();
            if (!(styleElement instanceof XSLCharacterMap)) continue;
            XSLCharacterMap xSLCharacterMap = (XSLCharacterMap)styleElement;
            IntHashMap intHashMap = new IntHashMap();
            xSLCharacterMap.assemble(intHashMap);
            this.characterMapIndex.putCharacterMap(xSLCharacterMap.getCharacterMapName(), new CharacterMap(intHashMap));
        }
    }

    protected void spliceUsePackages(XSLPackage xSLPackage, Compilation compilation) throws XPathException {
        CompilerInfo compilerInfo = compilation.getCompilerInfo();
        if (compilerInfo.isVersionWarning() && xSLPackage.getEffectiveVersion().compareTo((Object)compilation.getStyleNodeFactory(true).getXsltProcessorVersion()) != 0) {
            XPathException xPathException = new XPathException("Running an XSLT " + xSLPackage.getEffectiveVersion() + " stylesheet with an XSLT " + xSLPackage.getCompilation().getStyleNodeFactory(true).getXsltProcessorVersion() + " processor");
            xPathException.setLocator((SourceLocator)xSLPackage);
            compilation.reportWarning(xPathException);
        }
        this.spliceIncludes();
    }

    protected void importSchemata() throws XPathException {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLImportSchema)) continue;
            XPathException xPathException = new XPathException("xsl:import-schema requires Saxon-EE");
            xPathException.setErrorCode("XTSE1650");
            xPathException.setLocator((SourceLocator)((Object)componentDeclaration.getSourceElement()));
            throw xPathException;
        }
    }

    private void buildIndexes() throws XPathException {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)this.topLevel.get(i2);
            componentDeclaration.getSourceElement().index(componentDeclaration, this);
        }
    }

    public void processAllAttributes() throws XPathException {
        this.getRootElement().processDefaultCollationAttribute();
        this.getRootElement().prepareAttributes();
        for (XSLModuleRoot xSLModuleRoot : this.moduleCache.values()) {
            xSLModuleRoot.prepareAttributes();
        }
        for (XSLModuleRoot xSLModuleRoot : this.topLevel) {
            StyleElement styleElement = xSLModuleRoot.getSourceElement();
            if (styleElement.isActionCompleted(32)) continue;
            styleElement.setActionCompleted(32);
            try {
                styleElement.processAllAttributes();
            }
            catch (XPathException xPathException) {
                xSLModuleRoot.getSourceElement().compileError(xPathException);
            }
        }
    }

    protected void indexFunction(ComponentDeclaration componentDeclaration) throws XPathException {
        SymbolicName symbolicName;
        XSLFunction xSLFunction = (XSLFunction)componentDeclaration.getSourceElement();
        UserFunction userFunction = xSLFunction.getCompiledFunction();
        Component component = userFunction.getDeclaringComponent();
        if (component == null) {
            userFunction.makeDeclaringComponent(xSLFunction.getVisibility(), this);
            component = userFunction.getDeclaringComponent();
        }
        if ((symbolicName = xSLFunction.getSymbolicName()) != null) {
            Component component2 = this.componentIndex.get(symbolicName);
            if (component2 == null) {
                this.componentIndex.put(symbolicName, component);
                this.functionIndex.put(symbolicName, componentDeclaration);
            } else if (component2.getDeclaringPackage() == this) {
                ComponentDeclaration componentDeclaration2;
                int n2;
                int n3 = componentDeclaration.getPrecedence();
                if (n3 == (n2 = (componentDeclaration2 = this.functionIndex.get(symbolicName)).getPrecedence())) {
                    xSLFunction.compileError("Duplicate named function (see line " + componentDeclaration2.getSourceElement().getLineNumber() + " of " + componentDeclaration2.getSourceElement().getSystemId() + ')', "XTSE0770");
                } else if (n3 >= n2) {
                    this.componentIndex.put(symbolicName, component);
                    this.functionIndex.put(symbolicName, componentDeclaration);
                }
            } else {
                this.componentIndex.put(symbolicName, component);
                this.functionIndex.put(symbolicName, componentDeclaration);
            }
        }
    }

    private ComponentDeclaration getFunctionDeclaration(SymbolicName symbolicName) {
        return this.functionIndex.get(symbolicName);
    }

    public UserFunction getFunction(SymbolicName symbolicName) {
        if (symbolicName.getArity() == -1) {
            int n2 = 20;
            for (int i2 = 0; i2 < n2; ++i2) {
                SymbolicName symbolicName2 = new SymbolicName(155, symbolicName.getComponentName(), i2);
                ComponentDeclaration componentDeclaration = this.getFunctionDeclaration(symbolicName2);
                if (componentDeclaration == null) continue;
                return ((XSLFunction)componentDeclaration.getSourceElement()).getCompiledFunction();
            }
            return null;
        }
        Component component = this.componentIndex.get(symbolicName);
        return component == null ? null : (UserFunction)component.getProcedure();
    }

    protected void indexVariableDeclaration(ComponentDeclaration componentDeclaration) throws XPathException {
        XSLGlobalVariable xSLGlobalVariable = (XSLGlobalVariable)componentDeclaration.getSourceElement();
        StructuredQName structuredQName = xSLGlobalVariable.getSourceBinding().getVariableQName();
        if (structuredQName != null) {
            ComponentDeclaration componentDeclaration2 = this.globalVariableIndex.get(structuredQName);
            if (componentDeclaration2 == null) {
                this.globalVariableIndex.put(structuredQName, componentDeclaration);
                this.componentIndex.put(new SymbolicName(206, structuredQName), xSLGlobalVariable.getCompiledProcedure().getDeclaringComponent());
            } else {
                int n2;
                int n3 = componentDeclaration.getPrecedence();
                if (n3 == (n2 = componentDeclaration2.getPrecedence())) {
                    StyleElement styleElement = componentDeclaration2.getSourceElement();
                    if (styleElement == xSLGlobalVariable) {
                        xSLGlobalVariable.compileError("Global variable " + structuredQName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0630");
                    } else {
                        xSLGlobalVariable.compileError("Duplicate global variable declaration (see line " + styleElement.getLineNumber() + " of " + styleElement.getSystemId() + ')', "XTSE0630");
                    }
                } else if (n3 < n2 && xSLGlobalVariable != componentDeclaration2.getSourceElement()) {
                    xSLGlobalVariable.setRedundant(true);
                } else if (xSLGlobalVariable != componentDeclaration2.getSourceElement()) {
                    ((XSLGlobalVariable)componentDeclaration2.getSourceElement()).setRedundant(true);
                    this.globalVariableIndex.put(structuredQName, componentDeclaration);
                    this.componentIndex.put(new SymbolicName(206, structuredQName), xSLGlobalVariable.getCompiledProcedure().getDeclaringComponent());
                }
            }
        }
    }

    public SourceBinding getGlobalVariableBinding(StructuredQName structuredQName) {
        ComponentDeclaration componentDeclaration = this.globalVariableIndex.get(structuredQName);
        return componentDeclaration == null ? null : ((XSLGlobalVariable)componentDeclaration.getSourceElement()).getSourceBinding();
    }

    public int allocateUniqueParameterNumber(StructuredQName structuredQName) {
        Integer n2;
        HashMap<StructuredQName, Integer> hashMap = this.localParameterNumbers;
        if (hashMap == null) {
            hashMap = this.localParameterNumbers = new HashMap(50);
        }
        if ((n2 = hashMap.get(structuredQName)) == null) {
            n2 = hashMap.size();
            hashMap.put(structuredQName, n2);
        }
        return n2;
    }

    protected void indexNamedTemplate(ComponentDeclaration componentDeclaration) throws XPathException {
        SymbolicName symbolicName;
        XSLTemplate xSLTemplate = (XSLTemplate)componentDeclaration.getSourceElement();
        Template template = xSLTemplate.getCompiledTemplate();
        Component component = template.getDeclaringComponent();
        if (component == null) {
            template.makeDeclaringComponent(xSLTemplate.getVisibility(), this);
            component = template.getDeclaringComponent();
        }
        if ((symbolicName = xSLTemplate.getSymbolicName()) != null) {
            Component component2 = this.componentIndex.get(symbolicName);
            if (component2 == null) {
                this.componentIndex.put(symbolicName, component);
                this.templateIndex.put(symbolicName.getComponentName(), componentDeclaration);
            } else if (component2.getDeclaringPackage() == this) {
                ComponentDeclaration componentDeclaration2;
                int n2;
                int n3 = componentDeclaration.getPrecedence();
                if (n3 == (n2 = (componentDeclaration2 = this.templateIndex.get(symbolicName.getComponentName())).getPrecedence())) {
                    xSLTemplate.compileError("Duplicate named template (see line " + componentDeclaration2.getSourceElement().getLineNumber() + " of " + componentDeclaration2.getSourceElement().getSystemId() + ')', "XTSE0660");
                } else if (n3 >= n2) {
                    this.componentIndex.put(symbolicName, component);
                    this.templateIndex.put(symbolicName.getComponentName(), componentDeclaration);
                }
            } else {
                this.componentIndex.put(symbolicName, component);
                this.templateIndex.put(symbolicName.getComponentName(), componentDeclaration);
            }
        }
    }

    public Template getNamedTemplate(StructuredQName structuredQName) {
        Component component = this.componentIndex.get(new SymbolicName(200, structuredQName));
        return component == null ? null : (Template)component.getProcedure();
    }

    protected void indexAttributeSet(ComponentDeclaration componentDeclaration) throws XPathException {
        SymbolicName symbolicName;
        XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)componentDeclaration.getSourceElement();
        AttributeSet attributeSet = xSLAttributeSet.getCompiledProcedure();
        Component component = attributeSet.getDeclaringComponent();
        if (component == null) {
            attributeSet.makeDeclaringComponent(xSLAttributeSet.getVisibility(), this);
            component = attributeSet.getDeclaringComponent();
        }
        if ((symbolicName = xSLAttributeSet.getSymbolicName()) != null) {
            Component component2 = this.componentIndex.get(symbolicName);
            if (component2 == null) {
                this.componentIndex.put(symbolicName, component);
            } else if (component2.getDeclaringPackage() == this) {
                int n2 = componentDeclaration.getPrecedence();
            } else {
                this.componentIndex.put(symbolicName, component);
            }
        }
    }

    private void checkForSchemaAwareness() {
        Compilation compilation = this.getRootElement().getCompilation();
        if (!compilation.isSchemaAware() && this.getConfiguration().isLicensedFeature(2)) {
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                StyleElement styleElement = componentDeclaration.getSourceElement();
                if (!(styleElement instanceof XSLImportSchema)) continue;
                compilation.setSchemaAware(true);
                return;
            }
        }
    }

    public IAccumulatorManager getAccumulatorManager() {
        return this.accumulatorManager;
    }

    public void setAccumulatorManager(IAccumulatorManager iAccumulatorManager) {
        this.accumulatorManager = iAccumulatorManager;
    }

    protected void addNamespaceAlias(ComponentDeclaration componentDeclaration) {
        this.namespaceAliasList.add(componentDeclaration);
        ++this.numberOfAliases;
    }

    protected NamespaceBinding getNamespaceAlias(String string) {
        return this.namespaceAliasMap.get(string);
    }

    protected boolean isAliasResultNamespace(String string) {
        return this.aliasResultUriSet.contains(string);
    }

    private void collectNamespaceAliases() throws XPathException {
        this.namespaceAliasMap = new HashMap(this.numberOfAliases);
        this.aliasResultUriSet = new HashSet<String>(this.numberOfAliases);
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = -1;
        for (int i2 = 0; i2 < this.numberOfAliases; ++i2) {
            ComponentDeclaration componentDeclaration = this.namespaceAliasList.get(i2);
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)componentDeclaration.getSourceElement();
            String string = xSLNamespaceAlias.getStylesheetURI();
            NamespaceBinding namespaceBinding = xSLNamespaceAlias.getResultNamespaceBinding();
            int n3 = componentDeclaration.getPrecedence();
            if (n2 != n3) {
                n2 = n3;
                hashSet.clear();
            }
            if (hashSet.contains(string) && !this.namespaceAliasMap.get(string).getURI().equals(namespaceBinding.getURI())) {
                xSLNamespaceAlias.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (this.namespaceAliasMap.get(string) == null) {
                this.namespaceAliasMap.put(string, namespaceBinding);
                this.aliasResultUriSet.add(namespaceBinding.getURI());
            }
            hashSet.add(string);
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public Properties gatherOutputProperties(StructuredQName structuredQName) throws XPathException {
        boolean bl = structuredQName == null;
        Configuration configuration = this.getConfiguration();
        Properties properties = new Properties(configuration.getDefaultSerializationProperties());
        HashMap hashMap = new HashMap(10);
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xSLOutput = (XSLOutput)componentDeclaration.getSourceElement();
            if (!(structuredQName == null ? xSLOutput.getFormatQName() == null : structuredQName.equals(xSLOutput.getFormatQName()))) continue;
            bl = true;
            xSLOutput.gatherOutputProperties(properties, hashMap, componentDeclaration.getPrecedence());
        }
        if (!bl) {
            this.compileError("Requested output format " + structuredQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return properties;
    }

    protected void compile(Compilation compilation) throws XPathException {
        block20: {
            try {
                Object object3;
                Iterator<Object> iterator;
                Configuration configuration = this.getConfiguration();
                try {
                    iterator = this.queryFunctions.getFunctionDefinitions();
                    while (iterator.hasNext()) {
                        XQueryFunction object22 = (XQueryFunction)iterator.next();
                        object22.fixupReferences();
                    }
                }
                catch (XPathException xPathException) {
                    this.getRootElement().compileError(xPathException);
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    object3 = componentDeclaration.getSourceElement();
                    if (!(object3 instanceof XSLTemplate)) continue;
                    ((XSLTemplate)object3).register(componentDeclaration);
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    object3 = componentDeclaration.getSourceElement();
                    if (((StyleElement)object3).isActionCompleted(2)) continue;
                    ((StyleElement)object3).setActionCompleted(2);
                    ((StyleElement)object3).compileDeclaration(compilation, componentDeclaration);
                }
                for (ComponentDeclaration componentDeclaration : this.functionIndex.values()) {
                    object3 = componentDeclaration.getSourceElement();
                    if (((StyleElement)object3).isActionCompleted(4)) continue;
                    ((StyleElement)object3).setActionCompleted(4);
                    ((XSLFunction)object3).typeCheckBody();
                }
                if (compilation.getErrorCount() > 0) {
                    return;
                }
                this.optimizeTopLevel();
                for (ComponentDeclaration componentDeclaration : this.functionIndex.values()) {
                    object3 = componentDeclaration.getSourceElement();
                    if (((StyleElement)object3).isActionCompleted(8)) continue;
                    ((StyleElement)object3).setActionCompleted(8);
                    ((StylesheetComponent)object3).optimize(componentDeclaration);
                }
                if (configuration.isTiming() && configuration.isGenerateByteCode(50)) {
                    configuration.getStandardErrorOutput().println("Generating byte code...");
                }
                this.getDecimalFormatManager().checkConsistency();
                this.overriding = new ExecutableFunctionLibrary(configuration);
                this.underriding = new ExecutableFunctionLibrary(configuration);
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    if (!(componentDeclaration.getSourceElement() instanceof XSLFunction)) continue;
                    object3 = (XSLFunction)componentDeclaration.getSourceElement();
                    if (object3.isOverrideExtensionFunction()) {
                        this.overriding.addFunction(object3.getCompiledFunction());
                        continue;
                    }
                    this.underriding.addFunction(object3.getCompiledFunction());
                }
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    Object object2;
                    object3 = componentDeclaration.getSourceElement();
                    if (!(object3 instanceof StylesheetComponent) || (object2 = ((StylesheetComponent)object3).getCompiledProcedure()) == null) continue;
                    object2.allocateAllBindingSlots(this);
                }
                for (Component component : this.componentIndex.values()) {
                    object3 = component.getProcedure();
                    if (object3 == null || !(object3 instanceof GlobalVariable) || !((GlobalVariable)object3).getVariableQName().hasURI("http://saxon.sf.net/generated-global-variable")) continue;
                    object3.allocateAllBindingSlots(this);
                }
                iterator = this.getKeyManager();
                for (Object object3 : iterator.getAllKeyDefinitionSets()) {
                    if (!object3.getKeyName().hasURI("http://saxon.sf.net/")) continue;
                    for (ComponentDeclaration componentDeclaration : object3.getKeyDefinitions()) {
                        componentDeclaration.makeDeclaringComponent(Visibility.PRIVATE, this);
                        componentDeclaration.allocateAllBindingSlots(this);
                    }
                }
                IAccumulatorManager iAccumulatorManager = this.getAccumulatorManager();
                if (iAccumulatorManager != null) {
                    for (Object object2 : iAccumulatorManager.getAllAccumulators()) {
                        object2.allocateAllBindingSlots(this);
                    }
                }
                object3 = configuration.obtainOptimizer();
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    StyleElement styleElement = componentDeclaration.getSourceElement();
                    if (!(styleElement instanceof StylesheetComponent)) continue;
                    ((StylesheetComponent)styleElement).generateByteCode((Optimizer)object3);
                }
            }
            catch (RuntimeException runtimeException) {
                if (compilation.getErrorCount() != 0) break block20;
                throw runtimeException;
            }
        }
    }

    public void optimizeTopLevel() throws XPathException {
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            StyleElement styleElement = componentDeclaration.getSourceElement();
            if (styleElement instanceof StylesheetComponent && !(styleElement instanceof XSLFunction) && !styleElement.isActionCompleted(8)) {
                styleElement.setActionCompleted(8);
                ((StylesheetComponent)styleElement).optimize(componentDeclaration);
            }
            if (!(styleElement instanceof XSLTemplate)) continue;
            ((XSLTemplate)styleElement).allocatePatternSlotNumbers();
        }
    }

    public void updatePreparedStylesheet(PreparedStylesheet preparedStylesheet) throws XPathException {
        Object object;
        Object object2;
        Object object4;
        Object object522;
        preparedStylesheet.setStylesheetFunctionLibrary(this.stylesheetFunctionLibrary);
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        for (Object object522 : this.functionLibrary.getLibraryList()) {
            if (object522 instanceof StylesheetFunctionLibrary) {
                if (((StylesheetFunctionLibrary)object522).isOverrideExtensionFunction()) {
                    functionLibraryList.addFunctionLibrary((FunctionLibrary)this.overriding);
                    preparedStylesheet.getStylesheetFunctions().addFunctionLibrary((FunctionLibrary)this.overriding);
                    continue;
                }
                functionLibraryList.addFunctionLibrary((FunctionLibrary)this.underriding);
                preparedStylesheet.getStylesheetFunctions().addFunctionLibrary((FunctionLibrary)this.underriding);
                continue;
            }
            functionLibraryList.addFunctionLibrary((FunctionLibrary)object522);
        }
        preparedStylesheet.setFunctionLibrary(functionLibraryList);
        preparedStylesheet.setKeyManager(this.keyManager);
        preparedStylesheet.setAccumulatorManager(this.accumulatorManager);
        preparedStylesheet.setStripsWhitespace(this.stripsWhitespace());
        preparedStylesheet.setPatternSlotSpace(this.largestPatternStackFrame);
        preparedStylesheet.setStripsInputTypeAnnotations(this.getInputTypeAnnotations() == 1);
        preparedStylesheet.setStripperRules(this.stripperRules);
        preparedStylesheet.setCreatesSecondaryResult(this.createsSecondaryResultDocuments);
        for (Object object522 : this.topLevel) {
            if (!(object522.getSourceElement() instanceof XSLCharacterMap) || (object4 = (XSLCharacterMap)object522.getSourceElement()).isRedundant()) continue;
            StructuredQName object32 = object4.getCharacterMapName();
            object2 = new IntHashMap();
            object4.assemble(object2);
            object = new CharacterMap(object2);
            if (preparedStylesheet.getCharacterMapIndex() == null) {
                preparedStylesheet.setCharacterMapIndex(new CharacterMapIndex());
            }
            preparedStylesheet.getCharacterMapIndex().putCharacterMap(object32, object);
        }
        this.ruleManager.computeRankings();
        this.ruleManager.invertStreamableTemplates(this.getConfiguration().obtainOptimizer());
        preparedStylesheet.setRuleManager(this.ruleManager);
        Properties properties = this.gatherOutputProperties(null);
        properties.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion().getStringValue());
        preparedStylesheet.setDefaultOutputProperties(properties);
        object522 = new HashSet(5);
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            if (!(componentDeclaration.getSourceElement() instanceof XSLOutput) || (object = (object2 = (XSLOutput)componentDeclaration.getSourceElement()).getFormatQName()) == null) continue;
            ((HashSet)object522).add(object);
        }
        if (((HashSet)object522).isEmpty()) {
            if (this.needsDynamicOutputProperties) {
                throw new XPathException("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
            }
        } else {
            object4 = ((HashSet)object522).iterator();
            while (object4.hasNext()) {
                StructuredQName structuredQName = (StructuredQName)object4.next();
                object2 = this.gatherOutputProperties(structuredQName);
                if (!this.needsDynamicOutputProperties) continue;
                preparedStylesheet.setOutputProperties(structuredQName, (Properties)object2);
            }
        }
        for (Map.Entry entry : this.templateIndex.entrySet()) {
            preparedStylesheet.putNamedTemplate((StructuredQName)entry.getKey(), ((XSLTemplate)((ComponentDeclaration)entry.getValue()).getSourceElement()).getCompiledTemplate());
        }
        preparedStylesheet.setComponentIndex(this.componentIndex);
        for (Component component : this.componentIndex.values()) {
            if (!(component.getProcedure() instanceof GlobalVariable)) continue;
            object2 = (GlobalVariable)component.getProcedure();
            preparedStylesheet.registerGlobalVariable((GlobalVariable)object2);
            if (object2.isUnused()) continue;
            int n2 = preparedStylesheet.getGlobalVariableMap().allocateSlotNumber(object2.getVariableQName());
            object2.setBinderySlotNumber(n2);
        }
        for (Component component : this.hiddenComponents) {
            if (!(component.getProcedure() instanceof GlobalVariable)) continue;
            object2 = (GlobalVariable)component.getProcedure();
            preparedStylesheet.registerGlobalVariable((GlobalVariable)object2);
            if (object2.isUnused()) continue;
            int n3 = preparedStylesheet.getGlobalVariableMap().allocateSlotNumber(object2.getVariableQName());
            object2.setBinderySlotNumber(n3);
        }
        for (StylesheetPackage stylesheetPackage : this.usedPackages) {
        }
        this.topLevel = null;
        this.templateIndex = null;
        this.completionActions = null;
    }

    protected boolean isImportedSchema(String string) {
        return this.schemaIndex.contains(string);
    }

    protected void addImportedSchema(String string) {
        this.schemaIndex.add(string);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    protected boolean getAttributeSets(StructuredQName structuredQName, List<ComponentDeclaration> list) throws XPathException {
        boolean bl = false;
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            XSLAttributeSet xSLAttributeSet;
            if (!(componentDeclaration.getSourceElement() instanceof XSLAttributeSet) || !(xSLAttributeSet = (XSLAttributeSet)componentDeclaration.getSourceElement()).getAttributeSetName().equals(structuredQName)) continue;
            xSLAttributeSet.incrementReferenceCount();
            list.add(componentDeclaration);
            bl = true;
        }
        return bl;
    }

    public boolean stripsWhitespace() {
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            StyleElement styleElement = componentDeclaration.getSourceElement();
            if (styleElement.getFingerprint() != 198) continue;
            return true;
        }
        return false;
    }

    public void setStripperRules(SpaceStrippingRule spaceStrippingRule) {
        this.stripperRules = spaceStrippingRule;
    }

    public SpaceStrippingRule getStripperRules() {
        return this.stripperRules == null ? NoElementsSpaceStrippingRule.getInstance() : this.stripperRules;
    }

    public void setNeedsDynamicOutputProperties(boolean bl) {
        this.needsDynamicOutputProperties = bl;
    }

    public ComponentDeclaration getCharacterMap(StructuredQName structuredQName) {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            XSLCharacterMap xSLCharacterMap;
            ComponentDeclaration componentDeclaration = (ComponentDeclaration)this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLCharacterMap) || !(xSLCharacterMap = (XSLCharacterMap)componentDeclaration.getSourceElement()).getCharacterMapName().equals(structuredQName)) continue;
            return componentDeclaration;
        }
        return null;
    }

    public void allocatePatternSlots(int n2) {
        if (n2 > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n2;
        }
    }

    protected void compileError(String string, String string2) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCode(string2);
        this.compileError(xPathException);
    }

    protected void compileError(XPathException xPathException) throws XPathException {
        xPathException.setIsStaticError(true);
        this.getRootElement().compileError(xPathException);
    }

    public void addUsedPackage(StylesheetPackage stylesheetPackage) throws XPathException {
        this.usedPackages.add(stylesheetPackage);
        for (Map.Entry<SymbolicName, Component> entry : stylesheetPackage.componentIndex.entrySet()) {
            Component component = entry.getValue();
            Visibility visibility = component.getVisibility();
            Visibility visibility2 = visibility == Visibility.PRIVATE ? Visibility.HIDDEN : visibility;
            final Component component2 = new Component(component.getProcedure(), visibility2, this, component.getDeclaringPackage());
            component2.setOriginalComponent(component);
            component2.setComponentBindings(component.getComponentBindings());
            if (visibility2 == Visibility.HIDDEN) {
                this.hiddenComponents.add(component2);
            } else if (this.componentIndex.get(entry.getKey()) != null) {
                XPathException xPathException = new XPathException("Duplicate " + entry.getKey(), "XTSE3050");
                xPathException.setLocator((SourceLocator)component.getProcedure());
                this.compileError(xPathException);
            } else {
                this.componentIndex.put(entry.getKey(), component2);
            }
            this.addCompletionAction(new Action(){

                @Override
                public void doAction() throws XPathException {
                    List list = component2.getComponentBindings();
                    ArrayList<ComponentBinding> arrayList = new ArrayList<ComponentBinding>(list.size());
                    for (ComponentBinding componentBinding : list) {
                        Visibility visibility = componentBinding.getTarget().getVisibility();
                        block0 : switch (visibility) {
                            case ABSTRACT: 
                            case PUBLIC: {
                                SymbolicName symbolicName = componentBinding.getSymbolicName();
                                ComponentBinding componentBinding2 = new ComponentBinding(symbolicName);
                                componentBinding2.setTarget((Component)StylesheetPackage.this.componentIndex.get(symbolicName), false);
                                arrayList.add(componentBinding2);
                                break;
                            }
                            case FINAL: {
                                arrayList.add(componentBinding);
                                break;
                            }
                            case PRIVATE: {
                                SymbolicName symbolicName = componentBinding.getSymbolicName();
                                ComponentBinding componentBinding2 = new ComponentBinding(symbolicName);
                                for (Component component : StylesheetPackage.this.hiddenComponents) {
                                    if (component.getOriginalComponent() != componentBinding.getTarget()) continue;
                                    componentBinding2.setTarget(component, true);
                                    arrayList.add(componentBinding2);
                                    break block0;
                                }
                                break;
                            }
                        }
                    }
                    component2.setComponentBindings(arrayList);
                }
            });
        }
        if (stylesheetPackage.isCreatesSecondaryResultDocuments()) {
            this.setCreatesSecondaryResultDocuments(true);
        }
    }

    public Iterable<StylesheetPackage> getUsedPackages() {
        return this.usedPackages;
    }

    public void setVersion(DecimalValue decimalValue) {
        this.version = decimalValue;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public DecimalValue getVersion() {
        return this.version;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isRootPackage() {
        return true;
    }

    protected void fixup() throws XPathException {
        for (Action action : this.fixupActions) {
            action.doAction();
        }
    }

    protected void complete() throws XPathException {
        for (Action action : this.completionActions) {
            action.doAction();
        }
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("package");
        expressionPresenter.emitAttribute("name", this.packageName);
        expressionPresenter.emitAttribute("version", this.version.getStringValue());
        if (this.packageVersion != null) {
            expressionPresenter.emitAttribute("package-version", this.packageVersion.getStringValue());
        }
        expressionPresenter.endElement();
    }

    public SlotManager getSlotManager() {
        return null;
    }

    public Collection<StructuredQName> getGlobalVariableNames() {
        return this.globalVariableIndex.keySet();
    }

    public GlobalVariable getGlobalVariable(StructuredQName structuredQName) {
        ComponentDeclaration componentDeclaration = this.globalVariableIndex.get(structuredQName);
        if (componentDeclaration != null) {
            return ((XSLGlobalVariable)componentDeclaration.getSourceElement()).getCompiledVariable();
        }
        return null;
    }

    public void addGlobalVariable(GlobalVariable globalVariable) {
        globalVariable.makeDeclaringComponent(Visibility.PRIVATE, this);
        if (globalVariable.getPackageData() == null) {
            globalVariable.setPackageData(this.makePackageData());
        }
        this.componentIndex.put(new SymbolicName(206, globalVariable.getVariableQName()), globalVariable.getDeclaringComponent());
    }

    private PackageData makePackageData() {
        PackageData packageData = new PackageData(this.getConfiguration());
        packageData.setAllowXPath30(false);
        packageData.setHostLanguage(50);
        return packageData;
    }

    public void setCreatesSecondaryResultDocuments(boolean bl) {
        this.createsSecondaryResultDocuments = bl;
    }

    public boolean isCreatesSecondaryResultDocuments() {
        return this.createsSecondaryResultDocuments;
    }

    public List<XSLGlobalVariable> getGlobalVariables() {
        ArrayList<XSLGlobalVariable> arrayList = null;
        if (this.globalVariableIndex != null) {
            arrayList = new ArrayList<XSLGlobalVariable>(this.globalVariableIndex.size());
            for (ComponentDeclaration componentDeclaration : this.globalVariableIndex.values()) {
                StyleElement styleElement = componentDeclaration.getSourceElement();
                if (!(styleElement instanceof XSLGlobalVariable)) continue;
                XSLGlobalVariable xSLGlobalVariable = (XSLGlobalVariable)styleElement;
                arrayList.add(xSLGlobalVariable);
            }
        }
        return arrayList;
    }

    public static abstract class Action {
        public abstract void doAction() throws XPathException;
    }
}

